/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.deltafi.common.content.Segment;
import org.deltafi.common.converters.KeyValueConverter;
import org.deltafi.common.types.Action;
import org.deltafi.common.types.ActionEventInput;
import org.deltafi.common.types.ActionState;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.DeltaFileStage;
import org.deltafi.common.types.Domain;
import org.deltafi.common.types.Egress;
import org.deltafi.common.types.Enrichment;
import org.deltafi.common.types.FormattedData;
import org.deltafi.common.types.KeyValue;
import org.deltafi.common.types.ProtocolLayer;
import org.deltafi.common.types.SourceInfo;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class DeltaFile {
    @Id
    private String did;
    private List<String> parentDids;
    private List<String> childDids;
    private int requeueCount;
    private Long ingressBytes;
    private Long totalBytes;
    private DeltaFileStage stage;
    private List<Action> actions;
    private SourceInfo sourceInfo;
    private List<ProtocolLayer> protocolStack;
    private List<Domain> domains;
    private Map<String, String> indexedMetadata;
    private List<Enrichment> enrichment;
    private List<Egress> egress;
    private List<FormattedData> formattedData;
    private OffsetDateTime created;
    private OffsetDateTime modified;
    private OffsetDateTime contentDeleted;
    private String contentDeletedReason;
    private OffsetDateTime errorAcknowledged;
    private String errorAcknowledgedReason;
    private Boolean testMode;
    private String testModeReason;
    private Boolean egressed;
    private Boolean filtered;
    private OffsetDateTime replayed;
    private String replayDid;
    @Version
    @JsonIgnore
    private long version;

    public void queueAction(String name) {
        Optional<Action> maybeAction = this.actionNamed(name);
        if (maybeAction.isPresent()) {
            this.setActionState(maybeAction.get(), ActionState.QUEUED, null, null);
        } else {
            this.queueNewAction(name);
        }
    }

    public void queueNewAction(String name) {
        OffsetDateTime now = OffsetDateTime.now();
        this.getActions().add(Action.newBuilder().name(name).state(ActionState.QUEUED).created(now).queued(now).modified(now).build());
    }

    public void errorAction(ActionEventInput event) {
        this.errorAction(event.getAction(), event.getStart(), event.getStop(), event.getError().getCause(), event.getError().getContext());
    }

    public Optional<Action> actionNamed(String name) {
        return this.getActions().stream().filter(a -> a.getName().equals(name) && !this.retried((Action)a)).reduce((first, second) -> second);
    }

    public boolean isNewAction(String name) {
        return this.actionNamed(name).isEmpty();
    }

    public void queueActionsIfNew(List<String> actions) {
        actions.stream().filter(this::isNewAction).forEach(this::queueNewAction);
    }

    public void completeAction(ActionEventInput event) {
        this.completeAction(event.getAction(), event.getStart(), event.getStop());
    }

    public void completeAction(String name, OffsetDateTime start, OffsetDateTime stop) {
        this.getActions().stream().filter(action -> action.getName().equals(name) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.COMPLETE, start, stop));
    }

    public void filterAction(ActionEventInput event, String filterMessage) {
        this.getActions().stream().filter(action -> action.getName().equals(event.getAction()) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.FILTERED, event.getStart(), event.getStop(), filterMessage, null));
    }

    public void splitAction(ActionEventInput event) {
        this.getActions().stream().filter(action -> action.getName().equals(event.getAction()) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.SPLIT, event.getStart(), event.getStop()));
    }

    public void errorAction(ActionEventInput event, String errorCause, String errorContext) {
        this.errorAction(event.getAction(), event.getStart(), event.getStop(), errorCause, errorContext);
    }

    public void errorAction(String name, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext) {
        this.getActions().stream().filter(action -> action.getName().equals(name) && !this.terminalState(action.getState())).forEach(action -> this.setActionState((Action)action, ActionState.ERROR, start, stop, errorCause, errorContext));
    }

    public List<String> retryErrors() {
        List<Action> actionsToRetry = this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.ERROR)).collect(Collectors.toList());
        actionsToRetry.forEach(action -> action.setState(ActionState.RETRIED));
        return actionsToRetry.stream().map(Action::getName).collect(Collectors.toList());
    }

    private void setActionState(Action action, ActionState actionState, OffsetDateTime start, OffsetDateTime stop) {
        this.setActionState(action, actionState, start, stop, null, null);
    }

    private void setActionState(Action action, ActionState actionState, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext) {
        OffsetDateTime now = OffsetDateTime.now();
        action.setState(actionState);
        if (action.getCreated() == null) {
            action.setCreated(now);
        }
        action.setStart(start);
        action.setStop(stop);
        action.setModified(now);
        action.setErrorCause(errorCause);
        action.setErrorContext(errorContext);
        this.setModified(now);
    }

    public void setTestMode(String reason) {
        this.testMode = true;
        this.testModeReason = reason;
    }

    public List<String> queuedActions() {
        return this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.QUEUED)).map(Action::getName).collect(Collectors.toList());
    }

    public Map<String, Domain> domainMap() {
        return this.getDomains().stream().collect(Collectors.toMap(Domain::getName, Function.identity()));
    }

    public Map<String, Enrichment> enrichmentMap() {
        return this.getEnrichment().stream().collect(Collectors.toMap(Enrichment::getName, Function.identity()));
    }

    public void addDomain(@NotNull String domainKey, String domainValue, @NotNull String mediaType) {
        Optional<Domain> domain = this.getDomains().stream().filter(d -> d.getName().equals(domainKey)).findFirst();
        if (domain.isPresent()) {
            domain.get().setValue(domainValue);
        } else {
            this.getDomains().add(new Domain(domainKey, domainValue, mediaType));
        }
    }

    public boolean hasDomains(List<String> domains) {
        return domains.stream().allMatch(domain -> this.getDomains().stream().anyMatch(d -> d.getName().equals(domain)));
    }

    public void addIndexedMetadata(Map<String, String> metadata) {
        if (null == metadata) {
            return;
        }
        this.indexedMetadata.putAll(metadata);
    }

    public void addEgressFlow(@NotNull String flow) {
        if (!this.getEgress().stream().map(Egress::getFlow).collect(Collectors.toList()).contains(flow)) {
            this.getEgress().add(new Egress(flow));
        }
    }

    public Enrichment getEnrichment(String enrichment) {
        return this.getEnrichment().stream().filter(e -> e.getName().equals(enrichment)).findFirst().orElse(null);
    }

    public void addEnrichment(@NotNull String enrichmentKey, String enrichmentValue) {
        this.addEnrichment(enrichmentKey, enrichmentValue, "application/octet-stream");
    }

    public void addEnrichment(@NotNull String enrichmentKey, String enrichmentValue, @NotNull String mediaType) {
        Optional<Enrichment> enrichment = this.getEnrichment().stream().filter(d -> d.getName().equals(enrichmentKey)).findFirst();
        if (enrichment.isPresent()) {
            enrichment.get().setValue(enrichmentValue);
        } else {
            this.getEnrichment().add(new Enrichment(enrichmentKey, enrichmentValue, mediaType));
        }
    }

    public boolean hasEnrichments(List<String> enrichments) {
        return enrichments.stream().allMatch(enrichment -> this.getEnrichment().stream().anyMatch(e -> e.getName().equals(enrichment)));
    }

    public boolean hasErroredAction() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.ERROR));
    }

    public boolean hasPendingActions() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.QUEUED));
    }

    public boolean hasFilteredAction() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.FILTERED));
    }

    public boolean hasSplitAction() {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)ActionState.SPLIT));
    }

    public boolean noPendingAction(String name) {
        return this.getActions().stream().noneMatch(action -> action.getName().equals(name) && !this.terminalState(action.getState()));
    }

    private boolean terminalState(ActionState actionState) {
        return !actionState.equals((Object)ActionState.QUEUED);
    }

    private boolean retried(Action action) {
        return action.getState().equals((Object)ActionState.RETRIED);
    }

    public boolean hasTerminalAction(String name) {
        return this.getActions().stream().anyMatch(action -> action.getName().equals(name) && !this.retried((Action)action) && this.terminalState(action.getState()));
    }

    public boolean hasCompletedAction(String name) {
        return this.getActions().stream().anyMatch(action -> action.getName().equals(name) && action.getState().equals((Object)ActionState.COMPLETE));
    }

    public boolean hasCompletedActions(List<String> names) {
        return names.stream().allMatch(this::hasCompletedAction);
    }

    public void markForDelete(String policy) {
        OffsetDateTime now = OffsetDateTime.now();
        this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.QUEUED)).forEach(action -> {
            action.setModified(now);
            action.setState(ActionState.ERROR);
            action.setErrorCause("DeltaFile marked for deletion by " + policy + " policy");
        });
        this.setContentDeleted(now);
        this.setContentDeletedReason(policy);
    }

    public String sourceMetadata(String key) {
        return this.sourceMetadata(key, null);
    }

    public String sourceMetadata(String key, String defaultValue) {
        return this.getSourceInfo().getMetadata().stream().filter(k -> k.getKey().equals(key)).findFirst().map(KeyValue::getValue).orElse(defaultValue);
    }

    @JsonIgnore
    public ProtocolLayer getLastProtocolLayer() {
        return Objects.isNull(this.getProtocolStack()) || this.getProtocolStack().isEmpty() ? null : this.getProtocolStack().get(this.getProtocolStack().size() - 1);
    }

    @JsonIgnore
    @NotNull
    public List<Content> getLastProtocolLayerContent() {
        if (Objects.isNull(this.getLastProtocolLayer()) || Objects.isNull(this.getLastProtocolLayer().getContent())) {
            return Collections.emptyList();
        }
        return this.getLastProtocolLayer().getContent();
    }

    @JsonIgnore
    @NotNull
    public List<KeyValue> getLastProtocolLayerMetadata() {
        if (Objects.isNull(this.getLastProtocolLayer()) || Objects.isNull(this.getLastProtocolLayer().getMetadata())) {
            return Collections.emptyList();
        }
        return this.getLastProtocolLayer().getMetadata();
    }

    @JsonIgnore
    @NotNull
    public Map<String, String> getLastProtocolLayerMetadataAsMap() {
        return KeyValueConverter.convertKeyValues(this.getLastProtocolLayerMetadata());
    }

    @NotNull
    public List<Domain> getDomains() {
        return this.domains == null ? Collections.emptyList() : this.domains;
    }

    @NotNull
    public List<Enrichment> getEnrichment() {
        return this.enrichment == null ? Collections.emptyList() : this.enrichment;
    }

    @NotNull
    public List<Egress> getEgress() {
        if (this.egress == null) {
            this.egress = new ArrayList<Egress>();
        }
        return this.egress;
    }

    public DeltaFile forQueue(String actionName) {
        DeltaFileBuilder builder = DeltaFile.newBuilder().did(this.getDid()).sourceInfo(this.getSourceInfo()).domains(this.getDomains()).enrichment(this.getEnrichment()).formattedData(this.getFormattedData().stream().filter(f -> f.getEgressActions().contains(actionName) || Objects.nonNull(f.getValidateActions()) && f.getValidateActions().contains(actionName)).collect(Collectors.toList()));
        if (!this.getProtocolStack().isEmpty()) {
            builder.protocolStack(Collections.singletonList(this.getLastProtocolLayer()));
        }
        return builder.build();
    }

    public List<Segment> storedSegments() {
        List<Segment> segments = this.getProtocolStack().stream().flatMap(p -> p.getContent().stream()).map(Content::getContentReference).flatMap(c -> c.getSegments().stream()).filter(s -> s.getDid().equals(this.getDid())).collect(Collectors.toList());
        segments.addAll(this.getFormattedData().stream().map(FormattedData::getContentReference).flatMap(f -> f.getSegments().stream()).filter(s -> s.getDid().equals(this.getDid())).collect(Collectors.toList()));
        return segments;
    }

    public void cancelQueuedActions() {
        OffsetDateTime now = OffsetDateTime.now();
        this.getActions().stream().filter(a -> a.getState().equals((Object)ActionState.QUEUED)).forEach(a -> {
            a.setState(ActionState.CANCELLED);
            a.setModified(now);
        });
        this.setModified(now);
    }

    public void incrementRequeueCount() {
        ++this.requeueCount;
    }

    public boolean inactiveStage() {
        return this.getStage() == DeltaFileStage.COMPLETE || this.getStage() == DeltaFileStage.ERROR || this.getStage() == DeltaFileStage.CANCELLED;
    }

    private static Map<String, String> $default$indexedMetadata() {
        return new HashMap<String, String>();
    }

    private static List<Egress> $default$egress() {
        return new ArrayList<Egress>();
    }

    public static DeltaFileBuilder newBuilder() {
        return new DeltaFileBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public List<String> getParentDids() {
        return this.parentDids;
    }

    public List<String> getChildDids() {
        return this.childDids;
    }

    public int getRequeueCount() {
        return this.requeueCount;
    }

    public Long getIngressBytes() {
        return this.ingressBytes;
    }

    public Long getTotalBytes() {
        return this.totalBytes;
    }

    public DeltaFileStage getStage() {
        return this.stage;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public List<ProtocolLayer> getProtocolStack() {
        return this.protocolStack;
    }

    public Map<String, String> getIndexedMetadata() {
        return this.indexedMetadata;
    }

    public List<FormattedData> getFormattedData() {
        return this.formattedData;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OffsetDateTime getModified() {
        return this.modified;
    }

    public OffsetDateTime getContentDeleted() {
        return this.contentDeleted;
    }

    public String getContentDeletedReason() {
        return this.contentDeletedReason;
    }

    public OffsetDateTime getErrorAcknowledged() {
        return this.errorAcknowledged;
    }

    public String getErrorAcknowledgedReason() {
        return this.errorAcknowledgedReason;
    }

    public Boolean getTestMode() {
        return this.testMode;
    }

    public String getTestModeReason() {
        return this.testModeReason;
    }

    public Boolean getEgressed() {
        return this.egressed;
    }

    public Boolean getFiltered() {
        return this.filtered;
    }

    public OffsetDateTime getReplayed() {
        return this.replayed;
    }

    public String getReplayDid() {
        return this.replayDid;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setParentDids(List<String> parentDids) {
        this.parentDids = parentDids;
    }

    public void setChildDids(List<String> childDids) {
        this.childDids = childDids;
    }

    public void setRequeueCount(int requeueCount) {
        this.requeueCount = requeueCount;
    }

    public void setIngressBytes(Long ingressBytes) {
        this.ingressBytes = ingressBytes;
    }

    public void setTotalBytes(Long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setStage(DeltaFileStage stage) {
        this.stage = stage;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setProtocolStack(List<ProtocolLayer> protocolStack) {
        this.protocolStack = protocolStack;
    }

    public void setDomains(List<Domain> domains) {
        this.domains = domains;
    }

    public void setIndexedMetadata(Map<String, String> indexedMetadata) {
        this.indexedMetadata = indexedMetadata;
    }

    public void setEnrichment(List<Enrichment> enrichment) {
        this.enrichment = enrichment;
    }

    public void setEgress(List<Egress> egress) {
        this.egress = egress;
    }

    public void setFormattedData(List<FormattedData> formattedData) {
        this.formattedData = formattedData;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public void setModified(OffsetDateTime modified) {
        this.modified = modified;
    }

    public void setContentDeleted(OffsetDateTime contentDeleted) {
        this.contentDeleted = contentDeleted;
    }

    public void setContentDeletedReason(String contentDeletedReason) {
        this.contentDeletedReason = contentDeletedReason;
    }

    public void setErrorAcknowledged(OffsetDateTime errorAcknowledged) {
        this.errorAcknowledged = errorAcknowledged;
    }

    public void setErrorAcknowledgedReason(String errorAcknowledgedReason) {
        this.errorAcknowledgedReason = errorAcknowledgedReason;
    }

    public void setTestModeReason(String testModeReason) {
        this.testModeReason = testModeReason;
    }

    public void setEgressed(Boolean egressed) {
        this.egressed = egressed;
    }

    public void setFiltered(Boolean filtered) {
        this.filtered = filtered;
    }

    public void setReplayed(OffsetDateTime replayed) {
        this.replayed = replayed;
    }

    public void setReplayDid(String replayDid) {
        this.replayDid = replayDid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeltaFile)) {
            return false;
        }
        DeltaFile other = (DeltaFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequeueCount() != other.getRequeueCount()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Long this$ingressBytes = this.getIngressBytes();
        Long other$ingressBytes = other.getIngressBytes();
        if (this$ingressBytes == null ? other$ingressBytes != null : !((Object)this$ingressBytes).equals(other$ingressBytes)) {
            return false;
        }
        Long this$totalBytes = this.getTotalBytes();
        Long other$totalBytes = other.getTotalBytes();
        if (this$totalBytes == null ? other$totalBytes != null : !((Object)this$totalBytes).equals(other$totalBytes)) {
            return false;
        }
        Boolean this$testMode = this.getTestMode();
        Boolean other$testMode = other.getTestMode();
        if (this$testMode == null ? other$testMode != null : !((Object)this$testMode).equals(other$testMode)) {
            return false;
        }
        Boolean this$egressed = this.getEgressed();
        Boolean other$egressed = other.getEgressed();
        if (this$egressed == null ? other$egressed != null : !((Object)this$egressed).equals(other$egressed)) {
            return false;
        }
        Boolean this$filtered = this.getFiltered();
        Boolean other$filtered = other.getFiltered();
        if (this$filtered == null ? other$filtered != null : !((Object)this$filtered).equals(other$filtered)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        List<String> this$parentDids = this.getParentDids();
        List<String> other$parentDids = other.getParentDids();
        if (this$parentDids == null ? other$parentDids != null : !((Object)this$parentDids).equals(other$parentDids)) {
            return false;
        }
        List<String> this$childDids = this.getChildDids();
        List<String> other$childDids = other.getChildDids();
        if (this$childDids == null ? other$childDids != null : !((Object)this$childDids).equals(other$childDids)) {
            return false;
        }
        DeltaFileStage this$stage = this.getStage();
        DeltaFileStage other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        SourceInfo this$sourceInfo = this.getSourceInfo();
        SourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !((Object)this$sourceInfo).equals(other$sourceInfo)) {
            return false;
        }
        List<ProtocolLayer> this$protocolStack = this.getProtocolStack();
        List<ProtocolLayer> other$protocolStack = other.getProtocolStack();
        if (this$protocolStack == null ? other$protocolStack != null : !((Object)this$protocolStack).equals(other$protocolStack)) {
            return false;
        }
        List<Domain> this$domains = this.getDomains();
        List<Domain> other$domains = other.getDomains();
        if (this$domains == null ? other$domains != null : !((Object)this$domains).equals(other$domains)) {
            return false;
        }
        Map<String, String> this$indexedMetadata = this.getIndexedMetadata();
        Map<String, String> other$indexedMetadata = other.getIndexedMetadata();
        if (this$indexedMetadata == null ? other$indexedMetadata != null : !((Object)this$indexedMetadata).equals(other$indexedMetadata)) {
            return false;
        }
        List<Enrichment> this$enrichment = this.getEnrichment();
        List<Enrichment> other$enrichment = other.getEnrichment();
        if (this$enrichment == null ? other$enrichment != null : !((Object)this$enrichment).equals(other$enrichment)) {
            return false;
        }
        List<Egress> this$egress = this.getEgress();
        List<Egress> other$egress = other.getEgress();
        if (this$egress == null ? other$egress != null : !((Object)this$egress).equals(other$egress)) {
            return false;
        }
        List<FormattedData> this$formattedData = this.getFormattedData();
        List<FormattedData> other$formattedData = other.getFormattedData();
        if (this$formattedData == null ? other$formattedData != null : !((Object)this$formattedData).equals(other$formattedData)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        OffsetDateTime this$modified = this.getModified();
        OffsetDateTime other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        OffsetDateTime this$contentDeleted = this.getContentDeleted();
        OffsetDateTime other$contentDeleted = other.getContentDeleted();
        if (this$contentDeleted == null ? other$contentDeleted != null : !((Object)this$contentDeleted).equals(other$contentDeleted)) {
            return false;
        }
        String this$contentDeletedReason = this.getContentDeletedReason();
        String other$contentDeletedReason = other.getContentDeletedReason();
        if (this$contentDeletedReason == null ? other$contentDeletedReason != null : !this$contentDeletedReason.equals(other$contentDeletedReason)) {
            return false;
        }
        OffsetDateTime this$errorAcknowledged = this.getErrorAcknowledged();
        OffsetDateTime other$errorAcknowledged = other.getErrorAcknowledged();
        if (this$errorAcknowledged == null ? other$errorAcknowledged != null : !((Object)this$errorAcknowledged).equals(other$errorAcknowledged)) {
            return false;
        }
        String this$errorAcknowledgedReason = this.getErrorAcknowledgedReason();
        String other$errorAcknowledgedReason = other.getErrorAcknowledgedReason();
        if (this$errorAcknowledgedReason == null ? other$errorAcknowledgedReason != null : !this$errorAcknowledgedReason.equals(other$errorAcknowledgedReason)) {
            return false;
        }
        String this$testModeReason = this.getTestModeReason();
        String other$testModeReason = other.getTestModeReason();
        if (this$testModeReason == null ? other$testModeReason != null : !this$testModeReason.equals(other$testModeReason)) {
            return false;
        }
        OffsetDateTime this$replayed = this.getReplayed();
        OffsetDateTime other$replayed = other.getReplayed();
        if (this$replayed == null ? other$replayed != null : !((Object)this$replayed).equals(other$replayed)) {
            return false;
        }
        String this$replayDid = this.getReplayDid();
        String other$replayDid = other.getReplayDid();
        return !(this$replayDid == null ? other$replayDid != null : !this$replayDid.equals(other$replayDid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeltaFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRequeueCount();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Long $ingressBytes = this.getIngressBytes();
        result = result * 59 + ($ingressBytes == null ? 43 : ((Object)$ingressBytes).hashCode());
        Long $totalBytes = this.getTotalBytes();
        result = result * 59 + ($totalBytes == null ? 43 : ((Object)$totalBytes).hashCode());
        Boolean $testMode = this.getTestMode();
        result = result * 59 + ($testMode == null ? 43 : ((Object)$testMode).hashCode());
        Boolean $egressed = this.getEgressed();
        result = result * 59 + ($egressed == null ? 43 : ((Object)$egressed).hashCode());
        Boolean $filtered = this.getFiltered();
        result = result * 59 + ($filtered == null ? 43 : ((Object)$filtered).hashCode());
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        List<String> $parentDids = this.getParentDids();
        result = result * 59 + ($parentDids == null ? 43 : ((Object)$parentDids).hashCode());
        List<String> $childDids = this.getChildDids();
        result = result * 59 + ($childDids == null ? 43 : ((Object)$childDids).hashCode());
        DeltaFileStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        SourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : ((Object)$sourceInfo).hashCode());
        List<ProtocolLayer> $protocolStack = this.getProtocolStack();
        result = result * 59 + ($protocolStack == null ? 43 : ((Object)$protocolStack).hashCode());
        List<Domain> $domains = this.getDomains();
        result = result * 59 + ($domains == null ? 43 : ((Object)$domains).hashCode());
        Map<String, String> $indexedMetadata = this.getIndexedMetadata();
        result = result * 59 + ($indexedMetadata == null ? 43 : ((Object)$indexedMetadata).hashCode());
        List<Enrichment> $enrichment = this.getEnrichment();
        result = result * 59 + ($enrichment == null ? 43 : ((Object)$enrichment).hashCode());
        List<Egress> $egress = this.getEgress();
        result = result * 59 + ($egress == null ? 43 : ((Object)$egress).hashCode());
        List<FormattedData> $formattedData = this.getFormattedData();
        result = result * 59 + ($formattedData == null ? 43 : ((Object)$formattedData).hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        OffsetDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        OffsetDateTime $contentDeleted = this.getContentDeleted();
        result = result * 59 + ($contentDeleted == null ? 43 : ((Object)$contentDeleted).hashCode());
        String $contentDeletedReason = this.getContentDeletedReason();
        result = result * 59 + ($contentDeletedReason == null ? 43 : $contentDeletedReason.hashCode());
        OffsetDateTime $errorAcknowledged = this.getErrorAcknowledged();
        result = result * 59 + ($errorAcknowledged == null ? 43 : ((Object)$errorAcknowledged).hashCode());
        String $errorAcknowledgedReason = this.getErrorAcknowledgedReason();
        result = result * 59 + ($errorAcknowledgedReason == null ? 43 : $errorAcknowledgedReason.hashCode());
        String $testModeReason = this.getTestModeReason();
        result = result * 59 + ($testModeReason == null ? 43 : $testModeReason.hashCode());
        OffsetDateTime $replayed = this.getReplayed();
        result = result * 59 + ($replayed == null ? 43 : ((Object)$replayed).hashCode());
        String $replayDid = this.getReplayDid();
        result = result * 59 + ($replayDid == null ? 43 : $replayDid.hashCode());
        return result;
    }

    public String toString() {
        return "DeltaFile(did=" + this.getDid() + ", parentDids=" + this.getParentDids() + ", childDids=" + this.getChildDids() + ", requeueCount=" + this.getRequeueCount() + ", ingressBytes=" + this.getIngressBytes() + ", totalBytes=" + this.getTotalBytes() + ", stage=" + this.getStage() + ", actions=" + this.getActions() + ", sourceInfo=" + this.getSourceInfo() + ", protocolStack=" + this.getProtocolStack() + ", domains=" + this.getDomains() + ", indexedMetadata=" + this.getIndexedMetadata() + ", enrichment=" + this.getEnrichment() + ", egress=" + this.getEgress() + ", formattedData=" + this.getFormattedData() + ", created=" + this.getCreated() + ", modified=" + this.getModified() + ", contentDeleted=" + this.getContentDeleted() + ", contentDeletedReason=" + this.getContentDeletedReason() + ", errorAcknowledged=" + this.getErrorAcknowledged() + ", errorAcknowledgedReason=" + this.getErrorAcknowledgedReason() + ", testMode=" + this.getTestMode() + ", testModeReason=" + this.getTestModeReason() + ", egressed=" + this.getEgressed() + ", filtered=" + this.getFiltered() + ", replayed=" + this.getReplayed() + ", replayDid=" + this.getReplayDid() + ", version=" + this.getVersion() + ")";
    }

    public DeltaFile() {
        this.indexedMetadata = DeltaFile.$default$indexedMetadata();
        this.egress = DeltaFile.$default$egress();
    }

    public DeltaFile(String did, List<String> parentDids, List<String> childDids, int requeueCount, Long ingressBytes, Long totalBytes, DeltaFileStage stage, List<Action> actions, SourceInfo sourceInfo, List<ProtocolLayer> protocolStack, List<Domain> domains, Map<String, String> indexedMetadata, List<Enrichment> enrichment, List<Egress> egress, List<FormattedData> formattedData, OffsetDateTime created, OffsetDateTime modified, OffsetDateTime contentDeleted, String contentDeletedReason, OffsetDateTime errorAcknowledged, String errorAcknowledgedReason, Boolean testMode, String testModeReason, Boolean egressed, Boolean filtered, OffsetDateTime replayed, String replayDid, long version) {
        this.did = did;
        this.parentDids = parentDids;
        this.childDids = childDids;
        this.requeueCount = requeueCount;
        this.ingressBytes = ingressBytes;
        this.totalBytes = totalBytes;
        this.stage = stage;
        this.actions = actions;
        this.sourceInfo = sourceInfo;
        this.protocolStack = protocolStack;
        this.domains = domains;
        this.indexedMetadata = indexedMetadata;
        this.enrichment = enrichment;
        this.egress = egress;
        this.formattedData = formattedData;
        this.created = created;
        this.modified = modified;
        this.contentDeleted = contentDeleted;
        this.contentDeletedReason = contentDeletedReason;
        this.errorAcknowledged = errorAcknowledged;
        this.errorAcknowledgedReason = errorAcknowledgedReason;
        this.testMode = testMode;
        this.testModeReason = testModeReason;
        this.egressed = egressed;
        this.filtered = filtered;
        this.replayed = replayed;
        this.replayDid = replayDid;
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    @JsonIgnore
    public void setVersion(long version) {
        this.version = version;
    }

    public static class DeltaFileBuilder {
        private String did;
        private List<String> parentDids;
        private List<String> childDids;
        private int requeueCount;
        private Long ingressBytes;
        private Long totalBytes;
        private DeltaFileStage stage;
        private List<Action> actions;
        private SourceInfo sourceInfo;
        private List<ProtocolLayer> protocolStack;
        private List<Domain> domains;
        private boolean indexedMetadata$set;
        private Map<String, String> indexedMetadata$value;
        private List<Enrichment> enrichment;
        private boolean egress$set;
        private List<Egress> egress$value;
        private List<FormattedData> formattedData;
        private OffsetDateTime created;
        private OffsetDateTime modified;
        private OffsetDateTime contentDeleted;
        private String contentDeletedReason;
        private OffsetDateTime errorAcknowledged;
        private String errorAcknowledgedReason;
        private Boolean testMode;
        private String testModeReason;
        private Boolean egressed;
        private Boolean filtered;
        private OffsetDateTime replayed;
        private String replayDid;
        private long version;

        DeltaFileBuilder() {
        }

        public DeltaFileBuilder did(String did) {
            this.did = did;
            return this;
        }

        public DeltaFileBuilder parentDids(List<String> parentDids) {
            this.parentDids = parentDids;
            return this;
        }

        public DeltaFileBuilder childDids(List<String> childDids) {
            this.childDids = childDids;
            return this;
        }

        public DeltaFileBuilder requeueCount(int requeueCount) {
            this.requeueCount = requeueCount;
            return this;
        }

        public DeltaFileBuilder ingressBytes(Long ingressBytes) {
            this.ingressBytes = ingressBytes;
            return this;
        }

        public DeltaFileBuilder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public DeltaFileBuilder stage(DeltaFileStage stage) {
            this.stage = stage;
            return this;
        }

        public DeltaFileBuilder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public DeltaFileBuilder sourceInfo(SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public DeltaFileBuilder protocolStack(List<ProtocolLayer> protocolStack) {
            this.protocolStack = protocolStack;
            return this;
        }

        public DeltaFileBuilder domains(List<Domain> domains) {
            this.domains = domains;
            return this;
        }

        public DeltaFileBuilder indexedMetadata(Map<String, String> indexedMetadata) {
            this.indexedMetadata$value = indexedMetadata;
            this.indexedMetadata$set = true;
            return this;
        }

        public DeltaFileBuilder enrichment(List<Enrichment> enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public DeltaFileBuilder egress(List<Egress> egress) {
            this.egress$value = egress;
            this.egress$set = true;
            return this;
        }

        public DeltaFileBuilder formattedData(List<FormattedData> formattedData) {
            this.formattedData = formattedData;
            return this;
        }

        public DeltaFileBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public DeltaFileBuilder modified(OffsetDateTime modified) {
            this.modified = modified;
            return this;
        }

        public DeltaFileBuilder contentDeleted(OffsetDateTime contentDeleted) {
            this.contentDeleted = contentDeleted;
            return this;
        }

        public DeltaFileBuilder contentDeletedReason(String contentDeletedReason) {
            this.contentDeletedReason = contentDeletedReason;
            return this;
        }

        public DeltaFileBuilder errorAcknowledged(OffsetDateTime errorAcknowledged) {
            this.errorAcknowledged = errorAcknowledged;
            return this;
        }

        public DeltaFileBuilder errorAcknowledgedReason(String errorAcknowledgedReason) {
            this.errorAcknowledgedReason = errorAcknowledgedReason;
            return this;
        }

        public DeltaFileBuilder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public DeltaFileBuilder testModeReason(String testModeReason) {
            this.testModeReason = testModeReason;
            return this;
        }

        public DeltaFileBuilder egressed(Boolean egressed) {
            this.egressed = egressed;
            return this;
        }

        public DeltaFileBuilder filtered(Boolean filtered) {
            this.filtered = filtered;
            return this;
        }

        public DeltaFileBuilder replayed(OffsetDateTime replayed) {
            this.replayed = replayed;
            return this;
        }

        public DeltaFileBuilder replayDid(String replayDid) {
            this.replayDid = replayDid;
            return this;
        }

        @JsonIgnore
        public DeltaFileBuilder version(long version) {
            this.version = version;
            return this;
        }

        public DeltaFile build() {
            Map<String, String> indexedMetadata$value = this.indexedMetadata$value;
            if (!this.indexedMetadata$set) {
                indexedMetadata$value = DeltaFile.$default$indexedMetadata();
            }
            List<Egress> egress$value = this.egress$value;
            if (!this.egress$set) {
                egress$value = DeltaFile.$default$egress();
            }
            return new DeltaFile(this.did, this.parentDids, this.childDids, this.requeueCount, this.ingressBytes, this.totalBytes, this.stage, this.actions, this.sourceInfo, this.protocolStack, this.domains, indexedMetadata$value, this.enrichment, egress$value, this.formattedData, this.created, this.modified, this.contentDeleted, this.contentDeletedReason, this.errorAcknowledged, this.errorAcknowledgedReason, this.testMode, this.testModeReason, this.egressed, this.filtered, this.replayed, this.replayDid, this.version);
        }

        public String toString() {
            return "DeltaFile.DeltaFileBuilder(did=" + this.did + ", parentDids=" + this.parentDids + ", childDids=" + this.childDids + ", requeueCount=" + this.requeueCount + ", ingressBytes=" + this.ingressBytes + ", totalBytes=" + this.totalBytes + ", stage=" + this.stage + ", actions=" + this.actions + ", sourceInfo=" + this.sourceInfo + ", protocolStack=" + this.protocolStack + ", domains=" + this.domains + ", indexedMetadata$value=" + this.indexedMetadata$value + ", enrichment=" + this.enrichment + ", egress$value=" + this.egress$value + ", formattedData=" + this.formattedData + ", created=" + this.created + ", modified=" + this.modified + ", contentDeleted=" + this.contentDeleted + ", contentDeletedReason=" + this.contentDeletedReason + ", errorAcknowledged=" + this.errorAcknowledged + ", errorAcknowledgedReason=" + this.errorAcknowledgedReason + ", testMode=" + this.testMode + ", testModeReason=" + this.testModeReason + ", egressed=" + this.egressed + ", filtered=" + this.filtered + ", replayed=" + this.replayed + ", replayDid=" + this.replayDid + ", version=" + this.version + ")";
        }
    }
}

