/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.deltafi.common.action.ActionEventQueueProperties;
import org.deltafi.common.queue.jedis.JedisKeyedBlockingQueue;
import org.deltafi.common.types.ActionEventInput;
import org.deltafi.common.types.ActionInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class ActionEventQueue {
    private static final Logger log = LoggerFactory.getLogger(ActionEventQueue.class);
    private final JedisKeyedBlockingQueue jedisKeyedBlockingQueue;

    public ActionEventQueue(ActionEventQueueProperties actionEventQueueProperties, int poolSize) throws URISyntaxException {
        int maxIdle = poolSize > 0 ? poolSize : actionEventQueueProperties.getMaxIdle();
        int maxTotal = poolSize > 0 ? poolSize : actionEventQueueProperties.getMaxTotal();
        this.jedisKeyedBlockingQueue = new JedisKeyedBlockingQueue(actionEventQueueProperties.getUrl(), actionEventQueueProperties.getPassword().orElse(""), maxIdle, maxTotal);
        log.info("Jedis pool size: " + maxTotal);
    }

    public void putActions(List<ActionInput> actionInputs) throws JedisConnectionException {
        ArrayList<Pair<String, Object>> actions = new ArrayList<Pair<String, Object>>();
        for (ActionInput actionInput : actionInputs) {
            actions.add((Pair<String, Object>)Pair.of((Object)actionInput.getQueueName(), (Object)actionInput));
        }
        try {
            this.jedisKeyedBlockingQueue.put(actions);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to convert action to JSON", (Throwable)e);
        }
    }

    public ActionInput takeAction(String actionClassName) throws JsonProcessingException, JedisConnectionException {
        return this.jedisKeyedBlockingQueue.take(actionClassName, ActionInput.class);
    }

    public void putResult(ActionEventInput result) throws JsonProcessingException, JedisConnectionException {
        this.jedisKeyedBlockingQueue.put("dgs", result);
    }

    public ActionEventInput takeResult() throws JsonProcessingException {
        return this.jedisKeyedBlockingQueue.take("dgs", ActionEventInput.class);
    }

    public void drop(List<String> actionNames) {
        this.jedisKeyedBlockingQueue.drop(actionNames);
    }
}

