/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.http.client.feign;

import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import javax.net.ssl.SSLContext;

public class FeignClientFactory {
    public static <T> T build(Class<T> targetClass, String url) {
        return FeignClientFactory.build(targetClass, url, null);
    }

    public static <T> T build(Class<T> targetClass, String url, SSLContext sslContext) {
        Feign.Builder builder = Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).retryer((Retryer)new Retryer.Default(1000L, 5000L, 5)).logger((Logger)new Slf4jLogger(targetClass)).logLevel(Logger.Level.FULL);
        if (sslContext != null) {
            builder.client((Client)new Client.Default(sslContext.getSocketFactory(), null));
        }
        return (T)builder.target(targetClass, url);
    }
}

