/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.deltafi.common.converters.KeyValueConverter;
import org.deltafi.common.types.KeyValue;
import org.jetbrains.annotations.NotNull;

public class Metric {
    private String name;
    private long value;
    private List<KeyValue> tags;

    public Metric(String name, long value, @NotNull Map<String, String> tags) {
        this.name = name;
        this.value = value;
        this.tags = KeyValueConverter.fromMap(tags);
    }

    public Metric(String name, long value) {
        this.name = name;
        this.value = value;
        this.tags = new ArrayList<KeyValue>();
    }

    @JsonIgnore
    public Map<String, String> getTagsAsMap() {
        return KeyValueConverter.convertKeyValues(this.tags);
    }

    public void addTag(KeyValue keyValue) {
        Optional<KeyValue> existing = this.tags.stream().filter(kv -> kv.getKey().equals(keyValue.getKey())).findFirst();
        if (existing.isPresent()) {
            existing.get().setValue(keyValue.getValue());
        } else {
            this.tags.add(keyValue);
        }
    }

    public Metric addTag(List<KeyValue> keyValues) {
        if (keyValues == null) {
            return this;
        }
        for (KeyValue keyValue : keyValues) {
            this.addTag(keyValue);
        }
        return this;
    }

    public Metric addTag(String key, String value) {
        this.addTag(new KeyValue(key, value));
        return this;
    }

    public Metric addTags(@NotNull Map<String, String> map) {
        map.forEach(this::addTag);
        return this;
    }

    public void removeTag(String key) {
        this.tags.removeIf(kv -> kv.getKey().equals(key));
    }

    @JsonIgnore
    public String metricName() {
        String taglist = this.tags.stream().map(t -> t.getKey() + "=" + t.getValue()).sorted().collect(Collectors.joining(";"));
        if (taglist.isBlank()) {
            return this.name;
        }
        return String.join((CharSequence)";", this.name, taglist);
    }

    private static List<KeyValue> $default$tags() {
        return new ArrayList<KeyValue>();
    }

    public static MetricBuilder builder() {
        return new MetricBuilder();
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public List<KeyValue> getTags() {
        return this.tags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setTags(List<KeyValue> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<KeyValue> this$tags = this.getTags();
        List<KeyValue> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<KeyValue> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Metric(name=" + this.getName() + ", value=" + this.getValue() + ", tags=" + this.getTags() + ")";
    }

    public Metric() {
        this.tags = Metric.$default$tags();
    }

    public Metric(String name, long value, List<KeyValue> tags) {
        this.name = name;
        this.value = value;
        this.tags = tags;
    }

    public static class MetricBuilder {
        private String name;
        private long value;
        private boolean tags$set;
        private List<KeyValue> tags$value;

        MetricBuilder() {
        }

        public MetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricBuilder value(long value) {
            this.value = value;
            return this;
        }

        public MetricBuilder tags(List<KeyValue> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        public Metric build() {
            List<KeyValue> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = Metric.$default$tags();
            }
            return new Metric(this.name, this.value, tags$value);
        }

        public String toString() {
            return "Metric.MetricBuilder(name=" + this.name + ", value=" + this.value + ", tags$value=" + this.tags$value + ")";
        }
    }
}

