/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.action;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.deltafi.common.action.ActionEventQueueProperties;
import org.deltafi.common.queue.jedis.JedisKeyedBlockingQueue;
import org.deltafi.common.types.ActionEvent;
import org.deltafi.common.types.ActionInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionEventQueue {
    private static final Logger log = LoggerFactory.getLogger(ActionEventQueue.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_LONG_FOR_INTS, true).registerModule((Module)new JavaTimeModule());
    private static final String DGS_QUEUE = "dgs";
    private final JedisKeyedBlockingQueue jedisKeyedBlockingQueue;

    public ActionEventQueue(ActionEventQueueProperties actionEventQueueProperties, int poolSize) throws URISyntaxException {
        int maxIdle = poolSize > 0 ? poolSize : actionEventQueueProperties.getMaxIdle();
        int maxTotal = poolSize > 0 ? poolSize : actionEventQueueProperties.getMaxTotal();
        this.jedisKeyedBlockingQueue = new JedisKeyedBlockingQueue(actionEventQueueProperties.getUrl(), actionEventQueueProperties.getPassword(), maxIdle, maxTotal);
        log.info("Jedis pool size: " + maxTotal);
    }

    public void putActions(List<ActionInput> actionInputs, boolean checkUnique) {
        ArrayList<Pair<String, String>> actions = new ArrayList<Pair<String, String>>();
        for (ActionInput actionInput : actionInputs) {
            if (checkUnique) {
                String pattern = "*\"did\":\"" + actionInput.getActionContext().getDid() + "\"*";
                if (this.jedisKeyedBlockingQueue.exists(actionInput.getQueueName(), pattern)) {
                    log.warn("Skipping queueing for potential duplicate action event: {}", (Object)actionInput);
                    continue;
                }
            }
            try {
                actions.add((Pair<String, String>)Pair.of((Object)actionInput.getQueueName(), (Object)OBJECT_MAPPER.writeValueAsString((Object)actionInput)));
            }
            catch (JsonProcessingException e) {
                log.error("Unable to convert action to JSON", (Throwable)e);
            }
        }
        this.jedisKeyedBlockingQueue.put(actions);
    }

    public ActionInput takeAction(String actionClassName) throws JsonProcessingException {
        return ActionEventQueue.convertInput(this.jedisKeyedBlockingQueue.take(actionClassName));
    }

    private String queueName(String returnAddress) {
        Object queueName = DGS_QUEUE;
        if (returnAddress != null) {
            queueName = (String)queueName + "-" + returnAddress;
        }
        return queueName;
    }

    public void putResult(ActionEvent result, String returnAddress) throws JsonProcessingException {
        this.jedisKeyedBlockingQueue.put(this.queueName(returnAddress), OBJECT_MAPPER.writeValueAsString((Object)result));
    }

    public ActionEvent takeResult(String returnAddress) throws JsonProcessingException {
        return ActionEventQueue.convertEvent(this.jedisKeyedBlockingQueue.take(this.queueName(returnAddress)));
    }

    public static ActionEvent convertEvent(String element) throws JsonProcessingException {
        return (ActionEvent)OBJECT_MAPPER.readValue(element, ActionEvent.class);
    }

    public static ActionInput convertInput(String element) throws JsonProcessingException {
        return (ActionInput)OBJECT_MAPPER.readValue(element, ActionInput.class);
    }

    public void setHeartbeat(String key) {
        this.jedisKeyedBlockingQueue.setHeartbeat(key);
    }

    public void drop(List<String> actionNames) {
        this.jedisKeyedBlockingQueue.drop(actionNames);
    }
}

