/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.http.client.feign;

import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.io.File;
import javax.net.ssl.SSLContext;
import org.deltafi.common.ssl.SslContextFactory;
import org.deltafi.common.ssl.SslProperties;

public class FeignClientFactory {
    public static <T> T build(Class<T> clientClass) {
        return FeignClientFactory.build(clientClass, null, null, null, null);
    }

    public static <T> T build(Class<T> clientClass, String url) {
        return FeignClientFactory.build(clientClass, url, null, null, null);
    }

    public static <T> T build(Class<T> clientClass, String url, Encoder encoder, Decoder decoder, Retryer retryer) {
        return FeignClientFactory.build(FeignClientFactory.createBuilder(clientClass, encoder, decoder, retryer), clientClass, url);
    }

    public static <T> T build(Class<T> clientClass, SslProperties sslProperties) throws SslContextFactory.SslException {
        return FeignClientFactory.build(clientClass, null, null, null, null, sslProperties);
    }

    public static <T> T build(Class<T> clientClass, String url, SslProperties sslProperties) throws SslContextFactory.SslException {
        return FeignClientFactory.build(clientClass, url, null, null, null, sslProperties);
    }

    public static <T> T build(Class<T> clientClass, String url, Encoder encoder, Decoder decoder, Retryer retryer, SslProperties sslProperties) throws SslContextFactory.SslException {
        Feign.Builder builder = FeignClientFactory.createBuilder(clientClass, encoder, decoder, retryer);
        if (sslProperties != null && FeignClientFactory.keystoreExists(sslProperties.getKeyStore())) {
            SSLContext context = SslContextFactory.buildSslContext(sslProperties);
            builder.client((Client)new Client.Default(context.getSocketFactory(), null));
        }
        return FeignClientFactory.build(builder, clientClass, url);
    }

    private static <T> Feign.Builder createBuilder(Class<T> clientClass, Encoder encoder, Decoder decoder, Retryer retryer) {
        return Feign.builder().encoder((Encoder)(encoder == null ? new JacksonEncoder() : encoder)).decoder((Decoder)(decoder == null ? new JacksonDecoder() : decoder)).retryer((Retryer)(retryer == null ? new Retryer.Default(1000L, 5000L, 5) : retryer)).logger((Logger)new Slf4jLogger(clientClass)).logLevel(Logger.Level.FULL);
    }

    private static <T> T build(Feign.Builder builder, Class<T> clientClass, String url) {
        return (T)(url == null ? builder.target((Target)Target.EmptyTarget.create(clientClass)) : builder.target(clientClass, url));
    }

    private static boolean keystoreExists(String path) {
        return path != null && new File(path).exists();
    }
}

