/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.TimedIngressActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TimedIngressFlowPlan
extends FlowPlan {
    private TimedIngressActionConfiguration timedIngressAction;
    private String targetFlow;
    private String cronSchedule;

    @PersistenceCreator
    @JsonCreator
    public TimedIngressFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="timedIngressAction", required=true) TimedIngressActionConfiguration timedIngressAction, @JsonProperty(value="targetFlow", required=true) String targetFlow, @JsonProperty(value="cronSchedule", required=true) String cronSchedule) {
        super(name, FlowType.TIMED_INGRESS, description);
        this.timedIngressAction = timedIngressAction;
        this.targetFlow = targetFlow;
        this.cronSchedule = cronSchedule;
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.timedIngressAction != null) {
            actionConfigurations.add(this.timedIngressAction);
        }
        return actionConfigurations;
    }

    public TimedIngressActionConfiguration getTimedIngressAction() {
        return this.timedIngressAction;
    }

    public String getTargetFlow() {
        return this.targetFlow;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public void setTimedIngressAction(TimedIngressActionConfiguration timedIngressAction) {
        this.timedIngressAction = timedIngressAction;
    }

    public void setTargetFlow(String targetFlow) {
        this.targetFlow = targetFlow;
    }

    public void setCronSchedule(String cronSchedule) {
        this.cronSchedule = cronSchedule;
    }
}

