/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.EgressActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.TransformActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TransformFlowPlan
extends FlowPlan {
    private List<TransformActionConfiguration> transformActions;
    private EgressActionConfiguration egressAction;

    public TransformFlowPlan(String name, String description) {
        super(name, FlowType.TRANSFORM, description);
    }

    @PersistenceCreator
    @JsonCreator
    public TransformFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description) {
        this(name, description);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.transformActions != null) {
            actionConfigurations.addAll(this.transformActions);
        }
        if (this.egressAction != null) {
            actionConfigurations.add(this.egressAction);
        }
        return actionConfigurations;
    }

    public List<TransformActionConfiguration> getTransformActions() {
        return this.transformActions;
    }

    public EgressActionConfiguration getEgressAction() {
        return this.egressAction;
    }

    public void setTransformActions(List<TransformActionConfiguration> transformActions) {
        this.transformActions = transformActions;
    }

    public void setEgressAction(EgressActionConfiguration egressAction) {
        this.egressAction = egressAction;
    }
}

