/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.List;
import org.deltafi.common.cache.CacheProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={Caffeine.class, CaffeineCache.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@ConditionalOnExpression(value="'${spring.cache.type:CAFFEINE}' eq 'CAFFEINE'")
@EnableConfigurationProperties(value={CacheProperties.class})
@EnableCaching
public class CacheAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Ticker ticker() {
        return System::nanoTime;
    }

    @Bean
    public CacheManager cacheManager(CacheProperties cacheProperties, Ticker ticker) {
        SimpleCacheManager simpleCacheManager = new SimpleCacheManager();
        List<CaffeineCache> caches = cacheProperties.getCaches().entrySet().stream().map(cacheEntry -> new CaffeineCache((String)cacheEntry.getKey(), Caffeine.from((String)((String)cacheEntry.getValue())).ticker(ticker).build())).toList();
        simpleCacheManager.setCaches(caches);
        return simpleCacheManager;
    }
}

