/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.nifi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV1;
import org.apache.nifi.util.FlowFilePackagerV2;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.deltafi.common.nifi.FlowFile;
import org.deltafi.common.nifi.FlowFileTwoStepUnpackager;
import org.deltafi.common.nifi.FlowFileTwoStepUnpackagerV1;
import org.deltafi.common.nifi.FlowFileTwoStepUnpackagerV2;
import org.deltafi.common.nifi.FlowFileTwoStepUnpackagerV3;
import org.deltafi.common.stream.PipelineBlockingInputStream;

public class FlowFileUtil {
    public static PipelineBlockingInputStream packageFlowFileV1(Map<String, String> attributes, InputStream in, long fileSize, ExecutorService executorService) throws IOException {
        PipelineBlockingInputStream pipelineBlockingInputStream = new PipelineBlockingInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipelineBlockingInputStream);
        executorService.submit(() -> {
            try (PipedOutputStream pipedOutputStream2 = pipedOutputStream;){
                FlowFileUtil.packageFlowFile((FlowFilePackager)new FlowFilePackagerV1(), attributes, in, fileSize, pipedOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                pipelineBlockingInputStream.unblock();
            }
        });
        return pipelineBlockingInputStream;
    }

    public static byte[] packageFlowFileV2(Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        return FlowFileUtil.packageFlowFile((FlowFilePackager)new FlowFilePackagerV2(), attributes, in, fileSize);
    }

    public static byte[] packageFlowFileV3(Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        return FlowFileUtil.packageFlowFile((FlowFilePackager)new FlowFilePackagerV3(), attributes, in, fileSize);
    }

    private static byte[] packageFlowFile(FlowFilePackager flowFilePackager, Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            flowFilePackager.packageFlowFile(in, (OutputStream)out, attributes, fileSize);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static void packageFlowFile(FlowFilePackager flowFilePackager, Map<String, String> attributes, InputStream in, long fileSize, OutputStream out) throws IOException {
        flowFilePackager.packageFlowFile(in, out, attributes, fileSize);
    }

    public static FlowFile unpackageFlowFile(String contentType, InputStream in, ExecutorService executorService) throws IOException {
        return switch (contentType) {
            case "application/flowfile", "application/flowfile-v1" -> FlowFileUtil.unpackageFlowFile(new FlowFileTwoStepUnpackagerV1(), in, executorService);
            case "application/flowfile-v2" -> FlowFileUtil.unpackageFlowFile(new FlowFileTwoStepUnpackagerV2(), in, executorService);
            case "application/flowfile-v3" -> FlowFileUtil.unpackageFlowFile(new FlowFileTwoStepUnpackagerV3(), in, executorService);
            default -> throw new IllegalStateException("Unexpected value: " + contentType);
        };
    }

    private static FlowFile unpackageFlowFile(FlowFileTwoStepUnpackager flowFileUnpackager, InputStream in, ExecutorService executorService) throws IOException {
        PipelineBlockingInputStream pipelineBlockingInputStream = new PipelineBlockingInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipelineBlockingInputStream);
        Map<String, String> attributes = flowFileUnpackager.unpackageAttributes(in);
        executorService.submit(() -> {
            try (PipedOutputStream pipedOutputStream2 = pipedOutputStream;){
                flowFileUnpackager.unpackageContent(in, pipedOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                pipelineBlockingInputStream.unblock();
            }
        });
        return new FlowFile(attributes, pipelineBlockingInputStream);
    }
}

