/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.time.OffsetDateTime;
import java.util.List;
import org.deltafi.common.content.ContentStorageService;
import org.deltafi.common.types.CollectConfiguration;

public class ActionContext {
    private String did;
    private String flow;
    private String name;
    private String sourceFilename;
    private String ingressFlow;
    private String egressFlow;
    private String hostname;
    private String actionVersion;
    private OffsetDateTime startTime;
    private String systemName;
    private ContentStorageService contentStorageService;
    private CollectConfiguration collect;
    private List<String> collectedDids;
    private String memo;

    public ActionContext copy(String newDid) {
        return new ActionContext(newDid, this.flow, this.name, this.sourceFilename, this.ingressFlow, this.egressFlow, this.hostname, this.actionVersion, this.startTime, this.systemName, this.contentStorageService, this.collect, this.collectedDids, this.memo);
    }

    public static ActionContextBuilder builder() {
        return new ActionContextBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceFilename() {
        return this.sourceFilename;
    }

    public String getIngressFlow() {
        return this.ingressFlow;
    }

    public String getEgressFlow() {
        return this.egressFlow;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getActionVersion() {
        return this.actionVersion;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public ContentStorageService getContentStorageService() {
        return this.contentStorageService;
    }

    public CollectConfiguration getCollect() {
        return this.collect;
    }

    public List<String> getCollectedDids() {
        return this.collectedDids;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSourceFilename(String sourceFilename) {
        this.sourceFilename = sourceFilename;
    }

    public void setIngressFlow(String ingressFlow) {
        this.ingressFlow = ingressFlow;
    }

    public void setEgressFlow(String egressFlow) {
        this.egressFlow = egressFlow;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setActionVersion(String actionVersion) {
        this.actionVersion = actionVersion;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setContentStorageService(ContentStorageService contentStorageService) {
        this.contentStorageService = contentStorageService;
    }

    public void setCollect(CollectConfiguration collect) {
        this.collect = collect;
    }

    public void setCollectedDids(List<String> collectedDids) {
        this.collectedDids = collectedDids;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionContext)) {
            return false;
        }
        ActionContext other = (ActionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$sourceFilename = this.getSourceFilename();
        String other$sourceFilename = other.getSourceFilename();
        if (this$sourceFilename == null ? other$sourceFilename != null : !this$sourceFilename.equals(other$sourceFilename)) {
            return false;
        }
        String this$ingressFlow = this.getIngressFlow();
        String other$ingressFlow = other.getIngressFlow();
        if (this$ingressFlow == null ? other$ingressFlow != null : !this$ingressFlow.equals(other$ingressFlow)) {
            return false;
        }
        String this$egressFlow = this.getEgressFlow();
        String other$egressFlow = other.getEgressFlow();
        if (this$egressFlow == null ? other$egressFlow != null : !this$egressFlow.equals(other$egressFlow)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$actionVersion = this.getActionVersion();
        String other$actionVersion = other.getActionVersion();
        if (this$actionVersion == null ? other$actionVersion != null : !this$actionVersion.equals(other$actionVersion)) {
            return false;
        }
        OffsetDateTime this$startTime = this.getStartTime();
        OffsetDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        ContentStorageService this$contentStorageService = this.getContentStorageService();
        ContentStorageService other$contentStorageService = other.getContentStorageService();
        if (this$contentStorageService == null ? other$contentStorageService != null : !this$contentStorageService.equals(other$contentStorageService)) {
            return false;
        }
        CollectConfiguration this$collect = this.getCollect();
        CollectConfiguration other$collect = other.getCollect();
        if (this$collect == null ? other$collect != null : !((Object)this$collect).equals(other$collect)) {
            return false;
        }
        List<String> this$collectedDids = this.getCollectedDids();
        List<String> other$collectedDids = other.getCollectedDids();
        if (this$collectedDids == null ? other$collectedDids != null : !((Object)this$collectedDids).equals(other$collectedDids)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        return !(this$memo == null ? other$memo != null : !this$memo.equals(other$memo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $sourceFilename = this.getSourceFilename();
        result = result * 59 + ($sourceFilename == null ? 43 : $sourceFilename.hashCode());
        String $ingressFlow = this.getIngressFlow();
        result = result * 59 + ($ingressFlow == null ? 43 : $ingressFlow.hashCode());
        String $egressFlow = this.getEgressFlow();
        result = result * 59 + ($egressFlow == null ? 43 : $egressFlow.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $actionVersion = this.getActionVersion();
        result = result * 59 + ($actionVersion == null ? 43 : $actionVersion.hashCode());
        OffsetDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        ContentStorageService $contentStorageService = this.getContentStorageService();
        result = result * 59 + ($contentStorageService == null ? 43 : $contentStorageService.hashCode());
        CollectConfiguration $collect = this.getCollect();
        result = result * 59 + ($collect == null ? 43 : ((Object)$collect).hashCode());
        List<String> $collectedDids = this.getCollectedDids();
        result = result * 59 + ($collectedDids == null ? 43 : ((Object)$collectedDids).hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        return result;
    }

    public String toString() {
        return "ActionContext(did=" + this.getDid() + ", flow=" + this.getFlow() + ", name=" + this.getName() + ", sourceFilename=" + this.getSourceFilename() + ", ingressFlow=" + this.getIngressFlow() + ", egressFlow=" + this.getEgressFlow() + ", hostname=" + this.getHostname() + ", actionVersion=" + this.getActionVersion() + ", startTime=" + this.getStartTime() + ", systemName=" + this.getSystemName() + ", contentStorageService=" + this.getContentStorageService() + ", collect=" + this.getCollect() + ", collectedDids=" + this.getCollectedDids() + ", memo=" + this.getMemo() + ")";
    }

    public ActionContext(String did, String flow, String name, String sourceFilename, String ingressFlow, String egressFlow, String hostname, String actionVersion, OffsetDateTime startTime, String systemName, ContentStorageService contentStorageService, CollectConfiguration collect, List<String> collectedDids, String memo) {
        this.did = did;
        this.flow = flow;
        this.name = name;
        this.sourceFilename = sourceFilename;
        this.ingressFlow = ingressFlow;
        this.egressFlow = egressFlow;
        this.hostname = hostname;
        this.actionVersion = actionVersion;
        this.startTime = startTime;
        this.systemName = systemName;
        this.contentStorageService = contentStorageService;
        this.collect = collect;
        this.collectedDids = collectedDids;
        this.memo = memo;
    }

    public ActionContext() {
    }

    public static class ActionContextBuilder {
        private String did;
        private String flow;
        private String name;
        private String sourceFilename;
        private String ingressFlow;
        private String egressFlow;
        private String hostname;
        private String actionVersion;
        private OffsetDateTime startTime;
        private String systemName;
        private ContentStorageService contentStorageService;
        private CollectConfiguration collect;
        private List<String> collectedDids;
        private String memo;

        ActionContextBuilder() {
        }

        public ActionContextBuilder did(String did) {
            this.did = did;
            return this;
        }

        public ActionContextBuilder flow(String flow) {
            this.flow = flow;
            return this;
        }

        public ActionContextBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ActionContextBuilder sourceFilename(String sourceFilename) {
            this.sourceFilename = sourceFilename;
            return this;
        }

        public ActionContextBuilder ingressFlow(String ingressFlow) {
            this.ingressFlow = ingressFlow;
            return this;
        }

        public ActionContextBuilder egressFlow(String egressFlow) {
            this.egressFlow = egressFlow;
            return this;
        }

        public ActionContextBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public ActionContextBuilder actionVersion(String actionVersion) {
            this.actionVersion = actionVersion;
            return this;
        }

        public ActionContextBuilder startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public ActionContextBuilder systemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        public ActionContextBuilder contentStorageService(ContentStorageService contentStorageService) {
            this.contentStorageService = contentStorageService;
            return this;
        }

        public ActionContextBuilder collect(CollectConfiguration collect) {
            this.collect = collect;
            return this;
        }

        public ActionContextBuilder collectedDids(List<String> collectedDids) {
            this.collectedDids = collectedDids;
            return this;
        }

        public ActionContextBuilder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public ActionContext build() {
            return new ActionContext(this.did, this.flow, this.name, this.sourceFilename, this.ingressFlow, this.egressFlow, this.hostname, this.actionVersion, this.startTime, this.systemName, this.contentStorageService, this.collect, this.collectedDids, this.memo);
        }

        public String toString() {
            return "ActionContext.ActionContextBuilder(did=" + this.did + ", flow=" + this.flow + ", name=" + this.name + ", sourceFilename=" + this.sourceFilename + ", ingressFlow=" + this.ingressFlow + ", egressFlow=" + this.egressFlow + ", hostname=" + this.hostname + ", actionVersion=" + this.actionVersion + ", startTime=" + this.startTime + ", systemName=" + this.systemName + ", contentStorageService=" + this.contentStorageService + ", collect=" + this.collect + ", collectedDids=" + this.collectedDids + ", memo=" + this.memo + ")";
        }
    }
}

