/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.deltafi.common.content.Segment;
import org.deltafi.common.converters.KeyValueConverter;
import org.deltafi.common.types.Action;
import org.deltafi.common.types.ActionEvent;
import org.deltafi.common.types.ActionState;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.DeltaFileMessage;
import org.deltafi.common.types.DeltaFileStage;
import org.deltafi.common.types.Domain;
import org.deltafi.common.types.Egress;
import org.deltafi.common.types.Enrichment;
import org.deltafi.common.types.ResumeMetadata;
import org.deltafi.common.types.SourceInfo;
import org.deltafi.core.exceptions.MultipleActionException;
import org.deltafi.core.exceptions.UnexpectedActionException;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Update;

@Document
public class DeltaFile {
    @Id
    private String did;
    private List<String> parentDids;
    private boolean aggregate;
    private List<String> childDids;
    private int requeueCount;
    private long ingressBytes;
    private long referencedBytes;
    private long totalBytes;
    private DeltaFileStage stage;
    private List<Action> actions;
    private SourceInfo sourceInfo;
    private Map<String, String> annotations = new HashMap<String, String>();
    private Set<String> annotationKeys = new HashSet<String>();
    private List<Egress> egress = new ArrayList<Egress>();
    private OffsetDateTime created;
    private OffsetDateTime modified;
    private OffsetDateTime contentDeleted;
    private String contentDeletedReason;
    private OffsetDateTime errorAcknowledged;
    private String errorAcknowledgedReason;
    private Boolean testMode;
    private String testModeReason;
    private Boolean egressed;
    private Boolean filtered;
    private OffsetDateTime replayed;
    private String replayDid;
    private OffsetDateTime nextAutoResume;
    private String nextAutoResumeReason;
    private Set<String> pendingAnnotationsForFlows;
    private boolean inFlight;
    private boolean terminal;
    private boolean contentDeletable;
    @Version
    @JsonIgnore
    private long version;
    @JsonIgnore
    private OffsetDateTime cacheTime = null;
    @Transient
    private DeltaFile snapshot = null;
    public static final int CURRENT_SCHEMA_VERSION = 8;
    private int schemaVersion;

    public DeltaFile(DeltaFile other) {
        this.did = other.did;
        this.parentDids = other.parentDids == null ? null : new ArrayList<String>(other.parentDids);
        this.aggregate = other.aggregate;
        this.childDids = other.childDids == null ? null : new ArrayList<String>(other.childDids);
        this.requeueCount = other.requeueCount;
        this.ingressBytes = other.ingressBytes;
        this.referencedBytes = other.referencedBytes;
        this.totalBytes = other.totalBytes;
        this.stage = other.stage;
        this.actions = other.actions == null ? null : other.actions.stream().map(Action::new).toList();
        this.sourceInfo = other.sourceInfo == null ? null : new SourceInfo(other.sourceInfo);
        this.annotations = other.annotations == null ? null : new HashMap<String, String>(other.annotations);
        this.annotationKeys = other.annotationKeys == null ? null : new HashSet<String>(other.annotationKeys);
        this.egress = other.egress == null ? null : other.egress.stream().map(Egress::new).toList();
        this.created = other.created;
        this.modified = other.modified;
        this.contentDeleted = other.contentDeleted;
        this.contentDeletedReason = other.contentDeletedReason;
        this.errorAcknowledged = other.errorAcknowledged;
        this.errorAcknowledgedReason = other.errorAcknowledgedReason;
        this.testMode = other.testMode;
        this.testModeReason = other.testModeReason;
        this.egressed = other.egressed;
        this.filtered = other.filtered;
        this.replayed = other.replayed;
        this.replayDid = other.replayDid;
        this.nextAutoResume = other.nextAutoResume;
        this.nextAutoResumeReason = other.nextAutoResumeReason;
        this.pendingAnnotationsForFlows = other.pendingAnnotationsForFlows == null ? null : new HashSet<String>(other.pendingAnnotationsForFlows);
        this.inFlight = other.inFlight;
        this.terminal = other.terminal;
        this.contentDeletable = other.contentDeletable;
        this.version = other.version;
        this.cacheTime = other.cacheTime;
        this.schemaVersion = other.schemaVersion;
        this.snapshot = null;
    }

    public void snapshot() {
        this.snapshot = new DeltaFile(this);
    }

    public List<Action> getActions() {
        return this.actions == null ? Collections.emptyList() : this.actions;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations == null ? Collections.emptyMap() : this.annotations;
    }

    public Set<String> getAnnotationKeys() {
        return this.annotationKeys == null ? Collections.emptySet() : this.annotationKeys;
    }

    public void setStage(DeltaFileStage stage) {
        this.stage = stage;
        this.updateFlags();
    }

    public void updateFlags() {
        this.inFlight = this.stage == DeltaFileStage.INGRESS || this.stage == DeltaFileStage.ENRICH || this.stage == DeltaFileStage.EGRESS;
        this.terminal = !(this.inFlight || this.stage == DeltaFileStage.ERROR && this.errorAcknowledged == null || this.pendingAnnotationsForFlows != null && !this.pendingAnnotationsForFlows.isEmpty());
        this.contentDeletable = this.terminal && this.contentDeleted == null && this.totalBytes > 0L;
    }

    public void setContentDeleted(OffsetDateTime contentDeleted) {
        this.contentDeleted = contentDeleted;
        this.updateFlags();
    }

    public Map<String, String> getMetadata() {
        if (this.actions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        ArrayList<Action> amendedDataActions = new ArrayList<Action>(this.actions.stream().filter(Action::amendedData).toList());
        amendedDataActions.addAll(this.actions.stream().filter(action -> action.getType() == ActionType.DOMAIN || action.getType() == ActionType.ENRICH).toList());
        amendedDataActions.addAll(this.actions.stream().filter(action -> action.getType() == ActionType.FORMAT && action.getState().equals((Object)ActionState.RETRIED)).toList());
        for (Action action2 : amendedDataActions) {
            metadata.putAll(action2.getMetadata());
            for (String key : action2.getDeleteMetadataKeys()) {
                metadata.remove(key);
            }
        }
        return metadata;
    }

    public Map<String, String> metadataWithFormatRetries(String flow) {
        Map<String, String> metadata = this.getMetadata();
        this.formatActions(flow).stream().filter(action -> action.getState().equals((Object)ActionState.RETRIED)).forEach(action -> {
            metadata.putAll(action.getMetadata());
            for (String key : action.getDeleteMetadataKeys()) {
                metadata.remove(key);
            }
        });
        return metadata;
    }

    public Map<String, String> getErrorMetadata(Action action) {
        return action.afterFormat() ? this.formatMetadata(action.getFlow()) : this.getMetadata();
    }

    public List<Action> erroredActions() {
        return this.getActions().stream().filter(a -> a.getState() == ActionState.ERROR).collect(Collectors.toList());
    }

    public Action queueAction(String flow, String name, ActionType type, boolean coldQueue) {
        Optional<Action> maybeAction = this.actionNamed(flow, name);
        if (maybeAction.isPresent()) {
            this.setActionState(maybeAction.get(), coldQueue ? ActionState.COLD_QUEUED : ActionState.QUEUED, null, null);
            return maybeAction.get();
        }
        return this.queueNewAction(flow, name, type, coldQueue);
    }

    public Action queueNewAction(String flow, String name, ActionType type, boolean coldQueue) {
        return this.addAction(flow, name, type, coldQueue ? ActionState.COLD_QUEUED : ActionState.QUEUED);
    }

    public Action addAction(String flow, String name, ActionType type, ActionState state) {
        OffsetDateTime now = OffsetDateTime.now();
        Action action = Action.builder().name(name).type(type).flow(flow).state(state).created(now).queued(now).modified(now).attempt(1 + this.getLastAttemptNum(name)).build();
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(action);
        return action;
    }

    public void addReadyToCollectAction(String flow, String name, ActionType type) {
        this.addAction(flow, name, type, ActionState.READY_TO_COLLECT);
    }

    private int getLastAttemptNum(String name) {
        Optional<Action> action = this.getActions().stream().filter(a -> a.getName().equals(name) && this.retried((Action)a)).reduce((first, second) -> second);
        return action.map(Action::getAttempt).orElse(0);
    }

    public Optional<Action> actionNamed(String flow, String name) {
        return this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !this.retried((Action)action)).reduce((first, second) -> second);
    }

    public Optional<Action> firstActionError() {
        return this.getActions().stream().filter(a -> a.getState().equals((Object)ActionState.ERROR)).findFirst();
    }

    public boolean isNewAction(String flow, String name) {
        return this.actionNamed(flow, name).isEmpty();
    }

    public Action completeAction(ActionEvent event) {
        return this.completeAction(event.getFlow(), event.getAction(), event.getStart(), event.getStop(), null, null, null, null, null);
    }

    public void completeAction(ActionEvent event, List<Content> content, Map<String, String> metadata, List<String> deleteMetadataKeys, List<Domain> domains, List<Enrichment> enrichments) {
        this.completeAction(event.getFlow(), event.getAction(), event.getStart(), event.getStop(), content, metadata, deleteMetadataKeys, domains, enrichments);
    }

    public Action completeAction(String flow, String name, OffsetDateTime start, OffsetDateTime stop) {
        return this.completeAction(flow, name, start, stop, null, null, null, null, null);
    }

    public Action completeAction(String flow, String name, OffsetDateTime start, OffsetDateTime stop, List<Content> content, Map<String, String> metadata, List<String> deleteMetadataKeys, List<Domain> domains, List<Enrichment> enrichments) {
        Optional<Action> optionalAction = this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !action.terminal()).findFirst();
        if (optionalAction.isEmpty()) {
            throw new UnexpectedActionException(flow, name, this.did, this.queuedActions());
        }
        Action action2 = optionalAction.get();
        this.setActionState(action2, ActionState.COMPLETE, start, stop);
        if (content != null) {
            action2.setContent(content);
        }
        if (metadata != null) {
            action2.setMetadata(metadata);
        }
        if (deleteMetadataKeys != null) {
            action2.setDeleteMetadataKeys(deleteMetadataKeys);
        }
        if (domains != null) {
            for (Domain domain : domains) {
                action2.addDomain(domain.getName(), domain.getValue(), domain.getMediaType());
            }
        }
        if (enrichments != null) {
            for (Enrichment enrichment : enrichments) {
                action2.addDomain(enrichment.getName(), enrichment.getValue(), enrichment.getMediaType());
            }
        }
        return action2;
    }

    public void collectingAction(String flow, String name, OffsetDateTime start, OffsetDateTime stop) {
        this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !action.terminal()).forEach(action -> this.setActionState((Action)action, ActionState.COLLECTING, start, stop));
    }

    public void collectedAction(String flow, String name, OffsetDateTime start, OffsetDateTime stop) {
        this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !action.terminal()).forEach(action -> this.setActionState((Action)action, ActionState.COLLECTED, start, stop));
    }

    public void filterAction(ActionEvent event, String filterMessage) {
        this.getActions().stream().filter(action -> action.getFlow().equals(event.getFlow()) && action.getName().equals(event.getAction()) && !action.terminal()).forEach(action -> this.setFilteredActionState((Action)action, event.getStart(), event.getStop(), filterMessage));
    }

    public void reinjectAction(ActionEvent event) {
        this.getActions().stream().filter(action -> action.getFlow().equals(event.getFlow()) && action.getName().equals(event.getAction()) && !action.terminal()).forEach(action -> this.setActionState((Action)action, ActionState.REINJECTED, event.getStart(), event.getStop()));
    }

    public Action lastAction() {
        return this.getActions().get(this.getActions().size() - 1);
    }

    public void setLastActionReinjected() {
        this.lastAction().setState(ActionState.REINJECTED);
    }

    public void removeLastAction() {
        this.getActions().remove(this.lastAction());
    }

    public void errorAction(ActionEvent event) {
        this.errorAction(event.getFlow(), event.getAction(), event.getStart(), event.getStop(), event.getError().getCause(), event.getError().getContext());
    }

    public void errorAction(ActionEvent event, String policyName, Integer delay) {
        this.setNextAutoResumeReason(policyName);
        this.errorAction(event.getFlow(), event.getAction(), event.getStart(), event.getStop(), event.getError().getCause(), event.getError().getContext(), event.getStop().plusSeconds(delay.intValue()));
    }

    public void errorAction(ActionEvent event, String errorCause, String errorContext) {
        this.errorAction(event.getFlow(), event.getAction(), event.getStart(), event.getStop(), errorCause, errorContext, null);
    }

    public void errorAction(String flow, String name, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext) {
        this.errorAction(flow, name, start, stop, errorCause, errorContext, null);
    }

    public void errorAction(String flow, String name, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext, OffsetDateTime nextAutoResume) {
        this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !action.terminal()).forEach(action -> this.setActionState((Action)action, ActionState.ERROR, start, stop, errorCause, errorContext, nextAutoResume));
    }

    public List<String> retryErrors(@NotNull List<ResumeMetadata> resumeMetadata) {
        List<Action> actionsToRetry = this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.ERROR)).toList();
        for (Action action2 : actionsToRetry) {
            action2.setState(ActionState.RETRIED);
            resumeMetadata.stream().filter(r -> r.getFlow().equals(action2.getFlow()) && r.getAction().equals(action2.getName())).forEach(r -> {
                if (r.getMetadata() != null) {
                    action2.setMetadata(KeyValueConverter.convertKeyValues(r.getMetadata()));
                }
                if (r.getDeleteMetadataKeys() != null) {
                    action2.setDeleteMetadataKeys(r.getDeleteMetadataKeys());
                }
            });
        }
        this.setNextAutoResume(null);
        return actionsToRetry.stream().map(Action::getName).toList();
    }

    private void setActionState(Action action, ActionState actionState, OffsetDateTime start, OffsetDateTime stop) {
        this.setActionState(action, actionState, start, stop, null, null, null);
    }

    private void setFilteredActionState(Action action, OffsetDateTime start, OffsetDateTime stop, String filteredCause) {
        action.setFilteredCause(filteredCause);
        this.setActionState(action, ActionState.FILTERED, start, stop);
    }

    private void setActionState(Action action, ActionState actionState, OffsetDateTime start, OffsetDateTime stop, String errorCause, String errorContext, OffsetDateTime nextAutoResume) {
        OffsetDateTime now = OffsetDateTime.now();
        action.setState(actionState);
        if (action.getCreated() == null) {
            action.setCreated(now);
        }
        action.setStart(start);
        action.setStop(stop);
        action.setModified(now);
        action.setErrorCause(errorCause);
        action.setErrorContext(errorContext);
        this.setModified(now);
        this.setNextAutoResume(nextAutoResume);
    }

    public void setTestModeReason(String reason) {
        this.testMode = null != reason;
        this.testModeReason = reason;
    }

    public List<String> queuedActions() {
        return this.getActions().stream().filter(Action::queued).map(Action::getName).toList();
    }

    public List<Action> readyToCollectActions() {
        return this.getActions().stream().filter(action -> action.getState().equals((Object)ActionState.READY_TO_COLLECT)).toList();
    }

    public boolean hasDomains(List<String> domains) {
        return domains.stream().allMatch(domain -> this.domains().stream().anyMatch(d -> d.getName().equals(domain)));
    }

    public void addAnnotations(Map<String, String> metadata) {
        if (null == metadata) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.putAll(metadata);
        if (this.annotationKeys == null) {
            this.annotationKeys = new HashSet<String>();
        }
        this.annotationKeys.addAll(metadata.keySet());
    }

    public void addAnnotationsIfAbsent(Map<String, String> metadata) {
        metadata.forEach(this::addAnnotationIfAbsent);
    }

    public void addAnnotationIfAbsent(String key, String value) {
        if (null == key || this.annotations != null && this.annotations.containsKey(key)) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, value);
        if (this.annotationKeys == null) {
            this.annotationKeys = new HashSet<String>();
        }
        this.annotationKeys.add(key);
    }

    public void addEgressFlow(@NotNull String flow) {
        if (!this.getEgress().stream().map(Egress::getFlow).toList().contains(flow)) {
            this.getEgress().add(new Egress(flow));
        }
    }

    public boolean hasEnrichments(List<String> enrichments) {
        return enrichments.stream().allMatch(enrichment -> this.enrichments().stream().anyMatch(e -> e.getName().equals(enrichment)));
    }

    public boolean hasErroredAction() {
        return this.hasActionInState(ActionState.ERROR);
    }

    public boolean hasPendingActions() {
        return this.getActions().stream().anyMatch(action -> !action.terminal());
    }

    public boolean hasFilteredAction() {
        return this.hasActionInState(ActionState.FILTERED);
    }

    public boolean hasReinjectedAction() {
        return this.hasActionInState(ActionState.REINJECTED);
    }

    public boolean hasActionInState(ActionState actionState) {
        return this.getActions().stream().anyMatch(action -> action.getState().equals((Object)actionState));
    }

    public void ensurePendingAction(String flow, String name) {
        long actionCount = this.countPendingActions(flow, name);
        if (actionCount == 0L) {
            throw new UnexpectedActionException(flow, name, this.did, this.queuedActions());
        }
        if (actionCount > 1L) {
            throw new MultipleActionException(flow, name, this.did);
        }
    }

    public Action getPendingAction(String flow, String name) {
        return this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !action.terminal()).findFirst().orElseThrow(() -> new UnexpectedActionException(flow, name, this.did, this.queuedActions()));
    }

    private long countPendingActions(String flow, String name) {
        return this.getActions().stream().filter(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !action.terminal()).count();
    }

    private boolean retried(Action action) {
        return action.getState().equals((Object)ActionState.RETRIED);
    }

    public boolean hasTerminalAction(String flow, String name) {
        return this.getActions().stream().anyMatch(action -> action.getFlow().equals(flow) && action.getName().equals(name) && !this.retried((Action)action) && action.terminal());
    }

    public boolean hasCompletedAction(String flow, String name) {
        return this.hasActionInState(flow, name, ActionState.COMPLETE);
    }

    public boolean hasCompletedActions(String flow, List<String> names) {
        return names.stream().allMatch(name -> this.hasCompletedAction(flow, (String)name));
    }

    public boolean hasCollectedAction(String flow, String name) {
        return this.hasActionInState(flow, name, ActionState.COLLECTED);
    }

    public boolean hasActionInState(String flow, String name, ActionState state) {
        return this.getActions().stream().anyMatch(action -> action.getFlow().equals(flow) && action.getName().equals(name) && action.getState().equals((Object)state));
    }

    public String sourceMetadata(String key) {
        return this.getSourceInfo().getMetadata().get(key);
    }

    public String sourceMetadata(String key, String defaultValue) {
        return this.getSourceInfo().getMetadata().getOrDefault(key, defaultValue);
    }

    public void addPendingAnnotationsForFlow(String flowName) {
        if (flowName == null || flowName.isBlank()) {
            return;
        }
        if (this.pendingAnnotationsForFlows == null) {
            this.pendingAnnotationsForFlows = new HashSet<String>();
        }
        this.pendingAnnotationsForFlows.add(flowName);
        this.updateFlags();
    }

    public void updatePendingAnnotationsForFlows(String flow, Set<String> expectedAnnotations) {
        if (this.pendingAnnotationsForFlows == null || !this.pendingAnnotationsForFlows.contains(flow)) {
            return;
        }
        if (this.pendingAnnotations(expectedAnnotations).isEmpty()) {
            this.pendingAnnotationsForFlows.remove(flow);
            if (this.pendingAnnotationsForFlows.isEmpty()) {
                this.pendingAnnotationsForFlows = null;
            }
        }
        this.updateFlags();
    }

    public Set<String> pendingAnnotations(Set<String> expectedAnnotations) {
        expectedAnnotations = expectedAnnotations != null ? new HashSet<String>(expectedAnnotations) : new HashSet();
        Set<String> indexedKeys = this.getAnnotationKeys();
        indexedKeys.forEach(expectedAnnotations::remove);
        return expectedAnnotations;
    }

    public Action lastCompleteDataAmendedAction() {
        return this.getActions().stream().filter(action -> action.amendedData() && action.complete()).reduce((first, second) -> second).orElse(null);
    }

    @NotNull
    public List<Content> lastDataAmendedContent() {
        Action lastDataAmendedAction = this.lastCompleteDataAmendedAction();
        if (lastDataAmendedAction == null || lastDataAmendedAction.getContent() == null) {
            return Collections.emptyList();
        }
        return lastDataAmendedAction.getContent();
    }

    @NotNull
    public List<Domain> domains() {
        return this.getActions().stream().map(Action::getDomains).flatMap(Collection::stream).toList();
    }

    @NotNull
    public List<Enrichment> enrichments() {
        return this.getActions().stream().map(Action::getEnrichments).flatMap(Collection::stream).toList();
    }

    @NotNull
    public List<Egress> getEgress() {
        if (this.egress == null) {
            this.egress = new ArrayList<Egress>();
        }
        return this.egress;
    }

    public Action lastFormatAction(String flow) {
        List<Action> formatActions = this.formatActions(flow);
        return formatActions.isEmpty() ? null : formatActions.get(formatActions.size() - 1);
    }

    private List<Action> formatActions(String flow) {
        return this.getActions().stream().filter(action -> action.getType() == ActionType.FORMAT && action.getFlow().equals(flow)).toList();
    }

    public List<Action> retriedEgressActions(String flow) {
        return this.getActions().stream().filter(action -> action.afterFormat() && action.getFlow().equals(flow) && action.getState() == ActionState.RETRIED).toList();
    }

    public boolean formatComplete(String flow) {
        List<Action> formatActions = this.formatActions(flow);
        return !formatActions.isEmpty() && formatActions.stream().anyMatch(Action::complete);
    }

    public Map<String, String> formatMetadata(String flow) {
        ArrayList<Action> metadataActions = new ArrayList<Action>(this.formatActions(flow));
        metadataActions.addAll(this.retriedEgressActions(flow));
        HashMap<String, String> formatMetadata = new HashMap<String, String>();
        for (Action action : metadataActions) {
            formatMetadata.putAll(action.getMetadata());
            for (String key : action.getDeleteMetadataKeys()) {
                formatMetadata.remove(key);
            }
        }
        return formatMetadata;
    }

    public List<Content> formatContent(String flow) {
        Action formatAction = this.lastFormatAction(flow);
        if (formatAction == null) {
            return Collections.emptyList();
        }
        return formatAction.getContent();
    }

    public DeltaFileMessage forQueue(String flow) {
        DeltaFileMessage.DeltaFileMessageBuilder builder = DeltaFileMessage.builder();
        if (this.formatComplete(flow)) {
            builder.contentList(this.formatContent(flow)).metadata(this.formatMetadata(flow));
        } else {
            builder.contentList(this.lastDataAmendedContent()).metadata(this.metadataWithFormatRetries(flow)).domains(this.domains()).enrichments(this.enrichments());
        }
        return builder.build();
    }

    public Set<Segment> referencedSegments() {
        if (this.actions == null) {
            return Collections.emptySet();
        }
        return this.actions.stream().flatMap(p -> p.getContent().stream()).flatMap(c -> c.getSegments().stream()).collect(Collectors.toSet());
    }

    public Set<Segment> storedSegments() {
        if (this.actions == null) {
            return Collections.emptySet();
        }
        return this.actions.stream().flatMap(p -> p.getContent().stream()).flatMap(c -> c.getSegments().stream()).filter(s -> s.getDid().equals(this.getDid())).collect(Collectors.toSet());
    }

    public void recalculateBytes() {
        this.setReferencedBytes(Segment.calculateTotalSize(this.referencedSegments()));
        this.setTotalBytes(Segment.calculateTotalSize(this.storedSegments()));
        this.updateFlags();
    }

    public void cancel() {
        this.cancelQueuedActions();
        this.setStage(DeltaFileStage.CANCELLED);
        this.setNextAutoResume(null);
        this.setNextAutoResumeReason(null);
    }

    public void cancelQueuedActions() {
        OffsetDateTime now = OffsetDateTime.now();
        this.getActions().stream().filter(Action::queued).forEach(a -> {
            a.setState(ActionState.CANCELLED);
            a.setModified(now);
        });
        this.setModified(now);
    }

    public void incrementRequeueCount() {
        ++this.requeueCount;
    }

    public boolean canBeCancelled() {
        return !this.inactiveStage() || this.nextAutoResume != null;
    }

    public boolean inactiveStage() {
        return this.getStage() == DeltaFileStage.COMPLETE || this.getStage() == DeltaFileStage.ERROR || this.getStage() == DeltaFileStage.CANCELLED;
    }

    public Action lastAction(String actionName) {
        if (actionName == null) {
            return null;
        }
        return this.actions.stream().filter(a -> a.getName().equals(actionName)).reduce((first, second) -> second).orElse(null);
    }

    public void acknowledgeError(@NotNull OffsetDateTime now, String reason) {
        this.errorAcknowledged = now;
        this.errorAcknowledgedReason = reason;
        this.setNextAutoResume(null);
        this.setNextAutoResumeReason(null);
        this.updateFlags();
    }

    public void clearErrorAcknowledged() {
        this.errorAcknowledged = null;
        this.errorAcknowledgedReason = null;
        this.updateFlags();
    }

    public Update generateUpdate() {
        Update update = new Update();
        boolean updated = false;
        if (!Objects.equals(this.childDids, this.snapshot.childDids)) {
            update.set("childDids", this.childDids);
            updated = true;
        }
        if (!Objects.equals(this.referencedBytes, this.snapshot.referencedBytes)) {
            update.set("referencedBytes", (Object)this.referencedBytes);
            updated = true;
        }
        if (!Objects.equals(this.totalBytes, this.snapshot.totalBytes)) {
            update.set("totalBytes", (Object)this.totalBytes);
            updated = true;
        }
        if (!Objects.equals((Object)this.stage, (Object)this.snapshot.stage)) {
            update.set("stage", (Object)this.stage);
            updated = true;
        }
        if (!Objects.equals(this.actions, this.snapshot.actions)) {
            if (this.actions.size() == this.snapshot.actions.size()) {
                for (int i = 0; i < this.snapshot.actions.size(); ++i) {
                    if (Objects.equals(this.actions.get(i), this.snapshot.actions.get(i))) continue;
                    update.set(String.format("actions.%d", i), (Object)this.actions.get(i));
                }
            } else {
                update.set("actions", this.actions);
            }
            updated = true;
        }
        if (!Objects.equals(this.annotations, this.snapshot.annotations)) {
            update.set("annotations", this.annotations);
            updated = true;
        }
        if (!Objects.equals(this.annotationKeys, this.snapshot.annotationKeys)) {
            update.set("annotationKeys", this.annotationKeys);
            updated = true;
        }
        if (!Objects.equals(this.egress, this.snapshot.egress)) {
            update.set("egress", this.egress);
            updated = true;
        }
        if (!Objects.equals(this.modified, this.snapshot.modified)) {
            update.set("modified", (Object)this.modified);
            updated = true;
        }
        if (!Objects.equals(this.errorAcknowledged, this.snapshot.errorAcknowledged)) {
            update.set("errorAcknowledged", (Object)this.errorAcknowledged);
            updated = true;
        }
        if (!Objects.equals(this.errorAcknowledgedReason, this.snapshot.errorAcknowledgedReason)) {
            update.set("errorAcknowledgedReason", (Object)this.errorAcknowledgedReason);
            updated = true;
        }
        if (!Objects.equals(this.testMode, this.snapshot.testMode)) {
            update.set("testMode", (Object)this.testMode);
            updated = true;
        }
        if (!Objects.equals(this.testModeReason, this.snapshot.testModeReason)) {
            update.set("testModeReason", (Object)this.testModeReason);
            updated = true;
        }
        if (!Objects.equals(this.egressed, this.snapshot.egressed)) {
            update.set("egressed", (Object)this.egressed);
            updated = true;
        }
        if (!Objects.equals(this.filtered, this.snapshot.filtered)) {
            update.set("filtered", (Object)this.filtered);
            updated = true;
        }
        if (!Objects.equals(this.nextAutoResume, this.snapshot.nextAutoResume)) {
            update.set("nextAutoResume", (Object)this.nextAutoResume);
            updated = true;
        }
        if (!Objects.equals(this.nextAutoResumeReason, this.snapshot.nextAutoResumeReason)) {
            update.set("nextAutoResumeReason", (Object)this.nextAutoResumeReason);
            updated = true;
        }
        if (!Objects.equals(this.pendingAnnotationsForFlows, this.snapshot.pendingAnnotationsForFlows)) {
            update.set("pendingAnnotationsForFlows", this.pendingAnnotationsForFlows);
            updated = true;
        }
        if (!Objects.equals(this.schemaVersion, this.snapshot.schemaVersion)) {
            update.set("schemaVersion", (Object)this.schemaVersion);
            updated = true;
        }
        if (!Objects.equals(this.inFlight, this.snapshot.inFlight)) {
            update.set("inFlight", (Object)this.inFlight);
            updated = true;
        }
        if (!Objects.equals(this.terminal, this.snapshot.terminal)) {
            update.set("terminal", (Object)this.terminal);
            updated = true;
        }
        if (!Objects.equals(this.contentDeletable, this.snapshot.contentDeletable)) {
            update.set("contentDeletable", (Object)this.contentDeletable);
            updated = true;
        }
        if (!updated) {
            return null;
        }
        update.set("version", (Object)(this.version + 1L));
        return update;
    }

    private static boolean $default$inFlight() {
        return true;
    }

    private static boolean $default$terminal() {
        return false;
    }

    private static boolean $default$contentDeletable() {
        return false;
    }

    public static DeltaFileBuilder builder() {
        return new DeltaFileBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public List<String> getParentDids() {
        return this.parentDids;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public List<String> getChildDids() {
        return this.childDids;
    }

    public int getRequeueCount() {
        return this.requeueCount;
    }

    public long getIngressBytes() {
        return this.ingressBytes;
    }

    public long getReferencedBytes() {
        return this.referencedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public DeltaFileStage getStage() {
        return this.stage;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OffsetDateTime getModified() {
        return this.modified;
    }

    public OffsetDateTime getContentDeleted() {
        return this.contentDeleted;
    }

    public String getContentDeletedReason() {
        return this.contentDeletedReason;
    }

    public OffsetDateTime getErrorAcknowledged() {
        return this.errorAcknowledged;
    }

    public String getErrorAcknowledgedReason() {
        return this.errorAcknowledgedReason;
    }

    public Boolean getTestMode() {
        return this.testMode;
    }

    public String getTestModeReason() {
        return this.testModeReason;
    }

    public Boolean getEgressed() {
        return this.egressed;
    }

    public Boolean getFiltered() {
        return this.filtered;
    }

    public OffsetDateTime getReplayed() {
        return this.replayed;
    }

    public String getReplayDid() {
        return this.replayDid;
    }

    public OffsetDateTime getNextAutoResume() {
        return this.nextAutoResume;
    }

    public String getNextAutoResumeReason() {
        return this.nextAutoResumeReason;
    }

    public Set<String> getPendingAnnotationsForFlows() {
        return this.pendingAnnotationsForFlows;
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean isContentDeletable() {
        return this.contentDeletable;
    }

    public DeltaFile getSnapshot() {
        return this.snapshot;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setParentDids(List<String> parentDids) {
        this.parentDids = parentDids;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public void setChildDids(List<String> childDids) {
        this.childDids = childDids;
    }

    public void setRequeueCount(int requeueCount) {
        this.requeueCount = requeueCount;
    }

    public void setIngressBytes(long ingressBytes) {
        this.ingressBytes = ingressBytes;
    }

    public void setReferencedBytes(long referencedBytes) {
        this.referencedBytes = referencedBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setAnnotationKeys(Set<String> annotationKeys) {
        this.annotationKeys = annotationKeys;
    }

    public void setEgress(List<Egress> egress) {
        this.egress = egress;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public void setModified(OffsetDateTime modified) {
        this.modified = modified;
    }

    public void setContentDeletedReason(String contentDeletedReason) {
        this.contentDeletedReason = contentDeletedReason;
    }

    public void setErrorAcknowledgedReason(String errorAcknowledgedReason) {
        this.errorAcknowledgedReason = errorAcknowledgedReason;
    }

    public void setEgressed(Boolean egressed) {
        this.egressed = egressed;
    }

    public void setFiltered(Boolean filtered) {
        this.filtered = filtered;
    }

    public void setReplayed(OffsetDateTime replayed) {
        this.replayed = replayed;
    }

    public void setReplayDid(String replayDid) {
        this.replayDid = replayDid;
    }

    public void setNextAutoResume(OffsetDateTime nextAutoResume) {
        this.nextAutoResume = nextAutoResume;
    }

    public void setNextAutoResumeReason(String nextAutoResumeReason) {
        this.nextAutoResumeReason = nextAutoResumeReason;
    }

    public void setPendingAnnotationsForFlows(Set<String> pendingAnnotationsForFlows) {
        this.pendingAnnotationsForFlows = pendingAnnotationsForFlows;
    }

    public void setInFlight(boolean inFlight) {
        this.inFlight = inFlight;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    public void setContentDeletable(boolean contentDeletable) {
        this.contentDeletable = contentDeletable;
    }

    public void setSnapshot(DeltaFile snapshot) {
        this.snapshot = snapshot;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeltaFile)) {
            return false;
        }
        DeltaFile other = (DeltaFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAggregate() != other.isAggregate()) {
            return false;
        }
        if (this.getRequeueCount() != other.getRequeueCount()) {
            return false;
        }
        if (this.getIngressBytes() != other.getIngressBytes()) {
            return false;
        }
        if (this.getReferencedBytes() != other.getReferencedBytes()) {
            return false;
        }
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        if (this.isInFlight() != other.isInFlight()) {
            return false;
        }
        if (this.isTerminal() != other.isTerminal()) {
            return false;
        }
        if (this.isContentDeletable() != other.isContentDeletable()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getSchemaVersion() != other.getSchemaVersion()) {
            return false;
        }
        Boolean this$testMode = this.getTestMode();
        Boolean other$testMode = other.getTestMode();
        if (this$testMode == null ? other$testMode != null : !((Object)this$testMode).equals(other$testMode)) {
            return false;
        }
        Boolean this$egressed = this.getEgressed();
        Boolean other$egressed = other.getEgressed();
        if (this$egressed == null ? other$egressed != null : !((Object)this$egressed).equals(other$egressed)) {
            return false;
        }
        Boolean this$filtered = this.getFiltered();
        Boolean other$filtered = other.getFiltered();
        if (this$filtered == null ? other$filtered != null : !((Object)this$filtered).equals(other$filtered)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        List<String> this$parentDids = this.getParentDids();
        List<String> other$parentDids = other.getParentDids();
        if (this$parentDids == null ? other$parentDids != null : !((Object)this$parentDids).equals(other$parentDids)) {
            return false;
        }
        List<String> this$childDids = this.getChildDids();
        List<String> other$childDids = other.getChildDids();
        if (this$childDids == null ? other$childDids != null : !((Object)this$childDids).equals(other$childDids)) {
            return false;
        }
        DeltaFileStage this$stage = this.getStage();
        DeltaFileStage other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        SourceInfo this$sourceInfo = this.getSourceInfo();
        SourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !((Object)this$sourceInfo).equals(other$sourceInfo)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Set<String> this$annotationKeys = this.getAnnotationKeys();
        Set<String> other$annotationKeys = other.getAnnotationKeys();
        if (this$annotationKeys == null ? other$annotationKeys != null : !((Object)this$annotationKeys).equals(other$annotationKeys)) {
            return false;
        }
        List<Egress> this$egress = this.getEgress();
        List<Egress> other$egress = other.getEgress();
        if (this$egress == null ? other$egress != null : !((Object)this$egress).equals(other$egress)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        OffsetDateTime this$modified = this.getModified();
        OffsetDateTime other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        OffsetDateTime this$contentDeleted = this.getContentDeleted();
        OffsetDateTime other$contentDeleted = other.getContentDeleted();
        if (this$contentDeleted == null ? other$contentDeleted != null : !((Object)this$contentDeleted).equals(other$contentDeleted)) {
            return false;
        }
        String this$contentDeletedReason = this.getContentDeletedReason();
        String other$contentDeletedReason = other.getContentDeletedReason();
        if (this$contentDeletedReason == null ? other$contentDeletedReason != null : !this$contentDeletedReason.equals(other$contentDeletedReason)) {
            return false;
        }
        OffsetDateTime this$errorAcknowledged = this.getErrorAcknowledged();
        OffsetDateTime other$errorAcknowledged = other.getErrorAcknowledged();
        if (this$errorAcknowledged == null ? other$errorAcknowledged != null : !((Object)this$errorAcknowledged).equals(other$errorAcknowledged)) {
            return false;
        }
        String this$errorAcknowledgedReason = this.getErrorAcknowledgedReason();
        String other$errorAcknowledgedReason = other.getErrorAcknowledgedReason();
        if (this$errorAcknowledgedReason == null ? other$errorAcknowledgedReason != null : !this$errorAcknowledgedReason.equals(other$errorAcknowledgedReason)) {
            return false;
        }
        String this$testModeReason = this.getTestModeReason();
        String other$testModeReason = other.getTestModeReason();
        if (this$testModeReason == null ? other$testModeReason != null : !this$testModeReason.equals(other$testModeReason)) {
            return false;
        }
        OffsetDateTime this$replayed = this.getReplayed();
        OffsetDateTime other$replayed = other.getReplayed();
        if (this$replayed == null ? other$replayed != null : !((Object)this$replayed).equals(other$replayed)) {
            return false;
        }
        String this$replayDid = this.getReplayDid();
        String other$replayDid = other.getReplayDid();
        if (this$replayDid == null ? other$replayDid != null : !this$replayDid.equals(other$replayDid)) {
            return false;
        }
        OffsetDateTime this$nextAutoResume = this.getNextAutoResume();
        OffsetDateTime other$nextAutoResume = other.getNextAutoResume();
        if (this$nextAutoResume == null ? other$nextAutoResume != null : !((Object)this$nextAutoResume).equals(other$nextAutoResume)) {
            return false;
        }
        String this$nextAutoResumeReason = this.getNextAutoResumeReason();
        String other$nextAutoResumeReason = other.getNextAutoResumeReason();
        if (this$nextAutoResumeReason == null ? other$nextAutoResumeReason != null : !this$nextAutoResumeReason.equals(other$nextAutoResumeReason)) {
            return false;
        }
        Set<String> this$pendingAnnotationsForFlows = this.getPendingAnnotationsForFlows();
        Set<String> other$pendingAnnotationsForFlows = other.getPendingAnnotationsForFlows();
        if (this$pendingAnnotationsForFlows == null ? other$pendingAnnotationsForFlows != null : !((Object)this$pendingAnnotationsForFlows).equals(other$pendingAnnotationsForFlows)) {
            return false;
        }
        OffsetDateTime this$cacheTime = this.getCacheTime();
        OffsetDateTime other$cacheTime = other.getCacheTime();
        if (this$cacheTime == null ? other$cacheTime != null : !((Object)this$cacheTime).equals(other$cacheTime)) {
            return false;
        }
        DeltaFile this$snapshot = this.getSnapshot();
        DeltaFile other$snapshot = other.getSnapshot();
        return !(this$snapshot == null ? other$snapshot != null : !((Object)this$snapshot).equals(other$snapshot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeltaFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAggregate() ? 79 : 97);
        result = result * 59 + this.getRequeueCount();
        long $ingressBytes = this.getIngressBytes();
        result = result * 59 + (int)($ingressBytes >>> 32 ^ $ingressBytes);
        long $referencedBytes = this.getReferencedBytes();
        result = result * 59 + (int)($referencedBytes >>> 32 ^ $referencedBytes);
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        result = result * 59 + (this.isInFlight() ? 79 : 97);
        result = result * 59 + (this.isTerminal() ? 79 : 97);
        result = result * 59 + (this.isContentDeletable() ? 79 : 97);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + this.getSchemaVersion();
        Boolean $testMode = this.getTestMode();
        result = result * 59 + ($testMode == null ? 43 : ((Object)$testMode).hashCode());
        Boolean $egressed = this.getEgressed();
        result = result * 59 + ($egressed == null ? 43 : ((Object)$egressed).hashCode());
        Boolean $filtered = this.getFiltered();
        result = result * 59 + ($filtered == null ? 43 : ((Object)$filtered).hashCode());
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        List<String> $parentDids = this.getParentDids();
        result = result * 59 + ($parentDids == null ? 43 : ((Object)$parentDids).hashCode());
        List<String> $childDids = this.getChildDids();
        result = result * 59 + ($childDids == null ? 43 : ((Object)$childDids).hashCode());
        DeltaFileStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        SourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : ((Object)$sourceInfo).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Set<String> $annotationKeys = this.getAnnotationKeys();
        result = result * 59 + ($annotationKeys == null ? 43 : ((Object)$annotationKeys).hashCode());
        List<Egress> $egress = this.getEgress();
        result = result * 59 + ($egress == null ? 43 : ((Object)$egress).hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        OffsetDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        OffsetDateTime $contentDeleted = this.getContentDeleted();
        result = result * 59 + ($contentDeleted == null ? 43 : ((Object)$contentDeleted).hashCode());
        String $contentDeletedReason = this.getContentDeletedReason();
        result = result * 59 + ($contentDeletedReason == null ? 43 : $contentDeletedReason.hashCode());
        OffsetDateTime $errorAcknowledged = this.getErrorAcknowledged();
        result = result * 59 + ($errorAcknowledged == null ? 43 : ((Object)$errorAcknowledged).hashCode());
        String $errorAcknowledgedReason = this.getErrorAcknowledgedReason();
        result = result * 59 + ($errorAcknowledgedReason == null ? 43 : $errorAcknowledgedReason.hashCode());
        String $testModeReason = this.getTestModeReason();
        result = result * 59 + ($testModeReason == null ? 43 : $testModeReason.hashCode());
        OffsetDateTime $replayed = this.getReplayed();
        result = result * 59 + ($replayed == null ? 43 : ((Object)$replayed).hashCode());
        String $replayDid = this.getReplayDid();
        result = result * 59 + ($replayDid == null ? 43 : $replayDid.hashCode());
        OffsetDateTime $nextAutoResume = this.getNextAutoResume();
        result = result * 59 + ($nextAutoResume == null ? 43 : ((Object)$nextAutoResume).hashCode());
        String $nextAutoResumeReason = this.getNextAutoResumeReason();
        result = result * 59 + ($nextAutoResumeReason == null ? 43 : $nextAutoResumeReason.hashCode());
        Set<String> $pendingAnnotationsForFlows = this.getPendingAnnotationsForFlows();
        result = result * 59 + ($pendingAnnotationsForFlows == null ? 43 : ((Object)$pendingAnnotationsForFlows).hashCode());
        OffsetDateTime $cacheTime = this.getCacheTime();
        result = result * 59 + ($cacheTime == null ? 43 : ((Object)$cacheTime).hashCode());
        DeltaFile $snapshot = this.getSnapshot();
        result = result * 59 + ($snapshot == null ? 43 : ((Object)$snapshot).hashCode());
        return result;
    }

    public String toString() {
        return "DeltaFile(did=" + this.getDid() + ", parentDids=" + this.getParentDids() + ", aggregate=" + this.isAggregate() + ", childDids=" + this.getChildDids() + ", requeueCount=" + this.getRequeueCount() + ", ingressBytes=" + this.getIngressBytes() + ", referencedBytes=" + this.getReferencedBytes() + ", totalBytes=" + this.getTotalBytes() + ", stage=" + this.getStage() + ", actions=" + this.getActions() + ", sourceInfo=" + this.getSourceInfo() + ", annotations=" + this.getAnnotations() + ", annotationKeys=" + this.getAnnotationKeys() + ", egress=" + this.getEgress() + ", created=" + this.getCreated() + ", modified=" + this.getModified() + ", contentDeleted=" + this.getContentDeleted() + ", contentDeletedReason=" + this.getContentDeletedReason() + ", errorAcknowledged=" + this.getErrorAcknowledged() + ", errorAcknowledgedReason=" + this.getErrorAcknowledgedReason() + ", testMode=" + this.getTestMode() + ", testModeReason=" + this.getTestModeReason() + ", egressed=" + this.getEgressed() + ", filtered=" + this.getFiltered() + ", replayed=" + this.getReplayed() + ", replayDid=" + this.getReplayDid() + ", nextAutoResume=" + this.getNextAutoResume() + ", nextAutoResumeReason=" + this.getNextAutoResumeReason() + ", pendingAnnotationsForFlows=" + this.getPendingAnnotationsForFlows() + ", inFlight=" + this.isInFlight() + ", terminal=" + this.isTerminal() + ", contentDeletable=" + this.isContentDeletable() + ", version=" + this.getVersion() + ", cacheTime=" + this.getCacheTime() + ", snapshot=" + this.getSnapshot() + ", schemaVersion=" + this.getSchemaVersion() + ")";
    }

    public DeltaFile(String did, List<String> parentDids, boolean aggregate, List<String> childDids, int requeueCount, long ingressBytes, long referencedBytes, long totalBytes, DeltaFileStage stage, List<Action> actions, SourceInfo sourceInfo, Map<String, String> annotations, Set<String> annotationKeys, List<Egress> egress, OffsetDateTime created, OffsetDateTime modified, OffsetDateTime contentDeleted, String contentDeletedReason, OffsetDateTime errorAcknowledged, String errorAcknowledgedReason, Boolean testMode, String testModeReason, Boolean egressed, Boolean filtered, OffsetDateTime replayed, String replayDid, OffsetDateTime nextAutoResume, String nextAutoResumeReason, Set<String> pendingAnnotationsForFlows, boolean inFlight, boolean terminal, boolean contentDeletable, long version, OffsetDateTime cacheTime, DeltaFile snapshot, int schemaVersion) {
        this.did = did;
        this.parentDids = parentDids;
        this.aggregate = aggregate;
        this.childDids = childDids;
        this.requeueCount = requeueCount;
        this.ingressBytes = ingressBytes;
        this.referencedBytes = referencedBytes;
        this.totalBytes = totalBytes;
        this.stage = stage;
        this.actions = actions;
        this.sourceInfo = sourceInfo;
        this.annotations = annotations;
        this.annotationKeys = annotationKeys;
        this.egress = egress;
        this.created = created;
        this.modified = modified;
        this.contentDeleted = contentDeleted;
        this.contentDeletedReason = contentDeletedReason;
        this.errorAcknowledged = errorAcknowledged;
        this.errorAcknowledgedReason = errorAcknowledgedReason;
        this.testMode = testMode;
        this.testModeReason = testModeReason;
        this.egressed = egressed;
        this.filtered = filtered;
        this.replayed = replayed;
        this.replayDid = replayDid;
        this.nextAutoResume = nextAutoResume;
        this.nextAutoResumeReason = nextAutoResumeReason;
        this.pendingAnnotationsForFlows = pendingAnnotationsForFlows;
        this.inFlight = inFlight;
        this.terminal = terminal;
        this.contentDeletable = contentDeletable;
        this.version = version;
        this.cacheTime = cacheTime;
        this.snapshot = snapshot;
        this.schemaVersion = schemaVersion;
    }

    public DeltaFile() {
        this.inFlight = DeltaFile.$default$inFlight();
        this.terminal = DeltaFile.$default$terminal();
        this.contentDeletable = DeltaFile.$default$contentDeletable();
    }

    public long getVersion() {
        return this.version;
    }

    @JsonIgnore
    public void setVersion(long version) {
        this.version = version;
    }

    public OffsetDateTime getCacheTime() {
        return this.cacheTime;
    }

    @JsonIgnore
    public void setCacheTime(OffsetDateTime cacheTime) {
        this.cacheTime = cacheTime;
    }

    public static class DeltaFileBuilder {
        private String did;
        private List<String> parentDids;
        private boolean aggregate;
        private List<String> childDids;
        private int requeueCount;
        private long ingressBytes;
        private long referencedBytes;
        private long totalBytes;
        private DeltaFileStage stage;
        private List<Action> actions;
        private SourceInfo sourceInfo;
        private Map<String, String> annotations;
        private Set<String> annotationKeys;
        private List<Egress> egress;
        private OffsetDateTime created;
        private OffsetDateTime modified;
        private OffsetDateTime contentDeleted;
        private String contentDeletedReason;
        private OffsetDateTime errorAcknowledged;
        private String errorAcknowledgedReason;
        private Boolean testMode;
        private String testModeReason;
        private Boolean egressed;
        private Boolean filtered;
        private OffsetDateTime replayed;
        private String replayDid;
        private OffsetDateTime nextAutoResume;
        private String nextAutoResumeReason;
        private Set<String> pendingAnnotationsForFlows;
        private boolean inFlight$set;
        private boolean inFlight$value;
        private boolean terminal$set;
        private boolean terminal$value;
        private boolean contentDeletable$set;
        private boolean contentDeletable$value;
        private long version;
        private OffsetDateTime cacheTime;
        private DeltaFile snapshot;
        private int schemaVersion;

        DeltaFileBuilder() {
        }

        public DeltaFileBuilder did(String did) {
            this.did = did;
            return this;
        }

        public DeltaFileBuilder parentDids(List<String> parentDids) {
            this.parentDids = parentDids;
            return this;
        }

        public DeltaFileBuilder aggregate(boolean aggregate) {
            this.aggregate = aggregate;
            return this;
        }

        public DeltaFileBuilder childDids(List<String> childDids) {
            this.childDids = childDids;
            return this;
        }

        public DeltaFileBuilder requeueCount(int requeueCount) {
            this.requeueCount = requeueCount;
            return this;
        }

        public DeltaFileBuilder ingressBytes(long ingressBytes) {
            this.ingressBytes = ingressBytes;
            return this;
        }

        public DeltaFileBuilder referencedBytes(long referencedBytes) {
            this.referencedBytes = referencedBytes;
            return this;
        }

        public DeltaFileBuilder totalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public DeltaFileBuilder stage(DeltaFileStage stage) {
            this.stage = stage;
            return this;
        }

        public DeltaFileBuilder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public DeltaFileBuilder sourceInfo(SourceInfo sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        public DeltaFileBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public DeltaFileBuilder annotationKeys(Set<String> annotationKeys) {
            this.annotationKeys = annotationKeys;
            return this;
        }

        public DeltaFileBuilder egress(List<Egress> egress) {
            this.egress = egress;
            return this;
        }

        public DeltaFileBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public DeltaFileBuilder modified(OffsetDateTime modified) {
            this.modified = modified;
            return this;
        }

        public DeltaFileBuilder contentDeleted(OffsetDateTime contentDeleted) {
            this.contentDeleted = contentDeleted;
            return this;
        }

        public DeltaFileBuilder contentDeletedReason(String contentDeletedReason) {
            this.contentDeletedReason = contentDeletedReason;
            return this;
        }

        public DeltaFileBuilder errorAcknowledged(OffsetDateTime errorAcknowledged) {
            this.errorAcknowledged = errorAcknowledged;
            return this;
        }

        public DeltaFileBuilder errorAcknowledgedReason(String errorAcknowledgedReason) {
            this.errorAcknowledgedReason = errorAcknowledgedReason;
            return this;
        }

        public DeltaFileBuilder testMode(Boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public DeltaFileBuilder testModeReason(String testModeReason) {
            this.testModeReason = testModeReason;
            return this;
        }

        public DeltaFileBuilder egressed(Boolean egressed) {
            this.egressed = egressed;
            return this;
        }

        public DeltaFileBuilder filtered(Boolean filtered) {
            this.filtered = filtered;
            return this;
        }

        public DeltaFileBuilder replayed(OffsetDateTime replayed) {
            this.replayed = replayed;
            return this;
        }

        public DeltaFileBuilder replayDid(String replayDid) {
            this.replayDid = replayDid;
            return this;
        }

        public DeltaFileBuilder nextAutoResume(OffsetDateTime nextAutoResume) {
            this.nextAutoResume = nextAutoResume;
            return this;
        }

        public DeltaFileBuilder nextAutoResumeReason(String nextAutoResumeReason) {
            this.nextAutoResumeReason = nextAutoResumeReason;
            return this;
        }

        public DeltaFileBuilder pendingAnnotationsForFlows(Set<String> pendingAnnotationsForFlows) {
            this.pendingAnnotationsForFlows = pendingAnnotationsForFlows;
            return this;
        }

        public DeltaFileBuilder inFlight(boolean inFlight) {
            this.inFlight$value = inFlight;
            this.inFlight$set = true;
            return this;
        }

        public DeltaFileBuilder terminal(boolean terminal) {
            this.terminal$value = terminal;
            this.terminal$set = true;
            return this;
        }

        public DeltaFileBuilder contentDeletable(boolean contentDeletable) {
            this.contentDeletable$value = contentDeletable;
            this.contentDeletable$set = true;
            return this;
        }

        @JsonIgnore
        public DeltaFileBuilder version(long version) {
            this.version = version;
            return this;
        }

        @JsonIgnore
        public DeltaFileBuilder cacheTime(OffsetDateTime cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        public DeltaFileBuilder snapshot(DeltaFile snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public DeltaFileBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public DeltaFile build() {
            boolean inFlight$value = this.inFlight$value;
            if (!this.inFlight$set) {
                inFlight$value = DeltaFile.$default$inFlight();
            }
            boolean terminal$value = this.terminal$value;
            if (!this.terminal$set) {
                terminal$value = DeltaFile.$default$terminal();
            }
            boolean contentDeletable$value = this.contentDeletable$value;
            if (!this.contentDeletable$set) {
                contentDeletable$value = DeltaFile.$default$contentDeletable();
            }
            return new DeltaFile(this.did, this.parentDids, this.aggregate, this.childDids, this.requeueCount, this.ingressBytes, this.referencedBytes, this.totalBytes, this.stage, this.actions, this.sourceInfo, this.annotations, this.annotationKeys, this.egress, this.created, this.modified, this.contentDeleted, this.contentDeletedReason, this.errorAcknowledged, this.errorAcknowledgedReason, this.testMode, this.testModeReason, this.egressed, this.filtered, this.replayed, this.replayDid, this.nextAutoResume, this.nextAutoResumeReason, this.pendingAnnotationsForFlows, inFlight$value, terminal$value, contentDeletable$value, this.version, this.cacheTime, this.snapshot, this.schemaVersion);
        }

        public String toString() {
            return "DeltaFile.DeltaFileBuilder(did=" + this.did + ", parentDids=" + this.parentDids + ", aggregate=" + this.aggregate + ", childDids=" + this.childDids + ", requeueCount=" + this.requeueCount + ", ingressBytes=" + this.ingressBytes + ", referencedBytes=" + this.referencedBytes + ", totalBytes=" + this.totalBytes + ", stage=" + this.stage + ", actions=" + this.actions + ", sourceInfo=" + this.sourceInfo + ", annotations=" + this.annotations + ", annotationKeys=" + this.annotationKeys + ", egress=" + this.egress + ", created=" + this.created + ", modified=" + this.modified + ", contentDeleted=" + this.contentDeleted + ", contentDeletedReason=" + this.contentDeletedReason + ", errorAcknowledged=" + this.errorAcknowledged + ", errorAcknowledgedReason=" + this.errorAcknowledgedReason + ", testMode=" + this.testMode + ", testModeReason=" + this.testModeReason + ", egressed=" + this.egressed + ", filtered=" + this.filtered + ", replayed=" + this.replayed + ", replayDid=" + this.replayDid + ", nextAutoResume=" + this.nextAutoResume + ", nextAutoResumeReason=" + this.nextAutoResumeReason + ", pendingAnnotationsForFlows=" + this.pendingAnnotationsForFlows + ", inFlight$value=" + this.inFlight$value + ", terminal$value=" + this.terminal$value + ", contentDeletable$value=" + this.contentDeletable$value + ", version=" + this.version + ", cacheTime=" + this.cacheTime + ", snapshot=" + this.snapshot + ", schemaVersion=" + this.schemaVersion + ")";
        }
    }
}

