/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Metric {
    private String name;
    private long value;
    private Map<String, String> tags;

    public Metric(String name, long value) {
        this.name = name;
        this.value = value;
        this.tags = new HashMap<String, String>();
    }

    public Metric addTag(String key, String value) {
        if (key.contains("=") || key.contains(";")) {
            throw new IllegalArgumentException("Metric keys (" + key + "," + value + ") cannot contain = or ;");
        }
        if (value.contains("=") || value.contains(";")) {
            throw new IllegalArgumentException("Metric values (" + key + "," + value + ") cannot contain = or ;");
        }
        this.tags.put(key, value);
        return this;
    }

    public Metric addTags(@NotNull Map<String, String> map) {
        map.forEach(this::addTag);
        return this;
    }

    public void removeTag(String key) {
        this.tags.remove(key);
    }

    @JsonIgnore
    public String metricName() {
        if (this.tags.isEmpty()) {
            return this.name;
        }
        StringBuilder taglist = new StringBuilder(this.name);
        this.tags.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            taglist.append(";");
            taglist.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        });
        return taglist.toString();
    }

    private static Map<String, String> $default$tags() {
        return new HashMap<String, String>();
    }

    public static MetricBuilder builder() {
        return new MetricBuilder();
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metric)) {
            return false;
        }
        Metric other = (Metric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Metric(name=" + this.getName() + ", value=" + this.getValue() + ", tags=" + this.getTags() + ")";
    }

    public Metric() {
        this.tags = Metric.$default$tags();
    }

    public Metric(String name, long value, Map<String, String> tags) {
        this.name = name;
        this.value = value;
        this.tags = tags;
    }

    public static class MetricBuilder {
        private String name;
        private long value;
        private boolean tags$set;
        private Map<String, String> tags$value;

        MetricBuilder() {
        }

        public MetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricBuilder value(long value) {
            this.value = value;
            return this;
        }

        public MetricBuilder tags(Map<String, String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return this;
        }

        public Metric build() {
            Map<String, String> tags$value = this.tags$value;
            if (!this.tags$set) {
                tags$value = Metric.$default$tags();
            }
            return new Metric(this.name, this.value, tags$value);
        }

        public String toString() {
            return "Metric.MetricBuilder(name=" + this.name + ", value=" + this.value + ", tags$value=" + this.tags$value + ")";
        }
    }
}

