/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.EgressActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.FormatActionConfiguration;
import org.deltafi.common.types.ValidateActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class EgressFlowPlan
extends FlowPlan {
    @JsonAlias(value={"includeNormalizeFlows", "includeIngressFlows"})
    private List<String> includeNormalizeFlows;
    @JsonAlias(value={"excludeNormalizeFlows", "excludeIngressFlows"})
    private List<String> excludeNormalizeFlows;
    private final FormatActionConfiguration formatAction;
    private List<ValidateActionConfiguration> validateActions;
    private final EgressActionConfiguration egressAction;

    public EgressFlowPlan(String name, String description, FormatActionConfiguration formatAction, EgressActionConfiguration egressAction) {
        super(name, FlowType.EGRESS, description);
        this.formatAction = formatAction;
        this.egressAction = egressAction;
    }

    public EgressFlowPlan(String name, String description, FormatActionConfiguration formatAction, List<ValidateActionConfiguration> validateActions, EgressActionConfiguration egressAction) {
        super(name, FlowType.EGRESS, description);
        this.formatAction = formatAction;
        this.validateActions = validateActions;
        this.egressAction = egressAction;
    }

    @PersistenceCreator
    @JsonCreator
    public EgressFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="formatAction", required=true) FormatActionConfiguration formatAction, @JsonProperty(value="validateActions") List<ValidateActionConfiguration> validateActions, @JsonProperty(value="egressAction", required=true) EgressActionConfiguration egressAction) {
        this(name, description, formatAction, validateActions, egressAction);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.formatAction != null) {
            actionConfigurations.add(this.formatAction);
        }
        if (this.validateActions != null) {
            actionConfigurations.addAll(this.validateActions);
        }
        if (this.egressAction != null) {
            actionConfigurations.add(this.egressAction);
        }
        return actionConfigurations;
    }

    public List<String> getIncludeNormalizeFlows() {
        return this.includeNormalizeFlows;
    }

    public List<String> getExcludeNormalizeFlows() {
        return this.excludeNormalizeFlows;
    }

    public FormatActionConfiguration getFormatAction() {
        return this.formatAction;
    }

    public List<ValidateActionConfiguration> getValidateActions() {
        return this.validateActions;
    }

    public EgressActionConfiguration getEgressAction() {
        return this.egressAction;
    }

    @JsonAlias(value={"includeNormalizeFlows", "includeIngressFlows"})
    public void setIncludeNormalizeFlows(List<String> includeNormalizeFlows) {
        this.includeNormalizeFlows = includeNormalizeFlows;
    }

    @JsonAlias(value={"excludeNormalizeFlows", "excludeIngressFlows"})
    public void setExcludeNormalizeFlows(List<String> excludeNormalizeFlows) {
        this.excludeNormalizeFlows = excludeNormalizeFlows;
    }

    public void setValidateActions(List<ValidateActionConfiguration> validateActions) {
        this.validateActions = validateActions;
    }
}

