/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.deltafi.common.content.Segment;

public class Content {
    private String name;
    private String mediaType;
    private List<Segment> segments = new ArrayList<Segment>();

    public Content(Content other) {
        this.name = other.name;
        this.mediaType = other.mediaType;
        this.segments = other.segments.stream().map(Segment::new).toList();
    }

    public Content(String name, String mediaType) {
        this.name = name;
        this.mediaType = mediaType;
    }

    public Content(String name, String mediaType, Segment segment) {
        this.name = name;
        this.mediaType = mediaType;
        this.segments.add(segment);
    }

    public Content(String name, String mediaType, List<Segment> segments, long ignored) {
        this.name = name;
        this.mediaType = mediaType;
        this.segments = Collections.unmodifiableList(segments);
    }

    public void setSize(long ignored) {
    }

    public long getSize() {
        return Content.sumSegmentSizes(this.segments);
    }

    public Content subcontent(long offset, long size, String name, String mediaType) {
        return new Content(name, mediaType, this.subreferenceSegments(offset, size));
    }

    public Content subcontent(long offset, long size) {
        return this.subcontent(offset, size, this.name, this.mediaType);
    }

    public List<Segment> subreferenceSegments(long offset, long size) {
        if (offset < 0L) {
            throw new IllegalArgumentException("subreference offset must be positive, got " + offset);
        }
        if (size < 0L) {
            throw new IllegalArgumentException("subreference size must be positive, got " + size);
        }
        if (size + offset > this.getSize()) {
            throw new IllegalArgumentException("Size + offset ( " + size + " + " + offset + ") exceeds total Content size of " + this.getSize());
        }
        if (size == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Segment> newSegments = new ArrayList<Segment>();
        long offsetRemaining = offset;
        long sizeRemaining = size;
        for (Segment segment : this.segments) {
            Segment newSegment = new Segment(segment);
            if (offsetRemaining > 0L) {
                if (newSegment.getSize() < offsetRemaining) {
                    offsetRemaining -= newSegment.getSize();
                    continue;
                }
                newSegment.setOffset(newSegment.getOffset() + offsetRemaining);
                newSegment.setSize(newSegment.getSize() - offsetRemaining);
                offsetRemaining = 0L;
            }
            if (sizeRemaining < newSegment.getSize()) {
                newSegment.setSize(sizeRemaining);
            }
            newSegments.add(newSegment);
            if ((sizeRemaining -= newSegment.getSize()) != 0L) continue;
            break;
        }
        return newSegments;
    }

    private static long sumSegmentSizes(List<Segment> segments) {
        return segments != null ? segments.stream().mapToLong(Segment::getSize).sum() : 0L;
    }

    public Content copy() {
        return new Content(this.name, this.mediaType, new ArrayList<Segment>(this.segments));
    }

    public String getName() {
        return this.name;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Content)) {
            return false;
        }
        Content other = (Content)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        List<Segment> this$segments = this.getSegments();
        List<Segment> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Content;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        List<Segment> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }

    public String toString() {
        return "Content(name=" + this.getName() + ", mediaType=" + this.getMediaType() + ", segments=" + this.getSegments() + ")";
    }

    public Content() {
    }

    public Content(String name, String mediaType, List<Segment> segments) {
        this.name = name;
        this.mediaType = mediaType;
        this.segments = segments;
    }
}

