/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VariableDataType {
    STRING,
    BOOLEAN{

        @Override
        public String formatString(String value) {
            return null != value ? value.trim().toLowerCase(Locale.ROOT) : null;
        }

        @Override
        public String runValidateValue(String value) {
            if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                return "A boolean value must be true or false";
            }
            return null;
        }

        @Override
        public Object convertValue(String value) {
            return Boolean.parseBoolean(value);
        }
    }
    ,
    NUMBER{

        @Override
        public String runValidateValue(String value) {
            if (!NumberUtils.isCreatable((String)value)) {
                return "The value " + value + " cannot be converted to a number";
            }
            return null;
        }

        @Override
        public Object convertValue(String value) {
            return NumberUtils.createNumber((String)value);
        }
    }
    ,
    LIST{

        @Override
        public String formatString(String value) {
            return 3.wrapIfMissing(value, "[", "]");
        }

        @Override
        public Object convertValue(String value) {
            return VariableDataType.readStringAsList(value);
        }
    }
    ,
    MAP{

        @Override
        public String formatString(String value) {
            return 4.wrapIfMissing(value, "{", "}");
        }

        @Override
        public String runValidateValue(String value) {
            if (!value.isBlank() && 4.readStringAsMap(value).isEmpty()) {
                return "A map value must be of the form of 'key: value, nextKey: nextValue'";
            }
            return null;
        }

        @Override
        public Object convertValue(String value) {
            return VariableDataType.readStringAsMap(value);
        }
    };


    public String formatString(String value) {
        return null != value ? value.trim() : null;
    }

    public String validateValue(String value) {
        return null == value ? null : this.runValidateValue(value.trim());
    }

    public Object convertValue(String value) {
        return value;
    }

    String runValidateValue(String value) {
        return null;
    }

    static String wrapIfMissing(String value, String start, String close) {
        if (value == null) {
            return null;
        }
        if (!VariableDataType.isWrapped(value = value.trim(), start, close)) {
            return start + value + close;
        }
        return value;
    }

    static String stripIfWrapped(@NotNull String value, String start, String close) {
        if (VariableDataType.isWrapped(value = value.trim(), start, close)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    static boolean isWrapped(String value, String start, String close) {
        return value.startsWith(start) && value.endsWith(close);
    }

    public static Map<Object, Object> readStringAsMap(String value) {
        if (value == null) {
            return Map.of();
        }
        if ((value = VariableDataType.stripIfWrapped(value.trim(), "{", "}")).isBlank()) {
            return Map.of();
        }
        return VariableDataType.readStringAsList(value).stream().map(VariableDataType::toEntry).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<Object, Object> toEntry(String value) {
        List<String> pair = VariableDataType.splitDelimitedValue(value, ':');
        return switch (pair.size()) {
            case 0 -> null;
            case 1 -> throw new IllegalArgumentException("The value '" + value + "' contains an invalid key value pair, no delimiters found. The key value pair must be of the format key: value");
            case 2 -> Map.entry(pair.get(0).trim(), pair.get(1).trim());
            default -> throw new IllegalArgumentException("The value '" + value + "' contains an invalid key value pair, multiple delimiters found. The key value pair must be of the format key: value");
        };
    }

    public static List<String> readStringAsList(String value) {
        if (value == null) {
            return List.of();
        }
        if ((value = VariableDataType.stripIfWrapped(value, "[", "]")).isBlank()) {
            return List.of();
        }
        return VariableDataType.splitDelimitedValue(value, ',').stream().filter(s -> !s.isEmpty()).toList();
    }

    private static List<String> splitDelimitedValue(String value, char delimiter) {
        boolean escaped = false;
        ArrayList<String> splitValues = new ArrayList<String>();
        int idx = 0;
        for (char c : value.toCharArray()) {
            if (!escaped && c == '\\') {
                escaped = true;
                ++idx;
                continue;
            }
            if (!escaped && c == delimiter) {
                splitValues.add(VariableDataType.replaceEscapedDelimiterAndTrim(value.substring(0, idx), delimiter));
                value = value.substring(idx + 1);
                idx = 0;
                continue;
            }
            escaped = false;
            ++idx;
        }
        splitValues.add(VariableDataType.replaceEscapedDelimiterAndTrim(value, delimiter));
        return splitValues;
    }

    private static String replaceEscapedDelimiterAndTrim(String value, char delimiter) {
        return value.replaceAll("\\\\" + delimiter, String.valueOf(delimiter)).trim();
    }
}

