/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.queue.jedis;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.deltafi.common.queue.jedis.SortedSetEntry;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.resps.ScanResult;

public class JedisKeyedBlockingQueue {
    private static final String HEARTBEAT_HASH = "org.deltafi.action-queue.heartbeat";
    private final JedisPool jedisPool;

    public JedisKeyedBlockingQueue(String url, String password, int maxIdle, int maxTotal) throws URISyntaxException {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        URI uri = new URI(url);
        this.jedisPool = password == null || password.isEmpty() ? new JedisPool(poolConfig, uri) : new JedisPool(poolConfig, uri.getHost(), uri.getPort(), 2000, password);
    }

    public void put(SortedSetEntry entry) {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.put(jedis, entry);
        }
    }

    public boolean exists(String key, String search) {
        ScanParams scanParams = new ScanParams().match(search);
        try (Jedis jedis = this.jedisPool.getResource();){
            ScanResult scanResult = jedis.zscan(key, ScanParams.SCAN_POINTER_START, scanParams);
            boolean bl = !scanResult.getResult().isEmpty();
            return bl;
        }
    }

    public void drop(List<String> keys) {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.drop(jedis, keys);
        }
    }

    private void drop(Jedis jedis, List<String> keys) {
        keys.forEach(arg_0 -> ((Jedis)jedis).del(arg_0));
    }

    private void put(Jedis jedis, SortedSetEntry entry) {
        jedis.zadd(entry.getKey(), (double)entry.getScoreEpochMilli(), entry.getValue(), ZAddParams.zAddParams().nx());
    }

    public void put(List<SortedSetEntry> items) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            items.forEach(item -> p.zadd(item.getKey(), (double)item.getScoreEpochMilli(), item.getValue(), ZAddParams.zAddParams().nx()));
            p.sync();
        }
    }

    public void setHeartbeat(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.hset(HEARTBEAT_HASH, key, OffsetDateTime.now().toString());
        }
    }

    public String take(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            KeyedZSetElement keyedZSetElement = jedis.bzpopmin(0.0, new String[]{key});
            String string = keyedZSetElement.getElement();
            return string;
        }
    }
}

