/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.deltafi.common.types.ActionContext;
import org.deltafi.common.types.ActionDescriptor;
import org.deltafi.common.types.ActionInput;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.DeltaFiConfiguration;
import org.deltafi.common.types.DeltaFile;
import org.deltafi.common.types.DomainActionConfiguration;
import org.deltafi.common.types.EgressActionConfiguration;
import org.deltafi.common.types.EnrichActionConfiguration;
import org.deltafi.common.types.FormatActionConfiguration;
import org.deltafi.common.types.LoadActionConfiguration;
import org.deltafi.common.types.TransformActionConfiguration;
import org.deltafi.common.types.ValidateActionConfiguration;
import org.springframework.data.annotation.Transient;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="__typename")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TransformActionConfiguration.class, name="TransformActionConfiguration"), @JsonSubTypes.Type(value=LoadActionConfiguration.class, name="LoadActionConfiguration"), @JsonSubTypes.Type(value=DomainActionConfiguration.class, name="DomainActionConfiguration"), @JsonSubTypes.Type(value=EnrichActionConfiguration.class, name="EnrichActionConfiguration"), @JsonSubTypes.Type(value=FormatActionConfiguration.class, name="FormatActionConfiguration"), @JsonSubTypes.Type(value=ValidateActionConfiguration.class, name="ValidateActionConfiguration"), @JsonSubTypes.Type(value=EgressActionConfiguration.class, name="EgressActionConfiguration")})
public abstract class ActionConfiguration
extends DeltaFiConfiguration {
    @JsonIgnore
    @Transient
    protected final ActionType actionType;
    protected final String type;
    @JsonIgnore
    protected Map<String, Object> internalParameters;
    protected Map<String, Object> parameters;

    protected ActionConfiguration(String name, ActionType actionType, String type) {
        super(name);
        this.actionType = actionType;
        this.type = type;
    }

    static boolean equalOrAny(List<String> schemaList, List<String> configList) {
        List<Object> actual;
        List<Object> expected = Objects.isNull(schemaList) ? Collections.emptyList() : schemaList;
        List<Object> list = actual = Objects.isNull(configList) ? Collections.emptyList() : configList;
        if (expected.contains("any")) {
            return true;
        }
        if (expected.isEmpty()) {
            return actual.isEmpty();
        }
        return expected.stream().allMatch(item -> actual.stream().anyMatch(i -> i.equals(item)));
    }

    public ActionInput buildActionInput(String flow, DeltaFile deltaFile, String systemName, String egressFlow, String returnAddress, OffsetDateTime actionCreated) {
        if (Objects.isNull(this.internalParameters)) {
            this.setInternalParameters(Objects.requireNonNullElse(this.parameters, Collections.emptyMap()));
        }
        return ActionInput.builder().queueName(this.type).actionContext(ActionContext.builder().did(deltaFile.getDid()).flow(flow).name(this.name).sourceFilename(deltaFile.getSourceInfo().getFilename()).ingressFlow(deltaFile.getSourceInfo().getFlow()).egressFlow(egressFlow).systemName(systemName).build()).actionParams(this.internalParameters).deltaFileMessages(List.of(deltaFile.forQueue(egressFlow))).returnAddress(returnAddress).actionCreated(actionCreated).build();
    }

    public List<String> validate(ActionDescriptor actionDescriptor) {
        return this.validateType(actionDescriptor);
    }

    public List<String> validateType(ActionDescriptor actionDescriptor) {
        ArrayList<String> errors = new ArrayList<String>();
        if (actionDescriptor.getType() != this.actionType) {
            errors.add("Action: " + this.type + " is not registered as an action of type " + this.actionType);
        }
        return errors;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getInternalParameters() {
        return this.internalParameters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonIgnore
    public void setInternalParameters(Map<String, Object> internalParameters) {
        this.internalParameters = internalParameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionConfiguration)) {
            return false;
        }
        ActionConfiguration other = (ActionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$internalParameters = this.getInternalParameters();
        Map<String, Object> other$internalParameters = other.getInternalParameters();
        if (this$internalParameters == null ? other$internalParameters != null : !((Object)this$internalParameters).equals(other$internalParameters)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ActionConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $internalParameters = this.getInternalParameters();
        result = result * 59 + ($internalParameters == null ? 43 : ((Object)$internalParameters).hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ActionConfiguration(super=" + super.toString() + ", actionType=" + this.getActionType() + ", type=" + this.getType() + ", parameters=" + this.getParameters() + ")";
    }
}

