/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.ActionDescriptor;
import org.deltafi.common.types.ActionType;

public class RequiresDomainsActionConfiguration
extends ActionConfiguration {
    private final List<String> requiresDomains;

    public RequiresDomainsActionConfiguration(String name, ActionType actionType, String type, List<String> requiresDomains) {
        super(name, actionType, type);
        this.requiresDomains = requiresDomains;
    }

    @Override
    public List<String> validate(ActionDescriptor actionDescriptor) {
        List<String> errors = this.validateType(actionDescriptor);
        if (null == actionDescriptor.getRequiresDomains() || actionDescriptor.getRequiresDomains().isEmpty()) {
            errors.add("The action configuration requiresDomains must have one or more values");
        }
        if (!ActionConfiguration.equalOrAny(actionDescriptor.getRequiresDomains(), this.requiresDomains)) {
            errors.add("The action configuration requiresDomains value must be: " + actionDescriptor.getRequiresDomains());
        }
        return errors;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequiresDomainsActionConfiguration)) {
            return false;
        }
        RequiresDomainsActionConfiguration other = (RequiresDomainsActionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$requiresDomains = this.getRequiresDomains();
        List<String> other$requiresDomains = other.getRequiresDomains();
        return !(this$requiresDomains == null ? other$requiresDomains != null : !((Object)this$requiresDomains).equals(other$requiresDomains));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RequiresDomainsActionConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $requiresDomains = this.getRequiresDomains();
        result = result * 59 + ($requiresDomains == null ? 43 : ((Object)$requiresDomains).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RequiresDomainsActionConfiguration(super=" + super.toString() + ", requiresDomains=" + this.getRequiresDomains() + ")";
    }

    public List<String> getRequiresDomains() {
        return this.requiresDomains;
    }
}

