/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class BoundedLineReader
extends BufferedReader {
    static final String LINE_OVERFLOW = "The current line will not fit within the max size limit";
    private static final int UNSET = -2;
    private long maxLineSize;
    private long bytesRead = 0L;
    private int nextChar = -2;

    public BoundedLineReader(Reader in, long maxLineSize) {
        super(in);
        this.setMaxLineSize(maxLineSize);
    }

    public BoundedLineReader(Reader in, int sz, long maxLineSize) {
        super(in, sz);
        this.setMaxLineSize(maxLineSize);
    }

    public long countBytesInNextLine() throws IOException {
        return this.doReadLine(null);
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder[] stringBuilder = new StringBuilder[]{new StringBuilder()};
        this.doReadLine(stringBuilder);
        return stringBuilder[0] != null ? stringBuilder[0].toString() : null;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setMaxLineSize(long maxLineSize) {
        if (maxLineSize < 0L) {
            throw new IllegalArgumentException("maxLineSize cannot be negative");
        }
        this.maxLineSize = maxLineSize;
    }

    private long doReadLine(StringBuilder[] stringBuilder) throws IOException {
        int curChar;
        int n = curChar = this.nextChar != -2 ? this.nextChar : super.read();
        if (curChar == -1) {
            if (stringBuilder != null) {
                stringBuilder[0] = null;
            }
            return -1L;
        }
        if (stringBuilder != null) {
            stringBuilder[0].append((char)curChar);
        }
        long currentLineSize = 0L;
        while (curChar != -1) {
            ++this.bytesRead;
            this.checkSize(++currentLineSize);
            if (curChar == 10) {
                return currentLineSize;
            }
            if (curChar == 13) {
                this.nextChar = super.read();
                if (this.nextChar == 10) {
                    this.checkSize(++currentLineSize);
                    ++this.bytesRead;
                    this.nextChar = -2;
                }
                return currentLineSize;
            }
            curChar = super.read();
            if (stringBuilder == null) continue;
            stringBuilder[0].append((char)curChar);
        }
        return currentLineSize;
    }

    private void checkSize(long currentLineSize) throws IOException {
        if (currentLineSize > this.maxLineSize) {
            throw new IOException(LINE_OVERFLOW);
        }
    }
}

