/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.graphql.dgs;

import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLError;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.codegen.GraphQLQueryRequest;
import java.util.stream.Collectors;

public class GraphQLExecutor {
    public static <T> T executeQuery(GraphQLClient graphQLClient, GraphQLQueryRequest queryRequest, String responseObjectPath, Class<T> responseObjectClass) throws Exception {
        String serializedRequest = queryRequest.serialize();
        GraphQLResponse response = graphQLClient.executeQuery(serializedRequest);
        if (response.hasErrors()) {
            String errorMessage = "Error in DGS submission:\n\nOriginal query:\n" + serializedRequest + "\n\n" + response.getErrors().stream().map(GraphQLError::getMessage).collect(Collectors.joining("\n"));
            throw new Exception(errorMessage);
        }
        return (T)response.extractValueAsObject(responseObjectPath, responseObjectClass);
    }
}

