/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.nifi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV1;
import org.apache.nifi.util.FlowFilePackagerV2;
import org.apache.nifi.util.FlowFilePackagerV3;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;
import org.deltafi.common.nifi.FlowFile;
import org.deltafi.common.nifi.FlowFileUnpackagerV1Unicode;

public class FlowFileUtil {
    public static byte[] packageFlowFileV1(Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        return FlowFileUtil.packageFlowFile((FlowFilePackager)new FlowFilePackagerV1(), attributes, in, fileSize);
    }

    public static byte[] packageFlowFileV2(Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        return FlowFileUtil.packageFlowFile((FlowFilePackager)new FlowFilePackagerV2(), attributes, in, fileSize);
    }

    public static byte[] packageFlowFileV3(Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        return FlowFileUtil.packageFlowFile((FlowFilePackager)new FlowFilePackagerV3(), attributes, in, fileSize);
    }

    private static byte[] packageFlowFile(FlowFilePackager flowFilePackager, Map<String, String> attributes, InputStream in, long fileSize) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            flowFilePackager.packageFlowFile(in, (OutputStream)out, attributes, fileSize);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static FlowFile unpackageFlowFile(String contentType, InputStream in) throws IOException {
        return switch (contentType) {
            case "application/flowfile", "application/flowfile-v1" -> FlowFileUtil.unpackageFlowFile(new FlowFileUnpackagerV1Unicode(), in);
            case "application/flowfile-v2" -> FlowFileUtil.unpackageFlowFile((FlowFileUnpackager)new FlowFileUnpackagerV2(), in);
            case "application/flowfile-v3" -> FlowFileUtil.unpackageFlowFile((FlowFileUnpackager)new FlowFileUnpackagerV3(), in);
            default -> throw new IllegalStateException("Unexpected value: " + contentType);
        };
    }

    private static FlowFile unpackageFlowFile(FlowFileUnpackager flowFileUnpackager, InputStream in) throws IOException {
        try (ByteArrayOutputStream contentOutputStream = new ByteArrayOutputStream(65536);){
            Map attributes = flowFileUnpackager.unpackageFlowFile(in, (OutputStream)contentOutputStream);
            FlowFile flowFile = new FlowFile(attributes, contentOutputStream.toByteArray());
            return flowFile;
        }
    }
}

