/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.deltafi.common.content.Segment;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.SaveManyContent;

public class ContentStorageService {
    public static final String CONTENT_BUCKET = "storage";
    private final ObjectStorageService objectStorageService;

    public InputStream load(Content content) throws ObjectStorageException {
        if (content.getSize() > 0L) {
            if (content.getSegments().size() == 1) {
                return this.objectStorageService.getObject(this.buildObjectReference(content.getSegments().get(0)));
            }
            try {
                return new SequenceInputStream(Collections.enumeration(content.getSegments().stream().map(s -> {
                    try {
                        return this.objectStorageService.getObject(this.buildObjectReference((Segment)s));
                    }
                    catch (ObjectStorageException e) {
                        throw new RuntimeException(e);
                    }
                }).toList()));
            }
            catch (RuntimeException e) {
                throw new ObjectStorageException(e);
            }
        }
        return InputStream.nullInputStream();
    }

    public Content save(String did, byte[] content, String name, String mediaType) throws ObjectStorageException {
        if (content.length == 0) {
            return new Content(name, mediaType, Collections.emptyList());
        }
        return this.save(did, new ByteArrayInputStream(content), name, mediaType);
    }

    public List<Content> saveMany(String did, List<SaveManyContent> saveManyContentList) throws ObjectStorageException {
        ArrayList<Content> updatedContent = new ArrayList<Content>();
        LinkedHashMap<ObjectReference, InputStream> objectsToSave = new LinkedHashMap<ObjectReference, InputStream>();
        for (SaveManyContent entry : saveManyContentList) {
            ArrayList<Segment> segments = new ArrayList<Segment>();
            if (entry.content().length > 0) {
                Segment segment = new Segment(did);
                segment.setSize(entry.content().length);
                segments.add(segment);
                objectsToSave.put(this.buildObjectReference(segment), new ByteArrayInputStream(entry.content()));
            }
            Content content = new Content(entry.name(), entry.mediaType(), segments);
            updatedContent.add(content);
        }
        this.objectStorageService.putObjects(CONTENT_BUCKET, objectsToSave);
        return updatedContent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Content save(String did, InputStream inputStream, String name, String mediaType) throws ObjectStorageException {
        Segment segment = new Segment(did);
        try (PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);){
            int byTe = pushbackInputStream.read();
            if (byTe == -1) {
                Content content = new Content(name, mediaType);
                return content;
            }
            pushbackInputStream.unread(byTe);
            ObjectReference objectReference = this.objectStorageService.putObject(this.buildObjectReference(segment), pushbackInputStream);
            segment.setSize(objectReference.getSize());
            Content content = new Content(name, mediaType, List.of(segment));
            return content;
        }
        catch (IOException e) {
            throw new ObjectStorageException("Error saving content " + segment.objectName(), e);
        }
    }

    public void delete(Content content) {
        if (content.getSegments().size() == 1) {
            this.objectStorageService.removeObject(this.buildObjectReference(content.getSegments().get(0)));
        } else {
            this.deleteAll(content.getSegments());
        }
    }

    public void deleteAll(List<Segment> segments) {
        if (!segments.isEmpty()) {
            this.objectStorageService.removeObjects(CONTENT_BUCKET, segments.stream().map(Segment::objectName).distinct().toList());
        }
    }

    private ObjectReference buildObjectReference(Segment segment) {
        return new ObjectReference(CONTENT_BUCKET, segment.objectName(), segment.getOffset(), segment.getSize());
    }

    public ContentStorageService(ObjectStorageService objectStorageService) {
        this.objectStorageService = objectStorageService;
    }
}

