/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.TimedIngressActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TimedIngressFlowPlan
extends FlowPlan {
    private TimedIngressActionConfiguration timedIngressAction;
    private String targetFlow;
    private Duration interval;

    public TimedIngressFlowPlan(String name, String description) {
        super(name, FlowType.TIMED_INGRESS, description);
    }

    public TimedIngressFlowPlan(String name, String description, TimedIngressActionConfiguration timedIngressActionConfiguration, String targetFlow, Duration interval) {
        super(name, FlowType.TIMED_INGRESS, description);
        this.timedIngressAction = timedIngressActionConfiguration;
        this.targetFlow = targetFlow;
        this.interval = interval;
    }

    @PersistenceCreator
    @JsonCreator
    public TimedIngressFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description) {
        this(name, description);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.timedIngressAction != null) {
            actionConfigurations.add(this.timedIngressAction);
        }
        return actionConfigurations;
    }

    public TimedIngressActionConfiguration getTimedIngressAction() {
        return this.timedIngressAction;
    }

    public String getTargetFlow() {
        return this.targetFlow;
    }

    public Duration getInterval() {
        return this.interval;
    }

    public void setTimedIngressAction(TimedIngressActionConfiguration timedIngressAction) {
        this.timedIngressAction = timedIngressAction;
    }

    public void setTargetFlow(String targetFlow) {
        this.targetFlow = targetFlow;
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }
}

