/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.deltafi.common.types.ActionState;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.Domain;
import org.deltafi.common.types.Enrichment;
import org.jetbrains.annotations.NotNull;

public class Action {
    private String name;
    private ActionType type;
    private String flow;
    private ActionState state;
    private OffsetDateTime created;
    private OffsetDateTime queued;
    private OffsetDateTime start;
    private OffsetDateTime stop;
    private OffsetDateTime modified;
    private String errorCause;
    private String errorContext;
    private String filteredCause;
    private String filteredContext;
    private int attempt;
    private List<Content> content;
    private Map<String, String> metadata;
    private List<String> deleteMetadataKeys;
    private List<Domain> domains;
    private List<Enrichment> enrichments;
    private static List<ActionType> DATA_AMENDED_TYPES = List.of(ActionType.INGRESS, ActionType.TRANSFORM, ActionType.LOAD);

    public Action(Action other) {
        this.name = other.name;
        this.type = other.type;
        this.flow = other.flow;
        this.state = other.state;
        this.created = other.created;
        this.queued = other.queued;
        this.start = other.start;
        this.stop = other.stop;
        this.modified = other.modified;
        this.errorCause = other.errorCause;
        this.errorContext = other.errorContext;
        this.filteredCause = other.filteredCause;
        this.filteredContext = other.filteredContext;
        this.attempt = other.attempt;
        this.content = other.content == null ? null : other.content.stream().map(Content::new).toList();
        this.metadata = other.metadata == null ? null : new HashMap<String, String>(other.metadata);
        this.deleteMetadataKeys = other.deleteMetadataKeys == null ? null : new ArrayList<String>(other.deleteMetadataKeys);
        this.domains = other.domains == null ? null : other.domains.stream().map(Domain::new).toList();
        this.enrichments = other.enrichments == null ? null : other.enrichments.stream().map(Enrichment::new).toList();
    }

    public List<Content> getContent() {
        return this.content == null ? Collections.emptyList() : this.content;
    }

    public Map<String, String> getMetadata() {
        return this.metadata == null ? Collections.emptyMap() : this.metadata;
    }

    public List<String> getDeleteMetadataKeys() {
        return this.deleteMetadataKeys == null ? Collections.emptyList() : this.deleteMetadataKeys;
    }

    public List<Domain> getDomains() {
        return this.domains == null ? Collections.emptyList() : this.domains;
    }

    public List<Enrichment> getEnrichments() {
        return this.enrichments == null ? Collections.emptyList() : this.enrichments;
    }

    boolean queued() {
        return this.state == ActionState.QUEUED || this.state == ActionState.COLD_QUEUED;
    }

    boolean terminal() {
        return !this.queued() && this.state != ActionState.COLLECTING;
    }

    boolean complete() {
        return this.state == ActionState.COMPLETE;
    }

    public boolean amendedData() {
        return (this.state == ActionState.COMPLETE || this.state == ActionState.RETRIED) && DATA_AMENDED_TYPES.contains((Object)this.type);
    }

    public boolean afterFormat() {
        return this.type == ActionType.VALIDATE || this.type == ActionType.EGRESS;
    }

    public void addDomain(@NotNull String domainKey, String domainValue, @NotNull String mediaType) {
        Optional<Domain> domain;
        if (this.domains == null) {
            this.domains = new ArrayList<Domain>();
        }
        if ((domain = this.getDomains().stream().filter(d -> d.getName().equals(domainKey)).findFirst()).isPresent()) {
            domain.get().setValue(domainValue);
        } else {
            this.getDomains().add(new Domain(domainKey, domainValue, mediaType));
        }
    }

    public void addEnrichment(@NotNull String enrichmentKey, String enrichmentValue) {
        this.addEnrichment(enrichmentKey, enrichmentValue, "application/octet-stream");
    }

    public void addEnrichment(@NotNull String enrichmentKey, String enrichmentValue, @NotNull String mediaType) {
        Optional<Enrichment> enrichment;
        if (this.enrichments == null) {
            this.enrichments = new ArrayList<Enrichment>();
        }
        if ((enrichment = this.getEnrichments().stream().filter(d -> d.getName().equals(enrichmentKey)).findFirst()).isPresent()) {
            enrichment.get().setValue(enrichmentValue);
        } else {
            this.getEnrichments().add(new Enrichment(enrichmentKey, enrichmentValue, mediaType));
        }
    }

    private static ActionType $default$type() {
        return ActionType.UNKNOWN;
    }

    private static int $default$attempt() {
        return 1;
    }

    public static ActionBuilder builder() {
        return new ActionBuilder();
    }

    public String getName() {
        return this.name;
    }

    public ActionType getType() {
        return this.type;
    }

    public String getFlow() {
        return this.flow;
    }

    public ActionState getState() {
        return this.state;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OffsetDateTime getQueued() {
        return this.queued;
    }

    public OffsetDateTime getStart() {
        return this.start;
    }

    public OffsetDateTime getStop() {
        return this.stop;
    }

    public OffsetDateTime getModified() {
        return this.modified;
    }

    public String getErrorCause() {
        return this.errorCause;
    }

    public String getErrorContext() {
        return this.errorContext;
    }

    public String getFilteredCause() {
        return this.filteredCause;
    }

    public String getFilteredContext() {
        return this.filteredContext;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setState(ActionState state) {
        this.state = state;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public void setQueued(OffsetDateTime queued) {
        this.queued = queued;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public void setStop(OffsetDateTime stop) {
        this.stop = stop;
    }

    public void setModified(OffsetDateTime modified) {
        this.modified = modified;
    }

    public void setErrorCause(String errorCause) {
        this.errorCause = errorCause;
    }

    public void setErrorContext(String errorContext) {
        this.errorContext = errorContext;
    }

    public void setFilteredCause(String filteredCause) {
        this.filteredCause = filteredCause;
    }

    public void setFilteredContext(String filteredContext) {
        this.filteredContext = filteredContext;
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public void setContent(List<Content> content) {
        this.content = content;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setDeleteMetadataKeys(List<String> deleteMetadataKeys) {
        this.deleteMetadataKeys = deleteMetadataKeys;
    }

    public void setDomains(List<Domain> domains) {
        this.domains = domains;
    }

    public void setEnrichments(List<Enrichment> enrichments) {
        this.enrichments = enrichments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAttempt() != other.getAttempt()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ActionType this$type = this.getType();
        ActionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        ActionState this$state = this.getState();
        ActionState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        OffsetDateTime this$queued = this.getQueued();
        OffsetDateTime other$queued = other.getQueued();
        if (this$queued == null ? other$queued != null : !((Object)this$queued).equals(other$queued)) {
            return false;
        }
        OffsetDateTime this$start = this.getStart();
        OffsetDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        OffsetDateTime this$stop = this.getStop();
        OffsetDateTime other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        OffsetDateTime this$modified = this.getModified();
        OffsetDateTime other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        String this$errorCause = this.getErrorCause();
        String other$errorCause = other.getErrorCause();
        if (this$errorCause == null ? other$errorCause != null : !this$errorCause.equals(other$errorCause)) {
            return false;
        }
        String this$errorContext = this.getErrorContext();
        String other$errorContext = other.getErrorContext();
        if (this$errorContext == null ? other$errorContext != null : !this$errorContext.equals(other$errorContext)) {
            return false;
        }
        String this$filteredCause = this.getFilteredCause();
        String other$filteredCause = other.getFilteredCause();
        if (this$filteredCause == null ? other$filteredCause != null : !this$filteredCause.equals(other$filteredCause)) {
            return false;
        }
        String this$filteredContext = this.getFilteredContext();
        String other$filteredContext = other.getFilteredContext();
        if (this$filteredContext == null ? other$filteredContext != null : !this$filteredContext.equals(other$filteredContext)) {
            return false;
        }
        List<Content> this$content = this.getContent();
        List<Content> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<String> this$deleteMetadataKeys = this.getDeleteMetadataKeys();
        List<String> other$deleteMetadataKeys = other.getDeleteMetadataKeys();
        if (this$deleteMetadataKeys == null ? other$deleteMetadataKeys != null : !((Object)this$deleteMetadataKeys).equals(other$deleteMetadataKeys)) {
            return false;
        }
        List<Domain> this$domains = this.getDomains();
        List<Domain> other$domains = other.getDomains();
        if (this$domains == null ? other$domains != null : !((Object)this$domains).equals(other$domains)) {
            return false;
        }
        List<Enrichment> this$enrichments = this.getEnrichments();
        List<Enrichment> other$enrichments = other.getEnrichments();
        return !(this$enrichments == null ? other$enrichments != null : !((Object)this$enrichments).equals(other$enrichments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAttempt();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ActionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        ActionState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        OffsetDateTime $queued = this.getQueued();
        result = result * 59 + ($queued == null ? 43 : ((Object)$queued).hashCode());
        OffsetDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        OffsetDateTime $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        OffsetDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        String $errorCause = this.getErrorCause();
        result = result * 59 + ($errorCause == null ? 43 : $errorCause.hashCode());
        String $errorContext = this.getErrorContext();
        result = result * 59 + ($errorContext == null ? 43 : $errorContext.hashCode());
        String $filteredCause = this.getFilteredCause();
        result = result * 59 + ($filteredCause == null ? 43 : $filteredCause.hashCode());
        String $filteredContext = this.getFilteredContext();
        result = result * 59 + ($filteredContext == null ? 43 : $filteredContext.hashCode());
        List<Content> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<String> $deleteMetadataKeys = this.getDeleteMetadataKeys();
        result = result * 59 + ($deleteMetadataKeys == null ? 43 : ((Object)$deleteMetadataKeys).hashCode());
        List<Domain> $domains = this.getDomains();
        result = result * 59 + ($domains == null ? 43 : ((Object)$domains).hashCode());
        List<Enrichment> $enrichments = this.getEnrichments();
        result = result * 59 + ($enrichments == null ? 43 : ((Object)$enrichments).hashCode());
        return result;
    }

    public String toString() {
        return "Action(name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", flow=" + this.getFlow() + ", state=" + String.valueOf((Object)this.getState()) + ", created=" + String.valueOf(this.getCreated()) + ", queued=" + String.valueOf(this.getQueued()) + ", start=" + String.valueOf(this.getStart()) + ", stop=" + String.valueOf(this.getStop()) + ", modified=" + String.valueOf(this.getModified()) + ", errorCause=" + this.getErrorCause() + ", errorContext=" + this.getErrorContext() + ", filteredCause=" + this.getFilteredCause() + ", filteredContext=" + this.getFilteredContext() + ", attempt=" + this.getAttempt() + ", content=" + String.valueOf(this.getContent()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", deleteMetadataKeys=" + String.valueOf(this.getDeleteMetadataKeys()) + ", domains=" + String.valueOf(this.getDomains()) + ", enrichments=" + String.valueOf(this.getEnrichments()) + ")";
    }

    public Action() {
        this.type = Action.$default$type();
        this.attempt = Action.$default$attempt();
    }

    public Action(String name, ActionType type, String flow, ActionState state, OffsetDateTime created, OffsetDateTime queued, OffsetDateTime start, OffsetDateTime stop, OffsetDateTime modified, String errorCause, String errorContext, String filteredCause, String filteredContext, int attempt, List<Content> content, Map<String, String> metadata, List<String> deleteMetadataKeys, List<Domain> domains, List<Enrichment> enrichments) {
        this.name = name;
        this.type = type;
        this.flow = flow;
        this.state = state;
        this.created = created;
        this.queued = queued;
        this.start = start;
        this.stop = stop;
        this.modified = modified;
        this.errorCause = errorCause;
        this.errorContext = errorContext;
        this.filteredCause = filteredCause;
        this.filteredContext = filteredContext;
        this.attempt = attempt;
        this.content = content;
        this.metadata = metadata;
        this.deleteMetadataKeys = deleteMetadataKeys;
        this.domains = domains;
        this.enrichments = enrichments;
    }

    public static class ActionBuilder {
        private String name;
        private boolean type$set;
        private ActionType type$value;
        private String flow;
        private ActionState state;
        private OffsetDateTime created;
        private OffsetDateTime queued;
        private OffsetDateTime start;
        private OffsetDateTime stop;
        private OffsetDateTime modified;
        private String errorCause;
        private String errorContext;
        private String filteredCause;
        private String filteredContext;
        private boolean attempt$set;
        private int attempt$value;
        private List<Content> content;
        private Map<String, String> metadata;
        private List<String> deleteMetadataKeys;
        private List<Domain> domains;
        private List<Enrichment> enrichments;

        ActionBuilder() {
        }

        public ActionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ActionBuilder type(ActionType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public ActionBuilder flow(String flow) {
            this.flow = flow;
            return this;
        }

        public ActionBuilder state(ActionState state) {
            this.state = state;
            return this;
        }

        public ActionBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public ActionBuilder queued(OffsetDateTime queued) {
            this.queued = queued;
            return this;
        }

        public ActionBuilder start(OffsetDateTime start) {
            this.start = start;
            return this;
        }

        public ActionBuilder stop(OffsetDateTime stop) {
            this.stop = stop;
            return this;
        }

        public ActionBuilder modified(OffsetDateTime modified) {
            this.modified = modified;
            return this;
        }

        public ActionBuilder errorCause(String errorCause) {
            this.errorCause = errorCause;
            return this;
        }

        public ActionBuilder errorContext(String errorContext) {
            this.errorContext = errorContext;
            return this;
        }

        public ActionBuilder filteredCause(String filteredCause) {
            this.filteredCause = filteredCause;
            return this;
        }

        public ActionBuilder filteredContext(String filteredContext) {
            this.filteredContext = filteredContext;
            return this;
        }

        public ActionBuilder attempt(int attempt) {
            this.attempt$value = attempt;
            this.attempt$set = true;
            return this;
        }

        public ActionBuilder content(List<Content> content) {
            this.content = content;
            return this;
        }

        public ActionBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ActionBuilder deleteMetadataKeys(List<String> deleteMetadataKeys) {
            this.deleteMetadataKeys = deleteMetadataKeys;
            return this;
        }

        public ActionBuilder domains(List<Domain> domains) {
            this.domains = domains;
            return this;
        }

        public ActionBuilder enrichments(List<Enrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }

        public Action build() {
            ActionType type$value = this.type$value;
            if (!this.type$set) {
                type$value = Action.$default$type();
            }
            int attempt$value = this.attempt$value;
            if (!this.attempt$set) {
                attempt$value = Action.$default$attempt();
            }
            return new Action(this.name, type$value, this.flow, this.state, this.created, this.queued, this.start, this.stop, this.modified, this.errorCause, this.errorContext, this.filteredCause, this.filteredContext, attempt$value, this.content, this.metadata, this.deleteMetadataKeys, this.domains, this.enrichments);
        }

        public String toString() {
            return "Action.ActionBuilder(name=" + this.name + ", type$value=" + String.valueOf((Object)this.type$value) + ", flow=" + this.flow + ", state=" + String.valueOf((Object)this.state) + ", created=" + String.valueOf(this.created) + ", queued=" + String.valueOf(this.queued) + ", start=" + String.valueOf(this.start) + ", stop=" + String.valueOf(this.stop) + ", modified=" + String.valueOf(this.modified) + ", errorCause=" + this.errorCause + ", errorContext=" + this.errorContext + ", filteredCause=" + this.filteredCause + ", filteredContext=" + this.filteredContext + ", attempt$value=" + this.attempt$value + ", content=" + String.valueOf(this.content) + ", metadata=" + String.valueOf(this.metadata) + ", deleteMetadataKeys=" + String.valueOf(this.deleteMetadataKeys) + ", domains=" + String.valueOf(this.domains) + ", enrichments=" + String.valueOf(this.enrichments) + ")";
        }
    }
}

