/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.PublishRules;
import org.deltafi.common.types.Publisher;
import org.deltafi.common.types.TimedIngressActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TimedIngressFlowPlan
extends FlowPlan
implements Publisher {
    private TimedIngressActionConfiguration timedIngressAction;
    private String targetFlow;
    private PublishRules publishRules;
    private String cronSchedule;

    @PersistenceCreator
    @JsonCreator
    public TimedIngressFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="timedIngressAction", required=true) TimedIngressActionConfiguration timedIngressAction, @JsonProperty(value="targetFlow") String targetFlow, @JsonProperty(value="publishRules") PublishRules publishRules, @JsonProperty(value="cronSchedule", required=true) String cronSchedule) {
        super(name, FlowType.TIMED_INGRESS, description);
        this.timedIngressAction = timedIngressAction;
        this.targetFlow = targetFlow;
        this.publishRules = publishRules;
        this.cronSchedule = cronSchedule;
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.timedIngressAction != null) {
            actionConfigurations.add(this.timedIngressAction);
        }
        return actionConfigurations;
    }

    @Override
    public PublishRules publishRules() {
        return this.publishRules;
    }

    public TimedIngressActionConfiguration getTimedIngressAction() {
        return this.timedIngressAction;
    }

    public String getTargetFlow() {
        return this.targetFlow;
    }

    public PublishRules getPublishRules() {
        return this.publishRules;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public void setTimedIngressAction(TimedIngressActionConfiguration timedIngressAction) {
        this.timedIngressAction = timedIngressAction;
    }

    public void setTargetFlow(String targetFlow) {
        this.targetFlow = targetFlow;
    }

    public void setPublishRules(PublishRules publishRules) {
        this.publishRules = publishRules;
    }

    public void setCronSchedule(String cronSchedule) {
        this.cronSchedule = cronSchedule;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimedIngressFlowPlan)) {
            return false;
        }
        TimedIngressFlowPlan other = (TimedIngressFlowPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimedIngressActionConfiguration this$timedIngressAction = this.getTimedIngressAction();
        TimedIngressActionConfiguration other$timedIngressAction = other.getTimedIngressAction();
        if (this$timedIngressAction == null ? other$timedIngressAction != null : !((Object)this$timedIngressAction).equals(other$timedIngressAction)) {
            return false;
        }
        String this$targetFlow = this.getTargetFlow();
        String other$targetFlow = other.getTargetFlow();
        if (this$targetFlow == null ? other$targetFlow != null : !this$targetFlow.equals(other$targetFlow)) {
            return false;
        }
        PublishRules this$publishRules = this.getPublishRules();
        PublishRules other$publishRules = other.getPublishRules();
        if (this$publishRules == null ? other$publishRules != null : !((Object)this$publishRules).equals(other$publishRules)) {
            return false;
        }
        String this$cronSchedule = this.getCronSchedule();
        String other$cronSchedule = other.getCronSchedule();
        return !(this$cronSchedule == null ? other$cronSchedule != null : !this$cronSchedule.equals(other$cronSchedule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimedIngressFlowPlan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TimedIngressActionConfiguration $timedIngressAction = this.getTimedIngressAction();
        result = result * 59 + ($timedIngressAction == null ? 43 : ((Object)$timedIngressAction).hashCode());
        String $targetFlow = this.getTargetFlow();
        result = result * 59 + ($targetFlow == null ? 43 : $targetFlow.hashCode());
        PublishRules $publishRules = this.getPublishRules();
        result = result * 59 + ($publishRules == null ? 43 : ((Object)$publishRules).hashCode());
        String $cronSchedule = this.getCronSchedule();
        result = result * 59 + ($cronSchedule == null ? 43 : $cronSchedule.hashCode());
        return result;
    }
}

