/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.deltafi.common.types.DefaultBehavior;
import org.deltafi.common.types.DefaultRule;
import org.deltafi.common.types.MatchingPolicy;
import org.deltafi.common.types.Rule;

public class PublishRules {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule());
    private static final DefaultRule ERROR_RULE = new DefaultRule(DefaultBehavior.ERROR);
    private MatchingPolicy matchingPolicy;
    private DefaultRule defaultRule;
    private List<Rule> rules;

    public void setMatchingPolicy(MatchingPolicy matchingPolicy) {
        this.matchingPolicy = Objects.requireNonNullElse(matchingPolicy, MatchingPolicy.ALL_MATCHING);
    }

    public void setDefaultRule(DefaultRule defaultRule) {
        this.defaultRule = Objects.requireNonNullElse(defaultRule, ERROR_RULE);
    }

    public void setRules(List<Rule> rules) {
        this.rules = Objects.requireNonNullElseGet(rules, ArrayList::new);
    }

    public String toString() {
        try {
            return YAML_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return this.simpleToString();
        }
    }

    String simpleToString() {
        return "PublishRules{matchingPolicy=" + String.valueOf((Object)this.matchingPolicy) + ", defaultRule=" + String.valueOf(this.defaultRule) + ", rules=" + String.valueOf(this.rules) + "}";
    }

    public MatchingPolicy getMatchingPolicy() {
        return this.matchingPolicy;
    }

    public DefaultRule getDefaultRule() {
        return this.defaultRule;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublishRules)) {
            return false;
        }
        PublishRules other = (PublishRules)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MatchingPolicy this$matchingPolicy = this.getMatchingPolicy();
        MatchingPolicy other$matchingPolicy = other.getMatchingPolicy();
        if (this$matchingPolicy == null ? other$matchingPolicy != null : !((Object)((Object)this$matchingPolicy)).equals((Object)other$matchingPolicy)) {
            return false;
        }
        DefaultRule this$defaultRule = this.getDefaultRule();
        DefaultRule other$defaultRule = other.getDefaultRule();
        if (this$defaultRule == null ? other$defaultRule != null : !((Object)this$defaultRule).equals(other$defaultRule)) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublishRules;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MatchingPolicy $matchingPolicy = this.getMatchingPolicy();
        result = result * 59 + ($matchingPolicy == null ? 43 : ((Object)((Object)$matchingPolicy)).hashCode());
        DefaultRule $defaultRule = this.getDefaultRule();
        result = result * 59 + ($defaultRule == null ? 43 : ((Object)$defaultRule).hashCode());
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }
}

