/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.io;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.deltafi.common.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterPipedInputStream
extends PipedInputStream {
    private static final Logger log = LoggerFactory.getLogger(WriterPipedInputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private final PipedOutputStream pipedOutputStream = new PipedOutputStream(this);
    private Future<?> future;

    public WriterPipedInputStream() throws IOException {
        this(524288);
    }

    public WriterPipedInputStream(int bufferSize) throws IOException {
        super(bufferSize);
    }

    public void runPipeWriter(Writer writer, ExecutorService executorService) {
        this.future = executorService.submit(() -> {
            block8: {
                try (PipedOutputStream pipedOutputStream = this.pipedOutputStream;){
                    writer.write(this.pipedOutputStream);
                }
                catch (IOException e) {
                    if (e.getMessage().equals("Pipe closed")) break block8;
                    log.warn("Write failed", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

