/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.deltafi.common.types.ActionEventType;
import org.deltafi.common.types.ErrorEvent;
import org.deltafi.common.types.FilterEvent;
import org.deltafi.common.types.IngressEvent;
import org.deltafi.common.types.Metric;
import org.deltafi.common.types.TransformEvent;

public class ActionEvent {
    private String did;
    private String flow;
    private String action;
    private OffsetDateTime start;
    private OffsetDateTime stop;
    private ActionEventType type;
    private List<TransformEvent> transform;
    private ErrorEvent error;
    private FilterEvent filter;
    private List<Metric> metrics;
    private IngressEvent ingress;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);

    public String validate() {
        if (StringUtils.isEmpty((CharSequence)this.did)) {
            return "Missing did";
        }
        if (StringUtils.isEmpty((CharSequence)this.flow)) {
            return "Missing flow";
        }
        if (StringUtils.isEmpty((CharSequence)this.action)) {
            return "Missing action";
        }
        if (this.start == null) {
            return "Missing start";
        }
        if (this.stop == null) {
            return "Missing stop";
        }
        if (!this.typeValid()) {
            return "Action event type does not match the populated object";
        }
        return null;
    }

    private boolean typeValid() {
        return switch (this.type) {
            case ActionEventType.TRANSFORM -> {
                if (this.transform != null && !this.transform.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case ActionEventType.ERROR -> {
                if (this.error != null) {
                    yield true;
                }
                yield false;
            }
            case ActionEventType.FILTER -> {
                if (this.filter != null) {
                    yield true;
                }
                yield false;
            }
            case ActionEventType.EGRESS -> true;
            case ActionEventType.INGRESS -> {
                if (this.ingress != null && this.ingress.getIngressItems() != null) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ActionEventBuilder builder() {
        return new ActionEventBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getAction() {
        return this.action;
    }

    public OffsetDateTime getStart() {
        return this.start;
    }

    public OffsetDateTime getStop() {
        return this.stop;
    }

    public ActionEventType getType() {
        return this.type;
    }

    public List<TransformEvent> getTransform() {
        return this.transform;
    }

    public ErrorEvent getError() {
        return this.error;
    }

    public FilterEvent getFilter() {
        return this.filter;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public IngressEvent getIngress() {
        return this.ingress;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public void setStop(OffsetDateTime stop) {
        this.stop = stop;
    }

    public void setType(ActionEventType type) {
        this.type = type;
    }

    public void setTransform(List<TransformEvent> transform) {
        this.transform = transform;
    }

    public void setError(ErrorEvent error) {
        this.error = error;
    }

    public void setFilter(FilterEvent filter) {
        this.filter = filter;
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public void setIngress(IngressEvent ingress) {
        this.ingress = ingress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionEvent)) {
            return false;
        }
        ActionEvent other = (ActionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        OffsetDateTime this$start = this.getStart();
        OffsetDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        OffsetDateTime this$stop = this.getStop();
        OffsetDateTime other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        ActionEventType this$type = this.getType();
        ActionEventType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<TransformEvent> this$transform = this.getTransform();
        List<TransformEvent> other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !((Object)this$transform).equals(other$transform)) {
            return false;
        }
        ErrorEvent this$error = this.getError();
        ErrorEvent other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        FilterEvent this$filter = this.getFilter();
        FilterEvent other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        List<Metric> this$metrics = this.getMetrics();
        List<Metric> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        IngressEvent this$ingress = this.getIngress();
        IngressEvent other$ingress = other.getIngress();
        return !(this$ingress == null ? other$ingress != null : !((Object)this$ingress).equals(other$ingress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        OffsetDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        OffsetDateTime $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        ActionEventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<TransformEvent> $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : ((Object)$transform).hashCode());
        ErrorEvent $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        FilterEvent $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        List<Metric> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        IngressEvent $ingress = this.getIngress();
        result = result * 59 + ($ingress == null ? 43 : ((Object)$ingress).hashCode());
        return result;
    }

    public ActionEvent() {
    }

    public ActionEvent(String did, String flow, String action, OffsetDateTime start, OffsetDateTime stop, ActionEventType type, List<TransformEvent> transform, ErrorEvent error, FilterEvent filter, List<Metric> metrics, IngressEvent ingress) {
        this.did = did;
        this.flow = flow;
        this.action = action;
        this.start = start;
        this.stop = stop;
        this.type = type;
        this.transform = transform;
        this.error = error;
        this.filter = filter;
        this.metrics = metrics;
        this.ingress = ingress;
    }

    public static class ActionEventBuilder {
        private String did;
        private String flow;
        private String action;
        private OffsetDateTime start;
        private OffsetDateTime stop;
        private ActionEventType type;
        private List<TransformEvent> transform;
        private ErrorEvent error;
        private FilterEvent filter;
        private List<Metric> metrics;
        private IngressEvent ingress;

        ActionEventBuilder() {
        }

        public ActionEventBuilder did(String did) {
            this.did = did;
            return this;
        }

        public ActionEventBuilder flow(String flow) {
            this.flow = flow;
            return this;
        }

        public ActionEventBuilder action(String action) {
            this.action = action;
            return this;
        }

        public ActionEventBuilder start(OffsetDateTime start) {
            this.start = start;
            return this;
        }

        public ActionEventBuilder stop(OffsetDateTime stop) {
            this.stop = stop;
            return this;
        }

        public ActionEventBuilder type(ActionEventType type) {
            this.type = type;
            return this;
        }

        public ActionEventBuilder transform(List<TransformEvent> transform) {
            this.transform = transform;
            return this;
        }

        public ActionEventBuilder error(ErrorEvent error) {
            this.error = error;
            return this;
        }

        public ActionEventBuilder filter(FilterEvent filter) {
            this.filter = filter;
            return this;
        }

        public ActionEventBuilder metrics(List<Metric> metrics) {
            this.metrics = metrics;
            return this;
        }

        public ActionEventBuilder ingress(IngressEvent ingress) {
            this.ingress = ingress;
            return this;
        }

        public ActionEvent build() {
            return new ActionEvent(this.did, this.flow, this.action, this.start, this.stop, this.type, this.transform, this.error, this.filter, this.metrics, this.ingress);
        }

        public String toString() {
            return "ActionEvent.ActionEventBuilder(did=" + this.did + ", flow=" + this.flow + ", action=" + this.action + ", start=" + this.start + ", stop=" + this.stop + ", type=" + this.type + ", transform=" + this.transform + ", error=" + this.error + ", filter=" + this.filter + ", metrics=" + this.metrics + ", ingress=" + this.ingress + ")";
        }
    }
}

