/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.nifi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.deltafi.common.nifi.FlowFileTwoStepUnpackager;

public class FlowFileTwoStepUnpackagerV1
implements FlowFileTwoStepUnpackager {
    private int flowFilesRead = 0;
    private TarArchiveInputStream tarIn;
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<entry key=\"([^\"]+)\">([^<]+)</entry>", 8);

    @Override
    public Map<String, String> unpackageAttributes(InputStream in) throws IOException {
        this.tarIn = new TarArchiveInputStream(in);
        TarArchiveEntry attribEntry = this.tarIn.getNextTarEntry();
        if (attribEntry == null || !attribEntry.getName().equals("flowfile.attributes")) {
            this.tarIn.close();
            this.tarIn = null;
            throw new IOException("Expected two tar entries: flowfile.content and flowfile.attributes");
        }
        return this.readAttributes(this.tarIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpackageContent(InputStream in, OutputStream out) throws IOException {
        if (this.tarIn == null) {
            throw new IOException("Call unpackageAttributes first");
        }
        ++this.flowFilesRead;
        try {
            int bytesRead;
            TarArchiveEntry contentEntry = this.tarIn.getNextTarEntry();
            if (contentEntry == null || !contentEntry.getName().equals("flowfile.content")) {
                throw new IOException("Expected two tar entries: flowfile.content and flowfile.attributes");
            }
            byte[] buffer = new byte[524288];
            while ((bytesRead = this.tarIn.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                out.flush();
            }
        }
        finally {
            this.tarIn.close();
        }
    }

    private Map<String, String> readAttributes(TarArchiveInputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream));
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher entryMatcher = ENTRY_PATTERN.matcher(reader.lines().collect(Collectors.joining("\n")));
        while (entryMatcher.find()) {
            attributes.put(StringEscapeUtils.unescapeXml((String)entryMatcher.group(1)), StringEscapeUtils.unescapeXml((String)entryMatcher.group(2)));
        }
        return attributes;
    }

    @Override
    public boolean hasMoreData() {
        return this.flowFilesRead == 0;
    }
}

