/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.EgressActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.Rule;
import org.deltafi.common.types.Subscriber;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class EgressFlowPlan
extends FlowPlan
implements Subscriber {
    private final EgressActionConfiguration egressAction;
    private Set<Rule> subscriptions;

    public EgressFlowPlan(String name, String description, EgressActionConfiguration egressAction) {
        super(name, FlowType.EGRESS, description);
        this.egressAction = egressAction;
    }

    @PersistenceCreator
    @JsonCreator
    public EgressFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="egressAction", required=true) EgressActionConfiguration egressAction) {
        this(name, description, egressAction);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.egressAction != null) {
            actionConfigurations.add(this.egressAction);
        }
        return actionConfigurations;
    }

    @Override
    public Set<Rule> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public FlowType flowType() {
        return FlowType.EGRESS;
    }

    public EgressActionConfiguration getEgressAction() {
        return this.egressAction;
    }

    public Set<Rule> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Set<Rule> subscriptions) {
        this.subscriptions = subscriptions;
    }
}

