/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.PublishRules;
import org.deltafi.common.types.Publisher;
import org.deltafi.common.types.Rule;
import org.deltafi.common.types.Subscriber;
import org.deltafi.common.types.TransformActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TransformFlowPlan
extends FlowPlan
implements Publisher,
Subscriber {
    private List<TransformActionConfiguration> transformActions;
    private Set<Rule> subscriptions;
    private PublishRules publishRules;

    public TransformFlowPlan(String name, String description) {
        super(name, FlowType.TRANSFORM, description);
    }

    @PersistenceCreator
    @JsonCreator
    public TransformFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description) {
        this(name, description);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.transformActions != null) {
            actionConfigurations.addAll(this.transformActions);
        }
        return actionConfigurations;
    }

    @Override
    public Set<Rule> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public PublishRules publishRules() {
        return this.publishRules;
    }

    @Override
    public FlowType flowType() {
        return FlowType.TRANSFORM;
    }

    public List<TransformActionConfiguration> getTransformActions() {
        return this.transformActions;
    }

    public Set<Rule> getSubscriptions() {
        return this.subscriptions;
    }

    public PublishRules getPublishRules() {
        return this.publishRules;
    }

    public void setTransformActions(List<TransformActionConfiguration> transformActions) {
        this.transformActions = transformActions;
    }

    public void setSubscriptions(Set<Rule> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void setPublishRules(PublishRules publishRules) {
        this.publishRules = publishRules;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformFlowPlan)) {
            return false;
        }
        TransformFlowPlan other = (TransformFlowPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<TransformActionConfiguration> this$transformActions = this.getTransformActions();
        List<TransformActionConfiguration> other$transformActions = other.getTransformActions();
        if (this$transformActions == null ? other$transformActions != null : !((Object)this$transformActions).equals(other$transformActions)) {
            return false;
        }
        Set<Rule> this$subscriptions = this.getSubscriptions();
        Set<Rule> other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        PublishRules this$publishRules = this.getPublishRules();
        PublishRules other$publishRules = other.getPublishRules();
        return !(this$publishRules == null ? other$publishRules != null : !((Object)this$publishRules).equals(other$publishRules));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TransformFlowPlan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<TransformActionConfiguration> $transformActions = this.getTransformActions();
        result = result * 59 + ($transformActions == null ? 43 : ((Object)$transformActions).hashCode());
        Set<Rule> $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        PublishRules $publishRules = this.getPublishRules();
        result = result * 59 + ($publishRules == null ? 43 : ((Object)$publishRules).hashCode());
        return result;
    }
}

