/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.graphql.dgs;

import com.netflix.graphql.dgs.client.GraphQLClient;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLClientFactory {
    private static final Logger log = LoggerFactory.getLogger(GraphQLClientFactory.class);
    private final HttpClient httpClient;

    public GraphQLClient build(String coreUrl, String ... headers) {
        return GraphQLClient.createCustom((String)coreUrl, (url, defaultHeaders, body) -> {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body));
            if (headers.length > 0) {
                requestBuilder.headers(headers);
            }
            try {
                HttpResponse<String> response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                return new com.netflix.graphql.dgs.client.HttpResponse(response.statusCode(), response.body());
            }
            catch (IOException ioException) {
                throw new RuntimeException("Failed to make graphQL request", ioException);
            }
            catch (InterruptedException interruptedException) {
                log.error("Could not complete graphQL request", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
                throw new RuntimeException("GraphQL Request was interrupted");
            }
        });
    }

    public GraphQLClientFactory(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

