/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.rules;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.DeltaFileFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class RuleEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RuleEvaluator.class);
    private static final ImmutableDeltaFileFlow EXAMPLE_DELTA_FILE = new ImmutableDeltaFileFlow(Map.of("a", "b"), List.of(new Content("", "")));
    private final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>();

    public void validateCondition(String condition) throws IllegalArgumentException {
        try {
            this.doEvaluateCondition(condition, EXAMPLE_DELTA_FILE);
        }
        catch (Exception e) {
            String exceptionMessage = e.getMessage();
            String message = exceptionMessage != null ? "invalid condition `" + condition + "`: " + exceptionMessage : "invalid condition `" + condition + "`";
            throw new IllegalArgumentException(message);
        }
    }

    public boolean evaluateCondition(String condition, DeltaFileFlow deltaFileFlow) {
        try {
            return this.doEvaluateCondition(condition, new ImmutableDeltaFileFlow(deltaFileFlow));
        }
        catch (Exception e) {
            log.error("Failed to evaluate condition", (Throwable)e);
            return false;
        }
    }

    boolean doEvaluateCondition(String condition, ImmutableDeltaFileFlow deltaFileFlow) {
        if (condition == null) {
            return true;
        }
        SimpleEvaluationContext spelContext = SimpleEvaluationContext.forReadOnlyDataBinding().withRootObject((Object)deltaFileFlow).withInstanceMethods().build();
        Expression expression = this.expressionCache.computeIfAbsent(condition, this::newExpression);
        Boolean output = (Boolean)expression.getValue((EvaluationContext)spelContext, Boolean.class);
        return Boolean.TRUE.equals(output);
    }

    private Expression newExpression(String condition) {
        SpelExpressionParser parser = new SpelExpressionParser();
        return parser.parseExpression(condition);
    }

    public record ImmutableDeltaFileFlow(Map<String, String> metadata, List<Content> content) {
        public ImmutableDeltaFileFlow(DeltaFileFlow deltaFileFlow) {
            this(deltaFileFlow.getImmutableMetadata(), deltaFileFlow.getImmutableContent());
        }

        public boolean hasMediaType(String mediaType) {
            return this.content.stream().anyMatch(content -> Objects.equals(mediaType, content.getMediaType()));
        }
    }
}

