/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.deltafi.common.content.Segment;
import org.deltafi.common.types.Action;
import org.deltafi.common.types.ActionState;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.Content;
import org.deltafi.common.types.DeltaFileFlowInput;
import org.deltafi.common.types.DeltaFileFlowState;
import org.deltafi.common.types.FlowPlanCoordinates;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.ResumeMetadata;
import org.deltafi.core.exceptions.UnexpectedActionException;
import org.jetbrains.annotations.NotNull;

public class DeltaFileFlow {
    private String name;
    private int id;
    private FlowType type;
    private DeltaFileFlowState state;
    private OffsetDateTime created;
    private OffsetDateTime modified;
    private FlowPlanCoordinates flowPlan;
    private DeltaFileFlowInput input;
    private List<Action> actions;
    private List<String> publishTopics;
    private int depth;
    private Set<String> pendingAnnotations;
    boolean testMode;
    String testModeReason;

    public DeltaFileFlow(DeltaFileFlow other) {
        this.name = other.name;
        this.id = other.id;
        this.type = other.type;
        this.state = other.state;
        this.created = other.created;
        this.modified = other.modified;
        this.flowPlan = new FlowPlanCoordinates(other.flowPlan);
        this.input = other.input;
        this.actions = other.actions == null ? null : other.actions.stream().map(Action::new).toList();
        this.publishTopics = new ArrayList<String>(other.publishTopics);
        this.depth = other.depth;
        this.pendingAnnotations = new HashSet<String>(other.pendingAnnotations);
        this.testMode = other.testMode;
        this.testModeReason = other.testModeReason;
    }

    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>(this.input.getMetadata());
        for (Action action : this.actions) {
            metadata.putAll(action.getMetadata());
            for (String key : action.getDeleteMetadataKeys()) {
                metadata.remove(key);
            }
        }
        return metadata;
    }

    public List<Segment> uniqueSegments() {
        return this.actions.stream().flatMap(a -> a.getContent().stream()).flatMap(c -> c.getSegments().stream()).distinct().toList();
    }

    public void cancel(OffsetDateTime time) {
        if (this.state != DeltaFileFlowState.IN_FLIGHT && this.state != DeltaFileFlowState.ERROR) {
            return;
        }
        this.actions.forEach(a -> a.cancel(time));
        this.state = DeltaFileFlowState.CANCELLED;
        this.modified = time;
    }

    public boolean hasAutoResume() {
        return this.actions.stream().anyMatch(a -> a.getNextAutoResume() != null);
    }

    @JsonIgnore
    public Map<String, String> getImmutableMetadata() {
        return Collections.unmodifiableMap(this.getMetadata());
    }

    public List<Content> lastContent() {
        return this.latestMatchingAction(action -> action.getState() == ActionState.COMPLETE).map(Action::getContent).orElseGet(this::inputContent);
    }

    private List<Content> inputContent() {
        return this.input != null ? this.input.content : List.of();
    }

    @JsonIgnore
    public List<Content> getImmutableContent() {
        return this.lastContent().stream().map(Content::copy).toList();
    }

    public Action lastAction() {
        return this.actions.stream().reduce((first, second) -> second).orElse(null);
    }

    public boolean hasUnacknowledgedError() {
        Action lastAction = this.lastAction();
        return lastAction.getState() == ActionState.ERROR && lastAction.getErrorAcknowledged() == null;
    }

    public boolean hasPendingAnnotations() {
        return this.pendingAnnotations != null && !this.pendingAnnotations.isEmpty();
    }

    public Optional<Action> actionNamed(String name) {
        return this.latestMatchingAction(action -> action.getName().equals(name));
    }

    public Optional<Action> lastCompleteAction() {
        return this.latestMatchingAction(action -> action.getState() == ActionState.COMPLETE);
    }

    public Optional<Action> latestMatchingAction(Predicate<Action> filter) {
        return this.getActions().stream().filter(filter).reduce((first, second) -> second);
    }

    public Action queueAction(String actionName, ActionType type, boolean coldQueue, OffsetDateTime now) {
        this.modified = now;
        return this.latestMatchingAction(action -> this.nameMatchesAndNotRetried((Action)action, actionName)).map(action -> this.queueOldAction((Action)action, coldQueue, now)).orElseGet(() -> this.queueNewAction(actionName, type, coldQueue, now));
    }

    private boolean nameMatchesAndNotRetried(Action action, String actionName) {
        return action.getName().equals(actionName) && action.getState() != ActionState.RETRIED;
    }

    private Action queueOldAction(Action action, boolean coldQueue, OffsetDateTime now) {
        action.changeState(coldQueue ? ActionState.COLD_QUEUED : ActionState.QUEUED, null, null, now);
        return action;
    }

    public Action queueNewAction(String name, ActionType type, boolean coldQueue, OffsetDateTime now) {
        return this.addAction(name, type, coldQueue ? ActionState.COLD_QUEUED : ActionState.QUEUED, now);
    }

    public Action addAction(String name, ActionType type, ActionState state, OffsetDateTime now) {
        Action action = Action.builder().name(name).id(this.actions.size()).type(type).state(state).created(now).queued(now).modified(now).attempt(1 + this.getLastAttemptNum(name)).build();
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(action);
        return action;
    }

    private int getLastAttemptNum(String name) {
        Optional<Action> action = this.getActions().stream().filter(a -> a.getName().equals(name) && a.getState() != ActionState.RETRIED).reduce((first, second) -> second);
        return action.map(Action::getAttempt).orElse(0);
    }

    public List<String> queuedActions() {
        return this.getActions().stream().filter(Action::queued).map(Action::getName).toList();
    }

    public boolean terminal() {
        return this.state == DeltaFileFlowState.COMPLETE || this.state == DeltaFileFlowState.CANCELLED || this.state == DeltaFileFlowState.ERROR;
    }

    public Action getAction(String actionName, int actionId) {
        return this.getActions().stream().filter(action -> action.getName().equals(actionName) && action.getId() == actionId).findFirst().orElse(null);
    }

    public Action getPendingAction(String actionName, int actionId, String did) {
        Action action = this.getAction(actionName, actionId);
        if (action == null || action.terminal()) {
            throw new UnexpectedActionException(this.name, this.id, actionName, actionId, did);
        }
        return action;
    }

    public boolean resume(@NotNull List<ResumeMetadata> resumeMetadata, OffsetDateTime now) {
        Action lastAction = this.lastAction();
        if (lastAction == null || lastAction.getState() != ActionState.ERROR) {
            return false;
        }
        lastAction.retry(resumeMetadata.stream().filter(this::metadataFlowMatches).toList(), now);
        this.updateState(now);
        return true;
    }

    private boolean metadataFlowMatches(ResumeMetadata resumeMetadata) {
        return resumeMetadata.getFlow().equals(this.name);
    }

    private boolean isActionErrored(Action action) {
        return action != null && action.getState() == ActionState.ERROR;
    }

    public boolean hasActionInState(ActionState actionState) {
        return this.actions.stream().anyMatch(action -> action.getState().equals((Object)actionState));
    }

    public boolean acknowledgeError(OffsetDateTime now, String reason) {
        boolean acked = this.lastAction().acknowledgeError(now, reason);
        if (acked) {
            this.modified = now;
        }
        return acked;
    }

    public boolean clearErrorAcknowledged(OffsetDateTime now) {
        boolean cleared = this.lastAction().clearErrorAcknowledged(now);
        if (cleared) {
            this.modified = now;
        }
        return cleared;
    }

    public boolean hasCollectedAction(String name) {
        return this.actions.stream().anyMatch(a -> a.getName().equals(name) && a.getState() == ActionState.COLLECTED);
    }

    public boolean hasFinalAction(String name) {
        return this.getActions().stream().anyMatch(action -> action.getName().equals(name) && action.getState() != ActionState.RETRIED && action.terminal());
    }

    public void updateState(OffsetDateTime now) {
        this.modified = now;
        this.state = switch (this.lastAction().getState()) {
            case ActionState.ERROR -> DeltaFileFlowState.ERROR;
            case ActionState.CANCELLED -> DeltaFileFlowState.CANCELLED;
            case ActionState.COMPLETE -> {
                if (this.hasPendingAnnotations()) {
                    yield DeltaFileFlowState.PENDING_ANNOTATIONS;
                }
                yield DeltaFileFlowState.COMPLETE;
            }
            case ActionState.COLLECTED, ActionState.FILTERED, ActionState.SPLIT -> DeltaFileFlowState.COMPLETE;
            default -> DeltaFileFlowState.IN_FLIGHT;
        };
    }

    public void removePendingAnnotations(Set<String> receivedAnnotations) {
        this.pendingAnnotations = this.pendingAnnotations != null ? new HashSet<String>(this.pendingAnnotations) : new HashSet();
        this.pendingAnnotations.removeAll(receivedAnnotations);
        this.updateState(OffsetDateTime.now());
    }

    private static DeltaFileFlowState $default$state() {
        return DeltaFileFlowState.IN_FLIGHT;
    }

    private static DeltaFileFlowInput $default$input() {
        return new DeltaFileFlowInput();
    }

    private static List<Action> $default$actions() {
        return new ArrayList<Action>();
    }

    private static List<String> $default$publishTopics() {
        return new ArrayList<String>();
    }

    private static Set<String> $default$pendingAnnotations() {
        return new HashSet<String>();
    }

    public static DeltaFileFlowBuilder builder() {
        return new DeltaFileFlowBuilder();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public FlowType getType() {
        return this.type;
    }

    public DeltaFileFlowState getState() {
        return this.state;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OffsetDateTime getModified() {
        return this.modified;
    }

    public FlowPlanCoordinates getFlowPlan() {
        return this.flowPlan;
    }

    public DeltaFileFlowInput getInput() {
        return this.input;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public List<String> getPublishTopics() {
        return this.publishTopics;
    }

    public int getDepth() {
        return this.depth;
    }

    public Set<String> getPendingAnnotations() {
        return this.pendingAnnotations;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public String getTestModeReason() {
        return this.testModeReason;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setType(FlowType type) {
        this.type = type;
    }

    public void setState(DeltaFileFlowState state) {
        this.state = state;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public void setModified(OffsetDateTime modified) {
        this.modified = modified;
    }

    public void setFlowPlan(FlowPlanCoordinates flowPlan) {
        this.flowPlan = flowPlan;
    }

    public void setInput(DeltaFileFlowInput input) {
        this.input = input;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setPublishTopics(List<String> publishTopics) {
        this.publishTopics = publishTopics;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setPendingAnnotations(Set<String> pendingAnnotations) {
        this.pendingAnnotations = pendingAnnotations;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void setTestModeReason(String testModeReason) {
        this.testModeReason = testModeReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeltaFileFlow)) {
            return false;
        }
        DeltaFileFlow other = (DeltaFileFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        if (this.isTestMode() != other.isTestMode()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FlowType this$type = this.getType();
        FlowType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DeltaFileFlowState this$state = this.getState();
        DeltaFileFlowState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        OffsetDateTime this$modified = this.getModified();
        OffsetDateTime other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        FlowPlanCoordinates this$flowPlan = this.getFlowPlan();
        FlowPlanCoordinates other$flowPlan = other.getFlowPlan();
        if (this$flowPlan == null ? other$flowPlan != null : !((Object)this$flowPlan).equals(other$flowPlan)) {
            return false;
        }
        DeltaFileFlowInput this$input = this.getInput();
        DeltaFileFlowInput other$input = other.getInput();
        if (this$input == null ? other$input != null : !((Object)this$input).equals(other$input)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        List<String> this$publishTopics = this.getPublishTopics();
        List<String> other$publishTopics = other.getPublishTopics();
        if (this$publishTopics == null ? other$publishTopics != null : !((Object)this$publishTopics).equals(other$publishTopics)) {
            return false;
        }
        Set<String> this$pendingAnnotations = this.getPendingAnnotations();
        Set<String> other$pendingAnnotations = other.getPendingAnnotations();
        if (this$pendingAnnotations == null ? other$pendingAnnotations != null : !((Object)this$pendingAnnotations).equals(other$pendingAnnotations)) {
            return false;
        }
        String this$testModeReason = this.getTestModeReason();
        String other$testModeReason = other.getTestModeReason();
        return !(this$testModeReason == null ? other$testModeReason != null : !this$testModeReason.equals(other$testModeReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeltaFileFlow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getDepth();
        result = result * 59 + (this.isTestMode() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FlowType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DeltaFileFlowState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        OffsetDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        FlowPlanCoordinates $flowPlan = this.getFlowPlan();
        result = result * 59 + ($flowPlan == null ? 43 : ((Object)$flowPlan).hashCode());
        DeltaFileFlowInput $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        List<String> $publishTopics = this.getPublishTopics();
        result = result * 59 + ($publishTopics == null ? 43 : ((Object)$publishTopics).hashCode());
        Set<String> $pendingAnnotations = this.getPendingAnnotations();
        result = result * 59 + ($pendingAnnotations == null ? 43 : ((Object)$pendingAnnotations).hashCode());
        String $testModeReason = this.getTestModeReason();
        result = result * 59 + ($testModeReason == null ? 43 : $testModeReason.hashCode());
        return result;
    }

    public String toString() {
        return "DeltaFileFlow(name=" + this.getName() + ", id=" + this.getId() + ", type=" + String.valueOf((Object)this.getType()) + ", state=" + String.valueOf((Object)this.getState()) + ", created=" + String.valueOf(this.getCreated()) + ", modified=" + String.valueOf(this.getModified()) + ", flowPlan=" + String.valueOf(this.getFlowPlan()) + ", input=" + String.valueOf(this.getInput()) + ", actions=" + String.valueOf(this.getActions()) + ", publishTopics=" + String.valueOf(this.getPublishTopics()) + ", depth=" + this.getDepth() + ", pendingAnnotations=" + String.valueOf(this.getPendingAnnotations()) + ", testMode=" + this.isTestMode() + ", testModeReason=" + this.getTestModeReason() + ")";
    }

    public DeltaFileFlow() {
        this.state = DeltaFileFlow.$default$state();
        this.input = DeltaFileFlow.$default$input();
        this.actions = DeltaFileFlow.$default$actions();
        this.publishTopics = DeltaFileFlow.$default$publishTopics();
        this.pendingAnnotations = DeltaFileFlow.$default$pendingAnnotations();
    }

    public DeltaFileFlow(String name, int id, FlowType type, DeltaFileFlowState state, OffsetDateTime created, OffsetDateTime modified, FlowPlanCoordinates flowPlan, DeltaFileFlowInput input, List<Action> actions, List<String> publishTopics, int depth, Set<String> pendingAnnotations, boolean testMode, String testModeReason) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.state = state;
        this.created = created;
        this.modified = modified;
        this.flowPlan = flowPlan;
        this.input = input;
        this.actions = actions;
        this.publishTopics = publishTopics;
        this.depth = depth;
        this.pendingAnnotations = pendingAnnotations;
        this.testMode = testMode;
        this.testModeReason = testModeReason;
    }

    public static class DeltaFileFlowBuilder {
        private String name;
        private int id;
        private FlowType type;
        private boolean state$set;
        private DeltaFileFlowState state$value;
        private OffsetDateTime created;
        private OffsetDateTime modified;
        private FlowPlanCoordinates flowPlan;
        private boolean input$set;
        private DeltaFileFlowInput input$value;
        private boolean actions$set;
        private List<Action> actions$value;
        private boolean publishTopics$set;
        private List<String> publishTopics$value;
        private int depth;
        private boolean pendingAnnotations$set;
        private Set<String> pendingAnnotations$value;
        private boolean testMode;
        private String testModeReason;

        DeltaFileFlowBuilder() {
        }

        public DeltaFileFlowBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeltaFileFlowBuilder id(int id) {
            this.id = id;
            return this;
        }

        public DeltaFileFlowBuilder type(FlowType type) {
            this.type = type;
            return this;
        }

        public DeltaFileFlowBuilder state(DeltaFileFlowState state) {
            this.state$value = state;
            this.state$set = true;
            return this;
        }

        public DeltaFileFlowBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public DeltaFileFlowBuilder modified(OffsetDateTime modified) {
            this.modified = modified;
            return this;
        }

        public DeltaFileFlowBuilder flowPlan(FlowPlanCoordinates flowPlan) {
            this.flowPlan = flowPlan;
            return this;
        }

        public DeltaFileFlowBuilder input(DeltaFileFlowInput input) {
            this.input$value = input;
            this.input$set = true;
            return this;
        }

        public DeltaFileFlowBuilder actions(List<Action> actions) {
            this.actions$value = actions;
            this.actions$set = true;
            return this;
        }

        public DeltaFileFlowBuilder publishTopics(List<String> publishTopics) {
            this.publishTopics$value = publishTopics;
            this.publishTopics$set = true;
            return this;
        }

        public DeltaFileFlowBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public DeltaFileFlowBuilder pendingAnnotations(Set<String> pendingAnnotations) {
            this.pendingAnnotations$value = pendingAnnotations;
            this.pendingAnnotations$set = true;
            return this;
        }

        public DeltaFileFlowBuilder testMode(boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public DeltaFileFlowBuilder testModeReason(String testModeReason) {
            this.testModeReason = testModeReason;
            return this;
        }

        public DeltaFileFlow build() {
            DeltaFileFlowState state$value = this.state$value;
            if (!this.state$set) {
                state$value = DeltaFileFlow.$default$state();
            }
            DeltaFileFlowInput input$value = this.input$value;
            if (!this.input$set) {
                input$value = DeltaFileFlow.$default$input();
            }
            List<Action> actions$value = this.actions$value;
            if (!this.actions$set) {
                actions$value = DeltaFileFlow.$default$actions();
            }
            List<String> publishTopics$value = this.publishTopics$value;
            if (!this.publishTopics$set) {
                publishTopics$value = DeltaFileFlow.$default$publishTopics();
            }
            Set<String> pendingAnnotations$value = this.pendingAnnotations$value;
            if (!this.pendingAnnotations$set) {
                pendingAnnotations$value = DeltaFileFlow.$default$pendingAnnotations();
            }
            return new DeltaFileFlow(this.name, this.id, this.type, state$value, this.created, this.modified, this.flowPlan, input$value, actions$value, publishTopics$value, this.depth, pendingAnnotations$value, this.testMode, this.testModeReason);
        }

        public String toString() {
            return "DeltaFileFlow.DeltaFileFlowBuilder(name=" + this.name + ", id=" + this.id + ", type=" + String.valueOf((Object)this.type) + ", state$value=" + String.valueOf((Object)this.state$value) + ", created=" + String.valueOf(this.created) + ", modified=" + String.valueOf(this.modified) + ", flowPlan=" + String.valueOf(this.flowPlan) + ", input$value=" + String.valueOf(this.input$value) + ", actions$value=" + String.valueOf(this.actions$value) + ", publishTopics$value=" + String.valueOf(this.publishTopics$value) + ", depth=" + this.depth + ", pendingAnnotations$value=" + String.valueOf(this.pendingAnnotations$value) + ", testMode=" + this.testMode + ", testModeReason=" + this.testModeReason + ")";
        }
    }
}

