/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.EgressFlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.PluginCoordinates;
import org.deltafi.common.types.RestDataSourcePlan;
import org.deltafi.common.types.TimedDataSourcePlan;
import org.deltafi.common.types.TransformFlowPlan;
import org.springframework.data.annotation.Id;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EgressFlowPlan.class, name="EGRESS"), @JsonSubTypes.Type(value=TransformFlowPlan.class, name="TRANSFORM"), @JsonSubTypes.Type(value=TimedDataSourcePlan.class, name="TIMED_DATA_SOURCE"), @JsonSubTypes.Type(value=RestDataSourcePlan.class, name="REST_DATA_SOURCE")})
public abstract class FlowPlan {
    @Id
    private final String name;
    private final FlowType type;
    private final String description;
    private PluginCoordinates sourcePlugin;

    public abstract List<ActionConfiguration> allActionConfigurations();

    public FlowPlan(String name, FlowType type, String description) {
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public FlowType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public PluginCoordinates getSourcePlugin() {
        return this.sourcePlugin;
    }

    public void setSourcePlugin(PluginCoordinates sourcePlugin) {
        this.sourcePlugin = sourcePlugin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowPlan)) {
            return false;
        }
        FlowPlan other = (FlowPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        FlowType this$type = this.getType();
        FlowType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        PluginCoordinates this$sourcePlugin = this.getSourcePlugin();
        PluginCoordinates other$sourcePlugin = other.getSourcePlugin();
        return !(this$sourcePlugin == null ? other$sourcePlugin != null : !((Object)this$sourcePlugin).equals(other$sourcePlugin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowPlan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        FlowType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        PluginCoordinates $sourcePlugin = this.getSourcePlugin();
        result = result * 59 + ($sourcePlugin == null ? 43 : ((Object)$sourcePlugin).hashCode());
        return result;
    }

    public String toString() {
        return "FlowPlan(name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", description=" + this.getDescription() + ", sourcePlugin=" + String.valueOf(this.getSourcePlugin()) + ")";
    }
}

