/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.deltafi.common.content.Segment;
import org.deltafi.common.types.ActionState;
import org.deltafi.common.types.DeltaFileFlow;
import org.deltafi.common.types.DeltaFileFlowInput;
import org.deltafi.common.types.DeltaFileFlowState;
import org.deltafi.common.types.DeltaFileStage;
import org.deltafi.common.types.FlowPlanCoordinates;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.ResumeMetadata;
import org.deltafi.core.exceptions.UnexpectedFlowException;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Sharded;
import org.springframework.data.mongodb.core.query.Update;

@Document(value="deltaFiles")
@Sharded
public class DeltaFile {
    @Id
    private String did;
    private String name;
    private String normalizedName;
    private String dataSource;
    private List<String> parentDids;
    private boolean aggregate;
    private List<String> childDids;
    private List<DeltaFileFlow> flows;
    private int requeueCount;
    private long ingressBytes;
    private long referencedBytes;
    private long totalBytes;
    private DeltaFileStage stage;
    private Map<String, String> annotations;
    private Set<String> annotationKeys;
    private List<String> egressFlows;
    private OffsetDateTime created;
    private OffsetDateTime modified;
    private OffsetDateTime contentDeleted;
    private String contentDeletedReason;
    private Boolean egressed;
    private Boolean filtered;
    private OffsetDateTime replayed;
    private String replayDid;
    private boolean inFlight;
    private boolean terminal;
    private boolean contentDeletable;
    @Version
    @JsonIgnore
    private long version;
    @JsonIgnore
    private OffsetDateTime cacheTime;
    @Transient
    private DeltaFile snapshot;
    public static final int CURRENT_SCHEMA_VERSION = 1;
    private int schemaVersion;

    public DeltaFile(DeltaFile other) {
        this.did = other.did;
        this.parentDids = other.parentDids == null ? null : new ArrayList<String>(other.parentDids);
        this.aggregate = other.aggregate;
        this.childDids = other.childDids == null ? null : new ArrayList<String>(other.childDids);
        this.requeueCount = other.requeueCount;
        this.ingressBytes = other.ingressBytes;
        this.referencedBytes = other.referencedBytes;
        this.totalBytes = other.totalBytes;
        this.stage = other.stage;
        this.flows = other.flows == null ? null : other.flows.stream().map(DeltaFileFlow::new).toList();
        this.annotations = other.annotations == null ? null : new HashMap<String, String>(other.annotations);
        this.annotationKeys = other.annotationKeys == null ? null : new HashSet<String>(other.annotationKeys);
        this.egressFlows = other.egressFlows == null ? null : new ArrayList<String>(other.egressFlows);
        this.created = other.created;
        this.modified = other.modified;
        this.contentDeleted = other.contentDeleted;
        this.contentDeletedReason = other.contentDeletedReason;
        this.egressed = other.egressed;
        this.filtered = other.filtered;
        this.replayed = other.replayed;
        this.replayDid = other.replayDid;
        this.inFlight = other.inFlight;
        this.terminal = other.terminal;
        this.contentDeletable = other.contentDeletable;
        this.version = other.version;
        this.cacheTime = other.cacheTime;
        this.schemaVersion = other.schemaVersion;
        this.snapshot = null;
    }

    public void snapshot() {
        this.snapshot = new DeltaFile(this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations == null ? Collections.emptyMap() : this.annotations;
    }

    public Set<String> getAnnotationKeys() {
        return this.annotationKeys == null ? Collections.emptySet() : this.annotationKeys;
    }

    public void setStage(DeltaFileStage stage) {
        this.stage = stage;
        this.updateFlags();
    }

    public void updateFlags() {
        this.inFlight = this.stage == DeltaFileStage.IN_FLIGHT;
        this.terminal = !this.inFlight && this.unackErrorFlows().isEmpty() && this.pendingAnnotationFlows().isEmpty();
        this.contentDeletable = this.terminal && this.contentDeleted == null && this.totalBytes > 0L;
    }

    public void setContentDeleted(OffsetDateTime contentDeleted) {
        this.contentDeleted = contentDeleted;
        this.updateFlags();
    }

    public List<DeltaFileFlow> unackErrorFlows() {
        return this.flows.stream().filter(DeltaFileFlow::hasUnacknowledgedError).toList();
    }

    public List<DeltaFileFlow> pendingAnnotationFlows() {
        return this.flows.stream().filter(DeltaFileFlow::hasPendingAnnotations).toList();
    }

    public void updatePendingAnnotations() {
        List<DeltaFileFlow> pendingAnnotations = this.pendingAnnotationFlows();
        if (!pendingAnnotations.isEmpty()) {
            pendingAnnotations.forEach(deltaFileFlow -> deltaFileFlow.removePendingAnnotations(this.annotationKeys));
            this.updateFlags();
        }
    }

    public void setPendingAnnotations(String flowName, Set<String> expectedAnnotations, OffsetDateTime now) {
        Set<String> pendingAnnotations = this.getPendingAnnotations(expectedAnnotations);
        this.flows.stream().filter(flow -> flow.getType() == FlowType.EGRESS && flow.getName().equals(flowName)).forEach(deltaFileFlow -> this.setPendingAnnotations((DeltaFileFlow)deltaFileFlow, pendingAnnotations, now));
        this.updateFlags();
    }

    public Set<String> getPendingAnnotations(Set<String> expectedAnnotations) {
        HashSet<String> pendingAnnotations;
        HashSet<String> hashSet = pendingAnnotations = expectedAnnotations != null ? new HashSet<String>(expectedAnnotations) : new HashSet();
        if (this.annotationKeys != null) {
            pendingAnnotations.removeAll(this.annotationKeys);
        }
        return pendingAnnotations;
    }

    private void setPendingAnnotations(DeltaFileFlow flow, Set<String> expectedAnnotations, OffsetDateTime now) {
        flow.setPendingAnnotations(expectedAnnotations);
        flow.updateState(now);
    }

    public List<DeltaFileFlow> erroredFlows() {
        return this.flows.stream().filter(f -> f.getState() == DeltaFileFlowState.ERROR).toList();
    }

    public void collectedAction(String flowName, String actionName, OffsetDateTime start, OffsetDateTime stop, OffsetDateTime now) {
        this.flows.stream().filter(f -> f.getName().equals(flowName) && !f.terminal()).flatMap(f -> f.getActions().stream()).filter(a -> a.getName().equals(actionName) && !a.terminal()).forEach(action -> action.changeState(ActionState.COLLECTED, start, stop, now));
    }

    public List<DeltaFileFlow> resumeErrors(@NotNull List<ResumeMetadata> resumeMetadata, OffsetDateTime now) {
        List<DeltaFileFlow> retries = this.flows.stream().filter(f -> f.resume(resumeMetadata, now)).toList();
        if (!retries.isEmpty()) {
            this.modified = now;
        }
        return retries;
    }

    public void addAnnotations(Map<String, String> metadata) {
        if (null == metadata) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.putAll(metadata);
        if (this.annotationKeys == null) {
            this.annotationKeys = new HashSet<String>();
        }
        this.annotationKeys.addAll(metadata.keySet());
    }

    public void addAnnotationsIfAbsent(Map<String, String> metadata) {
        metadata.forEach(this::addAnnotationIfAbsent);
    }

    public void addAnnotationIfAbsent(String key, String value) {
        if (null == key || this.annotations != null && this.annotations.containsKey(key)) {
            return;
        }
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, value);
        if (this.annotationKeys == null) {
            this.annotationKeys = new HashSet<String>();
        }
        this.annotationKeys.add(key);
    }

    public boolean hasPendingActions() {
        return this.flows.stream().anyMatch(flow -> !flow.terminal());
    }

    public boolean hasErrors() {
        return this.flows.stream().anyMatch(flow -> flow.getState() == DeltaFileFlowState.ERROR);
    }

    public boolean hasCollectingAction() {
        return this.flows.stream().anyMatch(f -> f.hasActionInState(ActionState.COLLECTING));
    }

    public DeltaFileFlow getFlow(String flowName, int flowId) {
        return this.flows.stream().filter(f -> f.getId() == flowId && f.getName().equals(flowName)).findFirst().orElse(null);
    }

    public DeltaFileFlow getPendingFlow(String flowName, int flowId) {
        DeltaFileFlow flow = this.getFlow(flowName, flowId);
        if (flow == null || flow.terminal()) {
            throw new UnexpectedFlowException(flowName, flowId, this.did);
        }
        return flow;
    }

    public Set<String> pendingAnnotations(Set<String> expectedAnnotations) {
        expectedAnnotations = expectedAnnotations != null ? new HashSet<String>(expectedAnnotations) : new HashSet();
        Set<String> indexedKeys = this.getAnnotationKeys();
        indexedKeys.forEach(expectedAnnotations::remove);
        return expectedAnnotations;
    }

    public Set<Segment> referencedSegments() {
        return this.flows.stream().flatMap(f -> f.uniqueSegments().stream()).collect(Collectors.toSet());
    }

    public Set<Segment> storedSegments() {
        return this.flows.stream().flatMap(f -> f.uniqueSegments().stream()).filter(s -> s.getDid().equals(this.getDid())).collect(Collectors.toSet());
    }

    public void recalculateBytes() {
        this.setReferencedBytes(Segment.calculateTotalSize(this.referencedSegments()));
        this.setTotalBytes(Segment.calculateTotalSize(this.storedSegments()));
        this.updateFlags();
    }

    public void cancel(OffsetDateTime now) {
        if (!this.canBeCancelled()) {
            return;
        }
        this.setStage(DeltaFileStage.CANCELLED);
        this.flows.forEach(d -> d.cancel(now));
        this.modified = now;
    }

    public void incrementRequeueCount() {
        ++this.requeueCount;
    }

    public boolean canBeCancelled() {
        return !this.inactiveStage() || this.flows.stream().anyMatch(DeltaFileFlow::hasAutoResume);
    }

    public boolean inactiveStage() {
        return this.getStage() == DeltaFileStage.COMPLETE || this.getStage() == DeltaFileStage.ERROR || this.getStage() == DeltaFileStage.CANCELLED;
    }

    public void acknowledgeErrors(OffsetDateTime now, String reason) {
        boolean found = this.flows.stream().map(f -> f.acknowledgeError(now, reason)).reduce(false, (a, b) -> a != false || b != false);
        if (found) {
            this.modified = now;
            this.updateFlags();
        }
    }

    public void clearErrorAcknowledged(OffsetDateTime now) {
        boolean found = this.flows.stream().map(f -> f.clearErrorAcknowledged(now)).reduce(false, (a, b) -> a != false || b != false);
        if (found) {
            this.modified = now;
            this.updateFlags();
        }
    }

    public void updateState(OffsetDateTime now) {
        this.modified = now;
        if (!this.hasPendingActions()) {
            this.stage = this.hasErrors() ? DeltaFileStage.ERROR : DeltaFileStage.COMPLETE;
        } else if (this.stage != DeltaFileStage.CANCELLED) {
            this.stage = DeltaFileStage.IN_FLIGHT;
        }
        this.recalculateBytes();
        this.updateFlags();
    }

    public DeltaFileFlow addFlow(String name, FlowType type, DeltaFileFlow previousFlow, OffsetDateTime now) {
        return this.addFlow(name, type, previousFlow, Set.of(), now);
    }

    public DeltaFileFlow addFlow(String name, FlowType type, DeltaFileFlow previousFlow, Set<String> subscribedTopics, OffsetDateTime now) {
        DeltaFileFlow flow = DeltaFileFlow.builder().name(name).id(this.flows.stream().mapToInt(DeltaFileFlow::getId).max().orElse(0) + 1).type(type).state(DeltaFileFlowState.IN_FLIGHT).created(now).modified(now).flowPlan(FlowPlanCoordinates.builder().build()).input(DeltaFileFlowInput.builder().metadata(previousFlow.getMetadata()).content(previousFlow.lastContent()).topics(subscribedTopics).ancestorIds(new ArrayList<Integer>(previousFlow.getInput().getAncestorIds())).build()).depth(previousFlow.getDepth() + 1).testMode(previousFlow.isTestMode()).testModeReason(previousFlow.getTestModeReason()).build();
        this.flows.add(flow);
        if (type == FlowType.EGRESS) {
            this.egressFlows.add(name);
        }
        return flow;
    }

    public void removeFlowsNotDescendedFrom(int flowId) {
        this.flows.removeIf(f -> !f.getInput().getAncestorIds().contains(flowId));
        List<Integer> remainingFlowIds = this.flows.stream().map(DeltaFileFlow::getId).toList();
        this.flows.forEach(f -> f.getInput().getAncestorIds().retainAll(remainingFlowIds));
    }

    public void setName(String name) {
        this.name = name;
        this.normalizedName = name != null ? name.toLowerCase() : null;
    }

    public Update generateUpdate() {
        Update update = new Update();
        boolean updated = false;
        if (!Objects.equals(this.aggregate, this.snapshot.aggregate)) {
            update.set("aggregate", (Object)this.aggregate);
            updated = true;
        }
        if (!Objects.equals(this.childDids, this.snapshot.childDids)) {
            update.set("childDids", this.childDids);
            updated = true;
        }
        if (!Objects.equals(this.flows, this.snapshot.flows)) {
            if (this.flows.size() == this.snapshot.flows.size()) {
                for (int i = 0; i < this.snapshot.flows.size(); ++i) {
                    if (Objects.equals(this.flows.get(i), this.snapshot.flows.get(i))) continue;
                    update.set(String.format("flows.%d", i), (Object)this.flows.get(i));
                }
            } else {
                update.set("flows", this.flows);
            }
            updated = true;
        }
        if (!Objects.equals(this.requeueCount, this.snapshot.requeueCount)) {
            update.set("requeueCount", (Object)this.requeueCount);
            updated = true;
        }
        if (!Objects.equals(this.ingressBytes, this.snapshot.ingressBytes)) {
            update.set("ingressBytes", (Object)this.ingressBytes);
            updated = true;
        }
        if (!Objects.equals(this.referencedBytes, this.snapshot.referencedBytes)) {
            update.set("referencedBytes", (Object)this.referencedBytes);
            updated = true;
        }
        if (!Objects.equals(this.totalBytes, this.snapshot.totalBytes)) {
            update.set("totalBytes", (Object)this.totalBytes);
            updated = true;
        }
        if (!Objects.equals((Object)this.stage, (Object)this.snapshot.stage)) {
            update.set("stage", (Object)this.stage);
            updated = true;
        }
        if (!Objects.equals(this.annotations, this.snapshot.annotations)) {
            update.set("annotations", this.annotations);
            updated = true;
        }
        if (!Objects.equals(this.annotationKeys, this.snapshot.annotationKeys)) {
            update.set("annotationKeys", this.annotationKeys);
            updated = true;
        }
        if (!Objects.equals(this.egressFlows, this.snapshot.egressFlows)) {
            update.set("egressFlows", this.egressFlows);
            updated = true;
        }
        if (!Objects.equals(this.modified, this.snapshot.modified)) {
            update.set("modified", (Object)this.modified);
            updated = true;
        }
        if (!Objects.equals(this.contentDeleted, this.snapshot.contentDeleted)) {
            update.set("contentDeleted", (Object)this.contentDeleted);
            updated = true;
        }
        if (!Objects.equals(this.contentDeletedReason, this.snapshot.contentDeletedReason)) {
            update.set("contentDeletedReason", (Object)this.contentDeletedReason);
            updated = true;
        }
        if (!Objects.equals(this.egressed, this.snapshot.egressed)) {
            update.set("egressed", (Object)this.egressed);
            updated = true;
        }
        if (!Objects.equals(this.filtered, this.snapshot.filtered)) {
            update.set("filtered", (Object)this.filtered);
            updated = true;
        }
        if (!Objects.equals(this.replayed, this.snapshot.replayed)) {
            update.set("replayed", (Object)this.replayed);
            updated = true;
        }
        if (!Objects.equals(this.replayDid, this.snapshot.replayDid)) {
            update.set("replayDid", (Object)this.replayDid);
            updated = true;
        }
        if (!Objects.equals(this.inFlight, this.snapshot.inFlight)) {
            update.set("inFlight", (Object)this.inFlight);
            updated = true;
        }
        if (!Objects.equals(this.terminal, this.snapshot.terminal)) {
            update.set("terminal", (Object)this.terminal);
            updated = true;
        }
        if (!Objects.equals(this.contentDeletable, this.snapshot.contentDeletable)) {
            update.set("contentDeletable", (Object)this.contentDeletable);
            updated = true;
        }
        if (!Objects.equals(this.schemaVersion, this.snapshot.schemaVersion)) {
            update.set("schemaVersion", (Object)this.schemaVersion);
            updated = true;
        }
        if (!updated) {
            return null;
        }
        update.set("version", (Object)(this.version + 1L));
        return update;
    }

    private static List<String> $default$parentDids() {
        return new ArrayList<String>();
    }

    private static List<String> $default$childDids() {
        return new ArrayList<String>();
    }

    private static List<DeltaFileFlow> $default$flows() {
        return new ArrayList<DeltaFileFlow>();
    }

    private static Map<String, String> $default$annotations() {
        return new HashMap<String, String>();
    }

    private static Set<String> $default$annotationKeys() {
        return new HashSet<String>();
    }

    private static List<String> $default$egressFlows() {
        return new ArrayList<String>();
    }

    private static boolean $default$inFlight() {
        return true;
    }

    private static boolean $default$terminal() {
        return false;
    }

    private static boolean $default$contentDeletable() {
        return false;
    }

    private static OffsetDateTime $default$cacheTime() {
        return null;
    }

    private static DeltaFile $default$snapshot() {
        return null;
    }

    public static DeltaFileBuilder builder() {
        return new DeltaFileBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public List<String> getParentDids() {
        return this.parentDids;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public List<String> getChildDids() {
        return this.childDids;
    }

    public List<DeltaFileFlow> getFlows() {
        return this.flows;
    }

    public int getRequeueCount() {
        return this.requeueCount;
    }

    public long getIngressBytes() {
        return this.ingressBytes;
    }

    public long getReferencedBytes() {
        return this.referencedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public DeltaFileStage getStage() {
        return this.stage;
    }

    public List<String> getEgressFlows() {
        return this.egressFlows;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OffsetDateTime getModified() {
        return this.modified;
    }

    public OffsetDateTime getContentDeleted() {
        return this.contentDeleted;
    }

    public String getContentDeletedReason() {
        return this.contentDeletedReason;
    }

    public Boolean getEgressed() {
        return this.egressed;
    }

    public Boolean getFiltered() {
        return this.filtered;
    }

    public OffsetDateTime getReplayed() {
        return this.replayed;
    }

    public String getReplayDid() {
        return this.replayDid;
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean isContentDeletable() {
        return this.contentDeletable;
    }

    public DeltaFile getSnapshot() {
        return this.snapshot;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setNormalizedName(String normalizedName) {
        this.normalizedName = normalizedName;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setParentDids(List<String> parentDids) {
        this.parentDids = parentDids;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public void setChildDids(List<String> childDids) {
        this.childDids = childDids;
    }

    public void setFlows(List<DeltaFileFlow> flows) {
        this.flows = flows;
    }

    public void setRequeueCount(int requeueCount) {
        this.requeueCount = requeueCount;
    }

    public void setIngressBytes(long ingressBytes) {
        this.ingressBytes = ingressBytes;
    }

    public void setReferencedBytes(long referencedBytes) {
        this.referencedBytes = referencedBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setAnnotationKeys(Set<String> annotationKeys) {
        this.annotationKeys = annotationKeys;
    }

    public void setEgressFlows(List<String> egressFlows) {
        this.egressFlows = egressFlows;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public void setModified(OffsetDateTime modified) {
        this.modified = modified;
    }

    public void setContentDeletedReason(String contentDeletedReason) {
        this.contentDeletedReason = contentDeletedReason;
    }

    public void setEgressed(Boolean egressed) {
        this.egressed = egressed;
    }

    public void setFiltered(Boolean filtered) {
        this.filtered = filtered;
    }

    public void setReplayed(OffsetDateTime replayed) {
        this.replayed = replayed;
    }

    public void setReplayDid(String replayDid) {
        this.replayDid = replayDid;
    }

    public void setInFlight(boolean inFlight) {
        this.inFlight = inFlight;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    public void setContentDeletable(boolean contentDeletable) {
        this.contentDeletable = contentDeletable;
    }

    public void setSnapshot(DeltaFile snapshot) {
        this.snapshot = snapshot;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeltaFile)) {
            return false;
        }
        DeltaFile other = (DeltaFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAggregate() != other.isAggregate()) {
            return false;
        }
        if (this.getRequeueCount() != other.getRequeueCount()) {
            return false;
        }
        if (this.getIngressBytes() != other.getIngressBytes()) {
            return false;
        }
        if (this.getReferencedBytes() != other.getReferencedBytes()) {
            return false;
        }
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        if (this.isInFlight() != other.isInFlight()) {
            return false;
        }
        if (this.isTerminal() != other.isTerminal()) {
            return false;
        }
        if (this.isContentDeletable() != other.isContentDeletable()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getSchemaVersion() != other.getSchemaVersion()) {
            return false;
        }
        Boolean this$egressed = this.getEgressed();
        Boolean other$egressed = other.getEgressed();
        if (this$egressed == null ? other$egressed != null : !((Object)this$egressed).equals(other$egressed)) {
            return false;
        }
        Boolean this$filtered = this.getFiltered();
        Boolean other$filtered = other.getFiltered();
        if (this$filtered == null ? other$filtered != null : !((Object)this$filtered).equals(other$filtered)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$normalizedName = this.getNormalizedName();
        String other$normalizedName = other.getNormalizedName();
        if (this$normalizedName == null ? other$normalizedName != null : !this$normalizedName.equals(other$normalizedName)) {
            return false;
        }
        String this$dataSource = this.getDataSource();
        String other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        List<String> this$parentDids = this.getParentDids();
        List<String> other$parentDids = other.getParentDids();
        if (this$parentDids == null ? other$parentDids != null : !((Object)this$parentDids).equals(other$parentDids)) {
            return false;
        }
        List<String> this$childDids = this.getChildDids();
        List<String> other$childDids = other.getChildDids();
        if (this$childDids == null ? other$childDids != null : !((Object)this$childDids).equals(other$childDids)) {
            return false;
        }
        List<DeltaFileFlow> this$flows = this.getFlows();
        List<DeltaFileFlow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        DeltaFileStage this$stage = this.getStage();
        DeltaFileStage other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !((Object)((Object)this$stage)).equals((Object)other$stage)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Set<String> this$annotationKeys = this.getAnnotationKeys();
        Set<String> other$annotationKeys = other.getAnnotationKeys();
        if (this$annotationKeys == null ? other$annotationKeys != null : !((Object)this$annotationKeys).equals(other$annotationKeys)) {
            return false;
        }
        List<String> this$egressFlows = this.getEgressFlows();
        List<String> other$egressFlows = other.getEgressFlows();
        if (this$egressFlows == null ? other$egressFlows != null : !((Object)this$egressFlows).equals(other$egressFlows)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        OffsetDateTime this$modified = this.getModified();
        OffsetDateTime other$modified = other.getModified();
        if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
            return false;
        }
        OffsetDateTime this$contentDeleted = this.getContentDeleted();
        OffsetDateTime other$contentDeleted = other.getContentDeleted();
        if (this$contentDeleted == null ? other$contentDeleted != null : !((Object)this$contentDeleted).equals(other$contentDeleted)) {
            return false;
        }
        String this$contentDeletedReason = this.getContentDeletedReason();
        String other$contentDeletedReason = other.getContentDeletedReason();
        if (this$contentDeletedReason == null ? other$contentDeletedReason != null : !this$contentDeletedReason.equals(other$contentDeletedReason)) {
            return false;
        }
        OffsetDateTime this$replayed = this.getReplayed();
        OffsetDateTime other$replayed = other.getReplayed();
        if (this$replayed == null ? other$replayed != null : !((Object)this$replayed).equals(other$replayed)) {
            return false;
        }
        String this$replayDid = this.getReplayDid();
        String other$replayDid = other.getReplayDid();
        if (this$replayDid == null ? other$replayDid != null : !this$replayDid.equals(other$replayDid)) {
            return false;
        }
        OffsetDateTime this$cacheTime = this.getCacheTime();
        OffsetDateTime other$cacheTime = other.getCacheTime();
        if (this$cacheTime == null ? other$cacheTime != null : !((Object)this$cacheTime).equals(other$cacheTime)) {
            return false;
        }
        DeltaFile this$snapshot = this.getSnapshot();
        DeltaFile other$snapshot = other.getSnapshot();
        return !(this$snapshot == null ? other$snapshot != null : !((Object)this$snapshot).equals(other$snapshot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeltaFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAggregate() ? 79 : 97);
        result = result * 59 + this.getRequeueCount();
        long $ingressBytes = this.getIngressBytes();
        result = result * 59 + (int)($ingressBytes >>> 32 ^ $ingressBytes);
        long $referencedBytes = this.getReferencedBytes();
        result = result * 59 + (int)($referencedBytes >>> 32 ^ $referencedBytes);
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        result = result * 59 + (this.isInFlight() ? 79 : 97);
        result = result * 59 + (this.isTerminal() ? 79 : 97);
        result = result * 59 + (this.isContentDeletable() ? 79 : 97);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + this.getSchemaVersion();
        Boolean $egressed = this.getEgressed();
        result = result * 59 + ($egressed == null ? 43 : ((Object)$egressed).hashCode());
        Boolean $filtered = this.getFiltered();
        result = result * 59 + ($filtered == null ? 43 : ((Object)$filtered).hashCode());
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $normalizedName = this.getNormalizedName();
        result = result * 59 + ($normalizedName == null ? 43 : $normalizedName.hashCode());
        String $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        List<String> $parentDids = this.getParentDids();
        result = result * 59 + ($parentDids == null ? 43 : ((Object)$parentDids).hashCode());
        List<String> $childDids = this.getChildDids();
        result = result * 59 + ($childDids == null ? 43 : ((Object)$childDids).hashCode());
        List<DeltaFileFlow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        DeltaFileStage $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : ((Object)((Object)$stage)).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Set<String> $annotationKeys = this.getAnnotationKeys();
        result = result * 59 + ($annotationKeys == null ? 43 : ((Object)$annotationKeys).hashCode());
        List<String> $egressFlows = this.getEgressFlows();
        result = result * 59 + ($egressFlows == null ? 43 : ((Object)$egressFlows).hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        OffsetDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        OffsetDateTime $contentDeleted = this.getContentDeleted();
        result = result * 59 + ($contentDeleted == null ? 43 : ((Object)$contentDeleted).hashCode());
        String $contentDeletedReason = this.getContentDeletedReason();
        result = result * 59 + ($contentDeletedReason == null ? 43 : $contentDeletedReason.hashCode());
        OffsetDateTime $replayed = this.getReplayed();
        result = result * 59 + ($replayed == null ? 43 : ((Object)$replayed).hashCode());
        String $replayDid = this.getReplayDid();
        result = result * 59 + ($replayDid == null ? 43 : $replayDid.hashCode());
        OffsetDateTime $cacheTime = this.getCacheTime();
        result = result * 59 + ($cacheTime == null ? 43 : ((Object)$cacheTime).hashCode());
        DeltaFile $snapshot = this.getSnapshot();
        result = result * 59 + ($snapshot == null ? 43 : ((Object)$snapshot).hashCode());
        return result;
    }

    public String toString() {
        return "DeltaFile(did=" + this.getDid() + ", name=" + this.getName() + ", normalizedName=" + this.getNormalizedName() + ", dataSource=" + this.getDataSource() + ", parentDids=" + String.valueOf(this.getParentDids()) + ", aggregate=" + this.isAggregate() + ", childDids=" + String.valueOf(this.getChildDids()) + ", flows=" + String.valueOf(this.getFlows()) + ", requeueCount=" + this.getRequeueCount() + ", ingressBytes=" + this.getIngressBytes() + ", referencedBytes=" + this.getReferencedBytes() + ", totalBytes=" + this.getTotalBytes() + ", stage=" + String.valueOf((Object)this.getStage()) + ", annotations=" + String.valueOf(this.getAnnotations()) + ", annotationKeys=" + String.valueOf(this.getAnnotationKeys()) + ", egressFlows=" + String.valueOf(this.getEgressFlows()) + ", created=" + String.valueOf(this.getCreated()) + ", modified=" + String.valueOf(this.getModified()) + ", contentDeleted=" + String.valueOf(this.getContentDeleted()) + ", contentDeletedReason=" + this.getContentDeletedReason() + ", egressed=" + this.getEgressed() + ", filtered=" + this.getFiltered() + ", replayed=" + String.valueOf(this.getReplayed()) + ", replayDid=" + this.getReplayDid() + ", inFlight=" + this.isInFlight() + ", terminal=" + this.isTerminal() + ", contentDeletable=" + this.isContentDeletable() + ", version=" + this.getVersion() + ", cacheTime=" + String.valueOf(this.getCacheTime()) + ", snapshot=" + String.valueOf(this.getSnapshot()) + ", schemaVersion=" + this.getSchemaVersion() + ")";
    }

    public DeltaFile(String did, String name, String normalizedName, String dataSource, List<String> parentDids, boolean aggregate, List<String> childDids, List<DeltaFileFlow> flows, int requeueCount, long ingressBytes, long referencedBytes, long totalBytes, DeltaFileStage stage, Map<String, String> annotations, Set<String> annotationKeys, List<String> egressFlows, OffsetDateTime created, OffsetDateTime modified, OffsetDateTime contentDeleted, String contentDeletedReason, Boolean egressed, Boolean filtered, OffsetDateTime replayed, String replayDid, boolean inFlight, boolean terminal, boolean contentDeletable, long version, OffsetDateTime cacheTime, DeltaFile snapshot, int schemaVersion) {
        this.did = did;
        this.name = name;
        this.normalizedName = normalizedName;
        this.dataSource = dataSource;
        this.parentDids = parentDids;
        this.aggregate = aggregate;
        this.childDids = childDids;
        this.flows = flows;
        this.requeueCount = requeueCount;
        this.ingressBytes = ingressBytes;
        this.referencedBytes = referencedBytes;
        this.totalBytes = totalBytes;
        this.stage = stage;
        this.annotations = annotations;
        this.annotationKeys = annotationKeys;
        this.egressFlows = egressFlows;
        this.created = created;
        this.modified = modified;
        this.contentDeleted = contentDeleted;
        this.contentDeletedReason = contentDeletedReason;
        this.egressed = egressed;
        this.filtered = filtered;
        this.replayed = replayed;
        this.replayDid = replayDid;
        this.inFlight = inFlight;
        this.terminal = terminal;
        this.contentDeletable = contentDeletable;
        this.version = version;
        this.cacheTime = cacheTime;
        this.snapshot = snapshot;
        this.schemaVersion = schemaVersion;
    }

    public DeltaFile() {
        this.parentDids = DeltaFile.$default$parentDids();
        this.childDids = DeltaFile.$default$childDids();
        this.flows = DeltaFile.$default$flows();
        this.annotations = DeltaFile.$default$annotations();
        this.annotationKeys = DeltaFile.$default$annotationKeys();
        this.egressFlows = DeltaFile.$default$egressFlows();
        this.inFlight = DeltaFile.$default$inFlight();
        this.terminal = DeltaFile.$default$terminal();
        this.contentDeletable = DeltaFile.$default$contentDeletable();
        this.cacheTime = DeltaFile.$default$cacheTime();
        this.snapshot = DeltaFile.$default$snapshot();
    }

    public long getVersion() {
        return this.version;
    }

    @JsonIgnore
    public void setVersion(long version) {
        this.version = version;
    }

    public OffsetDateTime getCacheTime() {
        return this.cacheTime;
    }

    @JsonIgnore
    public void setCacheTime(OffsetDateTime cacheTime) {
        this.cacheTime = cacheTime;
    }

    public static class DeltaFileBuilder {
        private String did;
        private String name;
        private String normalizedName;
        private String dataSource;
        private boolean parentDids$set;
        private List<String> parentDids$value;
        private boolean aggregate;
        private boolean childDids$set;
        private List<String> childDids$value;
        private boolean flows$set;
        private List<DeltaFileFlow> flows$value;
        private int requeueCount;
        private long ingressBytes;
        private long referencedBytes;
        private long totalBytes;
        private DeltaFileStage stage;
        private boolean annotations$set;
        private Map<String, String> annotations$value;
        private boolean annotationKeys$set;
        private Set<String> annotationKeys$value;
        private boolean egressFlows$set;
        private List<String> egressFlows$value;
        private OffsetDateTime created;
        private OffsetDateTime modified;
        private OffsetDateTime contentDeleted;
        private String contentDeletedReason;
        private Boolean egressed;
        private Boolean filtered;
        private OffsetDateTime replayed;
        private String replayDid;
        private boolean inFlight$set;
        private boolean inFlight$value;
        private boolean terminal$set;
        private boolean terminal$value;
        private boolean contentDeletable$set;
        private boolean contentDeletable$value;
        private long version;
        private boolean cacheTime$set;
        private OffsetDateTime cacheTime$value;
        private boolean snapshot$set;
        private DeltaFile snapshot$value;
        private int schemaVersion;

        DeltaFileBuilder() {
        }

        public DeltaFileBuilder did(String did) {
            this.did = did;
            return this;
        }

        public DeltaFileBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeltaFileBuilder normalizedName(String normalizedName) {
            this.normalizedName = normalizedName;
            return this;
        }

        public DeltaFileBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DeltaFileBuilder parentDids(List<String> parentDids) {
            this.parentDids$value = parentDids;
            this.parentDids$set = true;
            return this;
        }

        public DeltaFileBuilder aggregate(boolean aggregate) {
            this.aggregate = aggregate;
            return this;
        }

        public DeltaFileBuilder childDids(List<String> childDids) {
            this.childDids$value = childDids;
            this.childDids$set = true;
            return this;
        }

        public DeltaFileBuilder flows(List<DeltaFileFlow> flows) {
            this.flows$value = flows;
            this.flows$set = true;
            return this;
        }

        public DeltaFileBuilder requeueCount(int requeueCount) {
            this.requeueCount = requeueCount;
            return this;
        }

        public DeltaFileBuilder ingressBytes(long ingressBytes) {
            this.ingressBytes = ingressBytes;
            return this;
        }

        public DeltaFileBuilder referencedBytes(long referencedBytes) {
            this.referencedBytes = referencedBytes;
            return this;
        }

        public DeltaFileBuilder totalBytes(long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public DeltaFileBuilder stage(DeltaFileStage stage) {
            this.stage = stage;
            return this;
        }

        public DeltaFileBuilder annotations(Map<String, String> annotations) {
            this.annotations$value = annotations;
            this.annotations$set = true;
            return this;
        }

        public DeltaFileBuilder annotationKeys(Set<String> annotationKeys) {
            this.annotationKeys$value = annotationKeys;
            this.annotationKeys$set = true;
            return this;
        }

        public DeltaFileBuilder egressFlows(List<String> egressFlows) {
            this.egressFlows$value = egressFlows;
            this.egressFlows$set = true;
            return this;
        }

        public DeltaFileBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        public DeltaFileBuilder modified(OffsetDateTime modified) {
            this.modified = modified;
            return this;
        }

        public DeltaFileBuilder contentDeleted(OffsetDateTime contentDeleted) {
            this.contentDeleted = contentDeleted;
            return this;
        }

        public DeltaFileBuilder contentDeletedReason(String contentDeletedReason) {
            this.contentDeletedReason = contentDeletedReason;
            return this;
        }

        public DeltaFileBuilder egressed(Boolean egressed) {
            this.egressed = egressed;
            return this;
        }

        public DeltaFileBuilder filtered(Boolean filtered) {
            this.filtered = filtered;
            return this;
        }

        public DeltaFileBuilder replayed(OffsetDateTime replayed) {
            this.replayed = replayed;
            return this;
        }

        public DeltaFileBuilder replayDid(String replayDid) {
            this.replayDid = replayDid;
            return this;
        }

        public DeltaFileBuilder inFlight(boolean inFlight) {
            this.inFlight$value = inFlight;
            this.inFlight$set = true;
            return this;
        }

        public DeltaFileBuilder terminal(boolean terminal) {
            this.terminal$value = terminal;
            this.terminal$set = true;
            return this;
        }

        public DeltaFileBuilder contentDeletable(boolean contentDeletable) {
            this.contentDeletable$value = contentDeletable;
            this.contentDeletable$set = true;
            return this;
        }

        @JsonIgnore
        public DeltaFileBuilder version(long version) {
            this.version = version;
            return this;
        }

        @JsonIgnore
        public DeltaFileBuilder cacheTime(OffsetDateTime cacheTime) {
            this.cacheTime$value = cacheTime;
            this.cacheTime$set = true;
            return this;
        }

        public DeltaFileBuilder snapshot(DeltaFile snapshot) {
            this.snapshot$value = snapshot;
            this.snapshot$set = true;
            return this;
        }

        public DeltaFileBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public DeltaFile build() {
            List<String> parentDids$value = this.parentDids$value;
            if (!this.parentDids$set) {
                parentDids$value = DeltaFile.$default$parentDids();
            }
            List<String> childDids$value = this.childDids$value;
            if (!this.childDids$set) {
                childDids$value = DeltaFile.$default$childDids();
            }
            List<DeltaFileFlow> flows$value = this.flows$value;
            if (!this.flows$set) {
                flows$value = DeltaFile.$default$flows();
            }
            Map<String, String> annotations$value = this.annotations$value;
            if (!this.annotations$set) {
                annotations$value = DeltaFile.$default$annotations();
            }
            Set<String> annotationKeys$value = this.annotationKeys$value;
            if (!this.annotationKeys$set) {
                annotationKeys$value = DeltaFile.$default$annotationKeys();
            }
            List<String> egressFlows$value = this.egressFlows$value;
            if (!this.egressFlows$set) {
                egressFlows$value = DeltaFile.$default$egressFlows();
            }
            boolean inFlight$value = this.inFlight$value;
            if (!this.inFlight$set) {
                inFlight$value = DeltaFile.$default$inFlight();
            }
            boolean terminal$value = this.terminal$value;
            if (!this.terminal$set) {
                terminal$value = DeltaFile.$default$terminal();
            }
            boolean contentDeletable$value = this.contentDeletable$value;
            if (!this.contentDeletable$set) {
                contentDeletable$value = DeltaFile.$default$contentDeletable();
            }
            OffsetDateTime cacheTime$value = this.cacheTime$value;
            if (!this.cacheTime$set) {
                cacheTime$value = DeltaFile.$default$cacheTime();
            }
            DeltaFile snapshot$value = this.snapshot$value;
            if (!this.snapshot$set) {
                snapshot$value = DeltaFile.$default$snapshot();
            }
            return new DeltaFile(this.did, this.name, this.normalizedName, this.dataSource, parentDids$value, this.aggregate, childDids$value, flows$value, this.requeueCount, this.ingressBytes, this.referencedBytes, this.totalBytes, this.stage, annotations$value, annotationKeys$value, egressFlows$value, this.created, this.modified, this.contentDeleted, this.contentDeletedReason, this.egressed, this.filtered, this.replayed, this.replayDid, inFlight$value, terminal$value, contentDeletable$value, this.version, cacheTime$value, snapshot$value, this.schemaVersion);
        }

        public String toString() {
            return "DeltaFile.DeltaFileBuilder(did=" + this.did + ", name=" + this.name + ", normalizedName=" + this.normalizedName + ", dataSource=" + this.dataSource + ", parentDids$value=" + String.valueOf(this.parentDids$value) + ", aggregate=" + this.aggregate + ", childDids$value=" + String.valueOf(this.childDids$value) + ", flows$value=" + String.valueOf(this.flows$value) + ", requeueCount=" + this.requeueCount + ", ingressBytes=" + this.ingressBytes + ", referencedBytes=" + this.referencedBytes + ", totalBytes=" + this.totalBytes + ", stage=" + String.valueOf((Object)this.stage) + ", annotations$value=" + String.valueOf(this.annotations$value) + ", annotationKeys$value=" + String.valueOf(this.annotationKeys$value) + ", egressFlows$value=" + String.valueOf(this.egressFlows$value) + ", created=" + String.valueOf(this.created) + ", modified=" + String.valueOf(this.modified) + ", contentDeleted=" + String.valueOf(this.contentDeleted) + ", contentDeletedReason=" + this.contentDeletedReason + ", egressed=" + this.egressed + ", filtered=" + this.filtered + ", replayed=" + String.valueOf(this.replayed) + ", replayDid=" + this.replayDid + ", inFlight$value=" + this.inFlight$value + ", terminal$value=" + this.terminal$value + ", contentDeletable$value=" + this.contentDeletable$value + ", version=" + this.version + ", cacheTime$value=" + String.valueOf(this.cacheTime$value) + ", snapshot$value=" + String.valueOf(this.snapshot$value) + ", schemaVersion=" + this.schemaVersion + ")";
        }
    }
}

