/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.deltafi.common.rules.RuleEvaluator;
import org.deltafi.common.types.Publisher;
import org.deltafi.common.types.Rule;
import org.deltafi.common.types.Subscriber;

public class RuleValidator {
    private final RuleEvaluator ruleEvaluator;

    public RuleValidator(RuleEvaluator ruleEvaluator) {
        this.ruleEvaluator = ruleEvaluator;
    }

    public List<String> validatePublisher(Publisher publisher) {
        if (publisher == null || publisher.publishRules() == null || publisher.publishRules().getRules() == null) {
            return List.of();
        }
        return this.validateRules(publisher.publishRules().getRules().stream().map(Rule::getCondition).collect(Collectors.toSet()));
    }

    public List<String> validateSubscriber(Subscriber subscriber) {
        if (subscriber == null || subscriber.subscribeRules() == null) {
            return List.of("Missing subscribe");
        }
        return this.validateRules(subscriber.subscribeRules().stream().map(Rule::getCondition).collect(Collectors.toSet()));
    }

    private List<String> validateRules(Set<String> conditions) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String condition : conditions) {
            try {
                this.ruleEvaluator.validateCondition(condition);
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        }
        return errors;
    }
}

