/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import org.deltafi.common.content.ContentStorageService;
import org.deltafi.common.types.CollectConfiguration;

public class ActionContext {
    private UUID did;
    private String deltaFileName;
    private String dataSource;
    private String flowName;
    private int flowId;
    private String actionName;
    private int actionId;
    private String actionVersion;
    private String hostname;
    private OffsetDateTime startTime;
    private String systemName;
    private ContentStorageService contentStorageService;
    private CollectConfiguration collect;
    private List<UUID> collectedDids;
    private String memo;

    public ActionContext copy(UUID newDid) {
        return new ActionContext(newDid, this.deltaFileName, this.dataSource, this.flowName, this.flowId, this.actionName, this.actionId, this.hostname, this.actionVersion, this.startTime, this.systemName, this.contentStorageService, this.collect, this.collectedDids, this.memo);
    }

    public static ActionContextBuilder builder() {
        return new ActionContextBuilder();
    }

    public UUID getDid() {
        return this.did;
    }

    public String getDeltaFileName() {
        return this.deltaFileName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public int getFlowId() {
        return this.flowId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public int getActionId() {
        return this.actionId;
    }

    public String getActionVersion() {
        return this.actionVersion;
    }

    public String getHostname() {
        return this.hostname;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public ContentStorageService getContentStorageService() {
        return this.contentStorageService;
    }

    public CollectConfiguration getCollect() {
        return this.collect;
    }

    public List<UUID> getCollectedDids() {
        return this.collectedDids;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setDid(UUID did) {
        this.did = did;
    }

    public void setDeltaFileName(String deltaFileName) {
        this.deltaFileName = deltaFileName;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public void setFlowId(int flowId) {
        this.flowId = flowId;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setActionVersion(String actionVersion) {
        this.actionVersion = actionVersion;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setContentStorageService(ContentStorageService contentStorageService) {
        this.contentStorageService = contentStorageService;
    }

    public void setCollect(CollectConfiguration collect) {
        this.collect = collect;
    }

    public void setCollectedDids(List<UUID> collectedDids) {
        this.collectedDids = collectedDids;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionContext)) {
            return false;
        }
        ActionContext other = (ActionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFlowId() != other.getFlowId()) {
            return false;
        }
        if (this.getActionId() != other.getActionId()) {
            return false;
        }
        UUID this$did = this.getDid();
        UUID other$did = other.getDid();
        if (this$did == null ? other$did != null : !((Object)this$did).equals(other$did)) {
            return false;
        }
        String this$deltaFileName = this.getDeltaFileName();
        String other$deltaFileName = other.getDeltaFileName();
        if (this$deltaFileName == null ? other$deltaFileName != null : !this$deltaFileName.equals(other$deltaFileName)) {
            return false;
        }
        String this$dataSource = this.getDataSource();
        String other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$flowName = this.getFlowName();
        String other$flowName = other.getFlowName();
        if (this$flowName == null ? other$flowName != null : !this$flowName.equals(other$flowName)) {
            return false;
        }
        String this$actionName = this.getActionName();
        String other$actionName = other.getActionName();
        if (this$actionName == null ? other$actionName != null : !this$actionName.equals(other$actionName)) {
            return false;
        }
        String this$actionVersion = this.getActionVersion();
        String other$actionVersion = other.getActionVersion();
        if (this$actionVersion == null ? other$actionVersion != null : !this$actionVersion.equals(other$actionVersion)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        OffsetDateTime this$startTime = this.getStartTime();
        OffsetDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        ContentStorageService this$contentStorageService = this.getContentStorageService();
        ContentStorageService other$contentStorageService = other.getContentStorageService();
        if (this$contentStorageService == null ? other$contentStorageService != null : !this$contentStorageService.equals(other$contentStorageService)) {
            return false;
        }
        CollectConfiguration this$collect = this.getCollect();
        CollectConfiguration other$collect = other.getCollect();
        if (this$collect == null ? other$collect != null : !((Object)this$collect).equals(other$collect)) {
            return false;
        }
        List<UUID> this$collectedDids = this.getCollectedDids();
        List<UUID> other$collectedDids = other.getCollectedDids();
        if (this$collectedDids == null ? other$collectedDids != null : !((Object)this$collectedDids).equals(other$collectedDids)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        return !(this$memo == null ? other$memo != null : !this$memo.equals(other$memo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFlowId();
        result = result * 59 + this.getActionId();
        UUID $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : ((Object)$did).hashCode());
        String $deltaFileName = this.getDeltaFileName();
        result = result * 59 + ($deltaFileName == null ? 43 : $deltaFileName.hashCode());
        String $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $flowName = this.getFlowName();
        result = result * 59 + ($flowName == null ? 43 : $flowName.hashCode());
        String $actionName = this.getActionName();
        result = result * 59 + ($actionName == null ? 43 : $actionName.hashCode());
        String $actionVersion = this.getActionVersion();
        result = result * 59 + ($actionVersion == null ? 43 : $actionVersion.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        OffsetDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        ContentStorageService $contentStorageService = this.getContentStorageService();
        result = result * 59 + ($contentStorageService == null ? 43 : $contentStorageService.hashCode());
        CollectConfiguration $collect = this.getCollect();
        result = result * 59 + ($collect == null ? 43 : ((Object)$collect).hashCode());
        List<UUID> $collectedDids = this.getCollectedDids();
        result = result * 59 + ($collectedDids == null ? 43 : ((Object)$collectedDids).hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        return result;
    }

    public String toString() {
        return "ActionContext(did=" + String.valueOf(this.getDid()) + ", deltaFileName=" + this.getDeltaFileName() + ", dataSource=" + this.getDataSource() + ", flowName=" + this.getFlowName() + ", flowId=" + this.getFlowId() + ", actionName=" + this.getActionName() + ", actionId=" + this.getActionId() + ", actionVersion=" + this.getActionVersion() + ", hostname=" + this.getHostname() + ", startTime=" + String.valueOf(this.getStartTime()) + ", systemName=" + this.getSystemName() + ", contentStorageService=" + String.valueOf(this.getContentStorageService()) + ", collect=" + String.valueOf(this.getCollect()) + ", collectedDids=" + String.valueOf(this.getCollectedDids()) + ", memo=" + this.getMemo() + ")";
    }

    public ActionContext(UUID did, String deltaFileName, String dataSource, String flowName, int flowId, String actionName, int actionId, String actionVersion, String hostname, OffsetDateTime startTime, String systemName, ContentStorageService contentStorageService, CollectConfiguration collect, List<UUID> collectedDids, String memo) {
        this.did = did;
        this.deltaFileName = deltaFileName;
        this.dataSource = dataSource;
        this.flowName = flowName;
        this.flowId = flowId;
        this.actionName = actionName;
        this.actionId = actionId;
        this.actionVersion = actionVersion;
        this.hostname = hostname;
        this.startTime = startTime;
        this.systemName = systemName;
        this.contentStorageService = contentStorageService;
        this.collect = collect;
        this.collectedDids = collectedDids;
        this.memo = memo;
    }

    public ActionContext() {
    }

    public static class ActionContextBuilder {
        private UUID did;
        private String deltaFileName;
        private String dataSource;
        private String flowName;
        private int flowId;
        private String actionName;
        private int actionId;
        private String actionVersion;
        private String hostname;
        private OffsetDateTime startTime;
        private String systemName;
        private ContentStorageService contentStorageService;
        private CollectConfiguration collect;
        private List<UUID> collectedDids;
        private String memo;

        ActionContextBuilder() {
        }

        public ActionContextBuilder did(UUID did) {
            this.did = did;
            return this;
        }

        public ActionContextBuilder deltaFileName(String deltaFileName) {
            this.deltaFileName = deltaFileName;
            return this;
        }

        public ActionContextBuilder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public ActionContextBuilder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public ActionContextBuilder flowId(int flowId) {
            this.flowId = flowId;
            return this;
        }

        public ActionContextBuilder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public ActionContextBuilder actionId(int actionId) {
            this.actionId = actionId;
            return this;
        }

        public ActionContextBuilder actionVersion(String actionVersion) {
            this.actionVersion = actionVersion;
            return this;
        }

        public ActionContextBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public ActionContextBuilder startTime(OffsetDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public ActionContextBuilder systemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        public ActionContextBuilder contentStorageService(ContentStorageService contentStorageService) {
            this.contentStorageService = contentStorageService;
            return this;
        }

        public ActionContextBuilder collect(CollectConfiguration collect) {
            this.collect = collect;
            return this;
        }

        public ActionContextBuilder collectedDids(List<UUID> collectedDids) {
            this.collectedDids = collectedDids;
            return this;
        }

        public ActionContextBuilder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public ActionContext build() {
            return new ActionContext(this.did, this.deltaFileName, this.dataSource, this.flowName, this.flowId, this.actionName, this.actionId, this.actionVersion, this.hostname, this.startTime, this.systemName, this.contentStorageService, this.collect, this.collectedDids, this.memo);
        }

        public String toString() {
            return "ActionContext.ActionContextBuilder(did=" + String.valueOf(this.did) + ", deltaFileName=" + this.deltaFileName + ", dataSource=" + this.dataSource + ", flowName=" + this.flowName + ", flowId=" + this.flowId + ", actionName=" + this.actionName + ", actionId=" + this.actionId + ", actionVersion=" + this.actionVersion + ", hostname=" + this.hostname + ", startTime=" + String.valueOf(this.startTime) + ", systemName=" + this.systemName + ", contentStorageService=" + String.valueOf(this.contentStorageService) + ", collect=" + String.valueOf(this.collect) + ", collectedDids=" + String.valueOf(this.collectedDids) + ", memo=" + this.memo + ")";
        }
    }
}

