/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.DataSourcePlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.TimedIngressActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class TimedDataSourcePlan
extends DataSourcePlan {
    private TimedIngressActionConfiguration timedIngressAction;
    private String cronSchedule;

    @PersistenceCreator
    @JsonCreator
    public TimedDataSourcePlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description, @JsonProperty(value="topic", required=true) String topic, @JsonProperty(value="timedIngressAction", required=true) TimedIngressActionConfiguration timedIngressAction, @JsonProperty(value="cronSchedule", required=true) String cronSchedule) {
        super(name, FlowType.TIMED_DATA_SOURCE, description, topic);
        this.timedIngressAction = timedIngressAction;
        this.cronSchedule = cronSchedule;
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.timedIngressAction != null) {
            actionConfigurations.add(this.timedIngressAction);
        }
        return actionConfigurations;
    }

    public TimedIngressActionConfiguration getTimedIngressAction() {
        return this.timedIngressAction;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    public void setTimedIngressAction(TimedIngressActionConfiguration timedIngressAction) {
        this.timedIngressAction = timedIngressAction;
    }

    public void setCronSchedule(String cronSchedule) {
        this.cronSchedule = cronSchedule;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimedDataSourcePlan)) {
            return false;
        }
        TimedDataSourcePlan other = (TimedDataSourcePlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimedIngressActionConfiguration this$timedIngressAction = this.getTimedIngressAction();
        TimedIngressActionConfiguration other$timedIngressAction = other.getTimedIngressAction();
        if (this$timedIngressAction == null ? other$timedIngressAction != null : !((Object)this$timedIngressAction).equals(other$timedIngressAction)) {
            return false;
        }
        String this$cronSchedule = this.getCronSchedule();
        String other$cronSchedule = other.getCronSchedule();
        return !(this$cronSchedule == null ? other$cronSchedule != null : !this$cronSchedule.equals(other$cronSchedule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimedDataSourcePlan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TimedIngressActionConfiguration $timedIngressAction = this.getTimedIngressAction();
        result = result * 59 + ($timedIngressAction == null ? 43 : ((Object)$timedIngressAction).hashCode());
        String $cronSchedule = this.getCronSchedule();
        result = result * 59 + ($cronSchedule == null ? 43 : $cronSchedule.hashCode());
        return result;
    }
}

