/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.queue.jackey;

import io.jackey.Jedis;
import io.jackey.JedisPool;
import io.jackey.Pipeline;
import io.jackey.params.ScanParams;
import io.jackey.params.ZAddParams;
import io.jackey.resps.ScanResult;
import io.jackey.resps.Tuple;
import io.jackey.util.KeyValue;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.deltafi.common.queue.jackey.SortedSetEntry;

public class JackeyKeyedBlockingQueue {
    private static final String HEARTBEAT_HASH = "org.deltafi.action-queue.heartbeat";
    private static final String LONG_RUNNING_TASKS_HASH = "org.deltafi.action-queue.long-running-tasks";
    private final JedisPool jedisPool;

    public JackeyKeyedBlockingQueue(String url, String password, int maxIdle, int maxTotal) throws URISyntaxException {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        URI uri = new URI(url);
        this.jedisPool = password == null || password.isEmpty() ? new JedisPool(poolConfig, uri) : new JedisPool(poolConfig, uri.getHost(), uri.getPort(), 2000, password);
    }

    public void put(SortedSetEntry entry) {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.put(jedis, entry);
        }
    }

    public boolean exists(String key, String search) {
        ScanParams scanParams = new ScanParams().match(search);
        try (Jedis jedis = this.jedisPool.getResource();){
            ScanResult scanResult = jedis.zscan(key, ScanParams.SCAN_POINTER_START, scanParams);
            boolean bl = !scanResult.getResult().isEmpty();
            return bl;
        }
    }

    public void drop(List<String> keys) {
        try (Jedis jedis = this.jedisPool.getResource();){
            this.drop(jedis, keys);
        }
    }

    private void drop(Jedis jedis, List<String> keys) {
        keys.forEach(arg_0 -> ((Jedis)jedis).del(arg_0));
    }

    private void put(Jedis jedis, SortedSetEntry entry) {
        jedis.zadd(entry.getKey(), (double)entry.getScoreEpochMilli(), entry.getValue(), ZAddParams.zAddParams().nx());
    }

    public void put(List<SortedSetEntry> items) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            items.forEach(item -> p.zadd(item.getKey(), (double)item.getScoreEpochMilli(), item.getValue(), ZAddParams.zAddParams().nx()));
            p.sync();
        }
    }

    public void setHeartbeat(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.hset(HEARTBEAT_HASH, key, OffsetDateTime.now().toString());
        }
    }

    public String take(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            KeyValue keyValue = jedis.bzpopmin(0.0, new String[]{key});
            String string = ((Tuple)keyValue.getValue()).getElement();
            return string;
        }
    }

    public Set<String> keys() {
        try (Jedis jedis = this.jedisPool.getResource();){
            Set set = jedis.keys("*");
            return set;
        }
    }

    public long sortedSetSize(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.zcard(key);
            return l;
        }
    }

    public Map<String, String> getLongRunningTasks() {
        try (Jedis jedis = this.jedisPool.getResource();){
            Map map = jedis.hgetAll(LONG_RUNNING_TASKS_HASH);
            return map;
        }
    }

    public String getLongRunningTask(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.hget(LONG_RUNNING_TASKS_HASH, key);
            return string;
        }
    }

    public void recordLongRunningTask(String key, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.hset(LONG_RUNNING_TASKS_HASH, key, value);
        }
    }

    public void removeLongRunningTask(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.hdel(LONG_RUNNING_TASKS_HASH, new String[]{key});
        }
    }
}

