/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.deltafi.common.types.ActionConfiguration;
import org.deltafi.common.types.FlowPlan;
import org.deltafi.common.types.FlowType;
import org.deltafi.common.types.PublishRules;
import org.deltafi.common.types.Publisher;
import org.deltafi.common.types.Rule;
import org.deltafi.common.types.Subscriber;
import org.deltafi.common.types.TransformActionConfiguration;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class TransformFlowPlan
extends FlowPlan
implements Publisher,
Subscriber {
    private List<TransformActionConfiguration> transformActions;
    @JsonProperty(required=true)
    private Set<Rule> subscribe;
    private PublishRules publish;

    public TransformFlowPlan(String name, String description) {
        super(name, FlowType.TRANSFORM, description);
    }

    @PersistenceCreator
    @JsonCreator
    public TransformFlowPlan(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type") FlowType type, @JsonProperty(value="description", required=true) String description) {
        this(name, description);
    }

    @Override
    public List<ActionConfiguration> allActionConfigurations() {
        ArrayList<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
        if (this.transformActions != null) {
            actionConfigurations.addAll(this.transformActions);
        }
        return actionConfigurations;
    }

    @Override
    public Set<Rule> subscribeRules() {
        return this.subscribe;
    }

    @Override
    public PublishRules publishRules() {
        return this.publish;
    }

    @Override
    public FlowType flowType() {
        return FlowType.TRANSFORM;
    }

    public List<TransformActionConfiguration> getTransformActions() {
        return this.transformActions;
    }

    public Set<Rule> getSubscribe() {
        return this.subscribe;
    }

    public PublishRules getPublish() {
        return this.publish;
    }

    public void setTransformActions(List<TransformActionConfiguration> transformActions) {
        this.transformActions = transformActions;
    }

    @JsonProperty(required=true)
    public void setSubscribe(Set<Rule> subscribe) {
        this.subscribe = subscribe;
    }

    public void setPublish(PublishRules publish) {
        this.publish = publish;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformFlowPlan)) {
            return false;
        }
        TransformFlowPlan other = (TransformFlowPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<TransformActionConfiguration> this$transformActions = this.getTransformActions();
        List<TransformActionConfiguration> other$transformActions = other.getTransformActions();
        if (this$transformActions == null ? other$transformActions != null : !((Object)this$transformActions).equals(other$transformActions)) {
            return false;
        }
        Set<Rule> this$subscribe = this.getSubscribe();
        Set<Rule> other$subscribe = other.getSubscribe();
        if (this$subscribe == null ? other$subscribe != null : !((Object)this$subscribe).equals(other$subscribe)) {
            return false;
        }
        PublishRules this$publish = this.getPublish();
        PublishRules other$publish = other.getPublish();
        return !(this$publish == null ? other$publish != null : !((Object)this$publish).equals(other$publish));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TransformFlowPlan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<TransformActionConfiguration> $transformActions = this.getTransformActions();
        result = result * 59 + ($transformActions == null ? 43 : ((Object)$transformActions).hashCode());
        Set<Rule> $subscribe = this.getSubscribe();
        result = result * 59 + ($subscribe == null ? 43 : ((Object)$subscribe).hashCode());
        PublishRules $publish = this.getPublish();
        result = result * 59 + ($publish == null ? 43 : ((Object)$publish).hashCode());
        return result;
    }
}

