/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.content;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class Segment {
    private UUID uuid;
    private long offset;
    private long size;
    private UUID did;

    public Segment(UUID did) {
        this(UUID.randomUUID(), did);
    }

    public Segment(Segment other) {
        this(other.getUuid(), other.getOffset(), other.getSize(), other.getDid());
    }

    public Segment(UUID uuid, UUID did) {
        this(uuid, 0L, -1L, did);
    }

    public String objectName() {
        return this.did.toString().substring(0, 3) + "/" + String.valueOf(this.did) + "/" + String.valueOf(this.uuid);
    }

    public static long calculateTotalSize(Set<Segment> segments) {
        HashMap<UUID, List> segmentsByUuid = new HashMap<UUID, List>();
        for (Segment segment : segments) {
            segmentsByUuid.computeIfAbsent(segment.getUuid(), k -> new ArrayList()).add(segment);
        }
        long totalSize = 0L;
        for (List uuidSegments : segmentsByUuid.values()) {
            totalSize += Segment.calculateNonOverlappingSize(uuidSegments);
        }
        return totalSize;
    }

    private static long calculateNonOverlappingSize(List<Segment> uuidSegments) {
        if (uuidSegments.size() == 1) {
            return uuidSegments.getFirst().getSize();
        }
        ArrayList<Segment> sortedSegments = new ArrayList<Segment>(uuidSegments);
        sortedSegments.sort(Comparator.comparingLong(Segment::getOffset));
        long totalSize = 0L;
        Segment mergedSegment = (Segment)sortedSegments.getFirst();
        for (int i = 1; i < sortedSegments.size(); ++i) {
            Segment segment = (Segment)sortedSegments.get(i);
            if (segment.getOffset() >= mergedSegment.getOffset() + mergedSegment.getSize()) {
                totalSize += mergedSegment.getSize();
                mergedSegment = segment;
                continue;
            }
            long endPosition = Math.max(mergedSegment.getOffset() + mergedSegment.getSize(), segment.getOffset() + segment.getSize());
            mergedSegment = new Segment(mergedSegment.getUuid(), mergedSegment.getOffset(), endPosition - mergedSegment.getOffset(), mergedSegment.getDid());
        }
        return totalSize += mergedSegment.getSize();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public UUID getDid() {
        return this.did;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setDid(UUID did) {
        this.did = did;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        UUID this$did = this.getDid();
        UUID other$did = other.getDid();
        return !(this$did == null ? other$did != null : !((Object)this$did).equals(other$did));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Segment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        UUID $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : ((Object)$did).hashCode());
        return result;
    }

    public String toString() {
        return "Segment(uuid=" + String.valueOf(this.getUuid()) + ", offset=" + this.getOffset() + ", size=" + this.getSize() + ", did=" + String.valueOf(this.getDid()) + ")";
    }

    public Segment() {
    }

    public Segment(UUID uuid, long offset, long size, UUID did) {
        this.uuid = uuid;
        this.offset = offset;
        this.size = size;
        this.did = did;
    }
}

