/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.deltafi.common.http.HttpPostException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService {
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    private final HttpClient httpClient;

    @NotNull
    public HttpResponse<InputStream> post(@NotNull String url, @NotNull Map<String, String> headers, @NotNull InputStream body, @NotNull String mediaType) throws HttpPostException {
        Supplier<InputStream> is = () -> body;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).setHeader("content-type", mediaType).POST(HttpRequest.BodyPublishers.ofInputStream(is));
        HttpService.addHeaders(requestBuilder, headers);
        HttpRequest request = requestBuilder.build();
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException | IllegalArgumentException | InterruptedException | SecurityException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new HttpPostException(e.getClass().getSimpleName(), e.getMessage());
        }
    }

    private static void addHeaders(@NotNull HttpRequest.Builder builder, @NotNull Map<String, String> headers) {
        if (!headers.isEmpty()) {
            builder.headers((String[])headers.entrySet().stream().flatMap(x -> Stream.of((String)x.getKey(), (String)x.getValue())).toArray(String[]::new));
        }
    }

    public HttpService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

