/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.nifi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.nifi.util.FlowFilePackager;
import org.apache.nifi.util.FlowFilePackagerV1;
import org.deltafi.common.io.WriterPipedInputStream;

public class FlowFileInputStream
extends WriterPipedInputStream {
    private final InputStream inputStream;

    public static FlowFileInputStream create(InputStream inputStream, Map<String, String> attributes, long fileSize, ExecutorService executorService) throws IOException {
        return FlowFileInputStream.create((FlowFilePackager)new FlowFilePackagerV1(), inputStream, attributes, fileSize, executorService);
    }

    public static FlowFileInputStream create(FlowFilePackager flowFilePackager, InputStream inputStream, Map<String, String> attributes, long fileSize, ExecutorService executorService) throws IOException {
        FlowFileInputStream flowFileInputStream = new FlowFileInputStream(flowFilePackager, inputStream, attributes, fileSize, executorService);
        flowFileInputStream.runPipeWriter();
        return flowFileInputStream;
    }

    private FlowFileInputStream(FlowFilePackager flowFilePackager, InputStream inputStream, Map<String, String> attributes, long fileSize, ExecutorService executorService) throws IOException {
        super((OutputStream outputStream) -> flowFilePackager.packageFlowFile(inputStream, outputStream, attributes, fileSize), executorService);
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputStream.close();
    }
}

