/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.io;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.deltafi.common.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterPipedInputStream
extends PipedInputStream {
    private static final Logger log = LoggerFactory.getLogger(WriterPipedInputStream.class);
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private final Writer writer;
    private final ExecutorService executorService;
    private final PipedOutputStream pipedOutputStream;
    private Future<?> future;

    public static WriterPipedInputStream create(Writer writer, ExecutorService executorService) throws IOException {
        return WriterPipedInputStream.create(writer, executorService, 524288);
    }

    public static WriterPipedInputStream create(Writer writer, ExecutorService executorService, int bufferSize) throws IOException {
        WriterPipedInputStream writerPipedInputStream = new WriterPipedInputStream(writer, executorService, bufferSize);
        writerPipedInputStream.runPipeWriter();
        return writerPipedInputStream;
    }

    protected WriterPipedInputStream(Writer writer, ExecutorService executorService) throws IOException {
        this(writer, executorService, 524288);
    }

    protected WriterPipedInputStream(Writer writer, ExecutorService executorService, int bufferSize) throws IOException {
        super(bufferSize);
        this.writer = writer;
        this.executorService = executorService;
        this.pipedOutputStream = new PipedOutputStream(this);
    }

    protected void runPipeWriter() {
        this.future = this.executorService.submit(() -> {
            block8: {
                try (PipedOutputStream pipedOutputStream = this.pipedOutputStream;){
                    this.writer.write(this.pipedOutputStream);
                }
                catch (IOException e) {
                    if (e.getMessage().equals("Pipe closed")) break block8;
                    log.warn("Write failed", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.future != null) {
            this.future.cancel(true);
        }
    }
}

