/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.storage.s3.minio;

import io.minio.GetObjectArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.SnowballObject;
import io.minio.UploadSnowballObjectsArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.ErrorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.deltafi.common.storage.s3.MissingContentException;
import org.deltafi.common.storage.s3.ObjectReference;
import org.deltafi.common.storage.s3.ObjectStorageException;
import org.deltafi.common.storage.s3.ObjectStorageService;
import org.deltafi.common.storage.s3.minio.MinioProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioObjectStorageService
implements ObjectStorageService {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectStorageService.class);
    protected final MinioClient minioClient;
    protected final MinioProperties minioProperties;

    @Override
    public InputStream getObject(ObjectReference objectReference) throws ObjectStorageException {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).offset(Long.valueOf(objectReference.getOffset()))).length(Long.valueOf(objectReference.getSize()))).build());
        }
        catch (ErrorResponseException e) {
            ErrorResponse errorResponse = e.errorResponse();
            if (errorResponse != null && "NoSuchKey".equals(errorResponse.code())) {
                throw new MissingContentException(errorResponse.message());
            }
            throw new ObjectStorageException("Failed to get object from minio", e);
        }
        catch (InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ObjectStorageException("Failed to get object from minio", e);
        }
    }

    @Override
    public ObjectReference putObject(ObjectReference objectReference, InputStream inputStream) throws ObjectStorageException {
        try {
            BoundedInputStream boundedInputStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(inputStream)).get();
            ObjectWriteResponse objectWriteResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).stream((InputStream)boundedInputStream, objectReference.getSize(), this.minioProperties.getPartSize()).build());
            if (objectWriteResponse == null) {
                throw new ObjectStorageException("Failed to send the incoming data to minio");
            }
            return new ObjectReference(objectWriteResponse.bucket(), objectWriteResponse.object(), 0L, boundedInputStream.getCount());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to save incoming object", e);
            throw new ObjectStorageException("Failed to send incoming data to minio", e);
        }
    }

    @Override
    public void putObjects(String bucket, Map<ObjectReference, InputStream> inputStreamMap) throws ObjectStorageException {
        try {
            this.minioClient.uploadSnowballObjects((UploadSnowballObjectsArgs)((UploadSnowballObjectsArgs.Builder)UploadSnowballObjectsArgs.builder().bucket(bucket)).objects(inputStreamMap.entrySet().stream().map(this::createSnowballObject).toList()).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to save incoming object", e);
            throw new ObjectStorageException("Failed to send incoming data to minio", e);
        }
    }

    private SnowballObject createSnowballObject(Map.Entry<ObjectReference, InputStream> objectReferenceInputStreamEntry) {
        ObjectReference objectReference = objectReferenceInputStreamEntry.getKey();
        return new SnowballObject(objectReference.getName(), objectReferenceInputStreamEntry.getValue(), objectReference.getSize(), null);
    }

    @Override
    public void removeObject(ObjectReference objectReference) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(objectReference.getBucket())).object(objectReference.getName())).build());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Failed to remove object {} from bucket {}", (Object)objectReference.getName(), (Object)objectReference.getBucket());
        }
    }

    @Override
    public boolean removeObjects(String bucket, List<String> objectNames) {
        List<DeleteObject> objectsInStorage = objectNames.stream().map(DeleteObject::new).toList();
        log.info("Sending command to delete {} objects in storage from minio", (Object)objectsInStorage.size());
        Iterable removeResults = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucket)).objects(objectsInStorage).build());
        boolean hasError = false;
        for (Result removeResult : removeResults) {
            hasError = true;
            try {
                DeleteError error = (DeleteError)removeResult.get();
                log.error("Failed to remove object {} with an error of {}", (Object)error.objectName(), (Object)error.message());
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                log.error("Failed to remove object: {}", (Object)e.getMessage());
            }
        }
        return !hasError;
    }

    public MinioObjectStorageService(MinioClient minioClient, MinioProperties minioProperties) {
        this.minioClient = minioClient;
        this.minioProperties = minioProperties;
    }
}

