/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.deltafi.common.types.ActionDescriptor;
import org.deltafi.common.types.ActionType;
import org.deltafi.common.types.CollectConfiguration;
import org.deltafi.common.types.EgressActionConfiguration;
import org.deltafi.common.types.TimedIngressActionConfiguration;
import org.deltafi.common.types.TransformActionConfiguration;
import org.springframework.data.annotation.Transient;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="__typename")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TimedIngressActionConfiguration.class, name="TimedIngressActionConfiguration"), @JsonSubTypes.Type(value=TransformActionConfiguration.class, name="TransformActionConfiguration"), @JsonSubTypes.Type(value=EgressActionConfiguration.class, name="EgressActionConfiguration")})
public abstract class ActionConfiguration {
    protected String name;
    protected String apiVersion;
    @JsonIgnore
    @Transient
    protected final ActionType actionType;
    protected final String type;
    @JsonIgnore
    protected Map<String, Object> internalParameters;
    protected Map<String, Object> parameters;
    protected CollectConfiguration collect;

    protected ActionConfiguration(String name, ActionType actionType, String type) {
        this.name = name;
        this.actionType = actionType;
        this.type = type;
    }

    public List<String> validate(ActionDescriptor actionDescriptor) {
        ArrayList<String> errors = new ArrayList<String>();
        if (actionDescriptor.getType() != this.actionType) {
            errors.add("Action: " + this.type + " is not registered as an action of type " + String.valueOf((Object)this.actionType));
        }
        if (this.collect != null) {
            errors.addAll(this.collect.validate());
        }
        return errors;
    }

    public Map<String, Object> getInternalParameters() {
        if (Objects.isNull(this.internalParameters)) {
            this.setInternalParameters(Objects.requireNonNullElse(this.parameters, Collections.emptyMap()));
        }
        return this.internalParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public CollectConfiguration getCollect() {
        return this.collect;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonIgnore
    public void setInternalParameters(Map<String, Object> internalParameters) {
        this.internalParameters = internalParameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setCollect(CollectConfiguration collect) {
        this.collect = collect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionConfiguration)) {
            return false;
        }
        ActionConfiguration other = (ActionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$internalParameters = this.getInternalParameters();
        Map<String, Object> other$internalParameters = other.getInternalParameters();
        if (this$internalParameters == null ? other$internalParameters != null : !((Object)this$internalParameters).equals(other$internalParameters)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        CollectConfiguration this$collect = this.getCollect();
        CollectConfiguration other$collect = other.getCollect();
        return !(this$collect == null ? other$collect != null : !((Object)this$collect).equals(other$collect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $internalParameters = this.getInternalParameters();
        result = result * 59 + ($internalParameters == null ? 43 : ((Object)$internalParameters).hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        CollectConfiguration $collect = this.getCollect();
        result = result * 59 + ($collect == null ? 43 : ((Object)$collect).hashCode());
        return result;
    }

    public String toString() {
        return "ActionConfiguration(super=" + super.toString() + ", name=" + this.getName() + ", apiVersion=" + this.getApiVersion() + ", actionType=" + String.valueOf((Object)this.getActionType()) + ", type=" + this.getType() + ", parameters=" + String.valueOf(this.getParameters()) + ", collect=" + String.valueOf(this.getCollect()) + ")";
    }
}

