/*
 * Decompiled with CFR 0.152.
 */
package org.deltafi.common.types;

import java.time.OffsetDateTime;
import java.util.List;
import org.deltafi.common.types.TestStatus;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class TestResult {
    @Id
    private String id;
    private TestStatus status;
    private OffsetDateTime start;
    private OffsetDateTime stop;
    private List<String> errors;

    protected TestResult(TestResultBuilder<?, ?> b) {
        this.id = b.id;
        this.status = b.status;
        this.start = b.start;
        this.stop = b.stop;
        this.errors = b.errors;
    }

    public static TestResultBuilder<?, ?> builder() {
        return new TestResultBuilderImpl();
    }

    public String getId() {
        return this.id;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getStart() {
        return this.start;
    }

    public OffsetDateTime getStop() {
        return this.stop;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStatus(TestStatus status) {
        this.status = status;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public void setStop(OffsetDateTime stop) {
        this.stop = stop;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestResult)) {
            return false;
        }
        TestResult other = (TestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        TestStatus this$status = this.getStatus();
        TestStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        OffsetDateTime this$start = this.getStart();
        OffsetDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        OffsetDateTime this$stop = this.getStop();
        OffsetDateTime other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        TestStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        OffsetDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        OffsetDateTime $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "TestResult(id=" + this.getId() + ", status=" + String.valueOf((Object)this.getStatus()) + ", start=" + String.valueOf(this.getStart()) + ", stop=" + String.valueOf(this.getStop()) + ", errors=" + String.valueOf(this.getErrors()) + ")";
    }

    public TestResult() {
    }

    public TestResult(String id, TestStatus status, OffsetDateTime start, OffsetDateTime stop, List<String> errors) {
        this.id = id;
        this.status = status;
        this.start = start;
        this.stop = stop;
        this.errors = errors;
    }

    public static abstract class TestResultBuilder<C extends TestResult, B extends TestResultBuilder<C, B>> {
        private String id;
        private TestStatus status;
        private OffsetDateTime start;
        private OffsetDateTime stop;
        private List<String> errors;

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B status(TestStatus status) {
            this.status = status;
            return this.self();
        }

        public B start(OffsetDateTime start) {
            this.start = start;
            return this.self();
        }

        public B stop(OffsetDateTime stop) {
            this.stop = stop;
            return this.self();
        }

        public B errors(List<String> errors) {
            this.errors = errors;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "TestResult.TestResultBuilder(id=" + this.id + ", status=" + String.valueOf((Object)this.status) + ", start=" + String.valueOf(this.start) + ", stop=" + String.valueOf(this.stop) + ", errors=" + String.valueOf(this.errors) + ")";
        }
    }

    private static final class TestResultBuilderImpl
    extends TestResultBuilder<TestResult, TestResultBuilderImpl> {
        private TestResultBuilderImpl() {
        }

        @Override
        protected TestResultBuilderImpl self() {
            return this;
        }

        @Override
        public TestResult build() {
            return new TestResult(this);
        }
    }
}

