/*
 * Decompiled with CFR 0.152.
 */
package org.derive4j.processor.fj;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.derive4j.processor.api.DerivatorFactory;
import org.derive4j.processor.api.DerivatorSelection;
import org.derive4j.processor.api.DerivatorSelections;
import org.derive4j.processor.api.DeriveUtils;
import org.derive4j.processor.api.model.DataConstructor;

@AutoService(value=DerivatorFactory.class)
public final class FunctionalJavaTypeClassesDerivations
implements DerivatorFactory {
    private static final List<Integer> PRIMES = Arrays.asList(23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997);

    public List<DerivatorSelection> derivators(DeriveUtils deriveUtils) {
        ClassName showClass = ClassName.get((String)"fj", (String)"Show", (String[])new String[0]);
        ClassName hashClass = ClassName.get((String)"fj", (String)"Hash", (String[])new String[0]);
        ClassName equalClass = ClassName.get((String)"fj", (String)"Equal", (String[])new String[0]);
        ClassName ordClass = ClassName.get((String)"fj", (String)"Ord", (String[])new String[0]);
        ClassName ordering = ClassName.get((String)"fj", (String)"Ordering", (String[])new String[0]);
        ClassName streamClass = ClassName.get((String)"fj.data", (String)"Stream", (String[])new String[0]);
        return Arrays.asList(DerivatorSelections.selection((ClassName)showClass, adt -> deriveUtils.generateInstance(adt, showClass, Collections.emptyList(), instanceUtils -> instanceUtils.generateInstanceFactory(CodeBlock.builder().add("$1T.show($2L -> $2L.", new Object[]{showClass, instanceUtils.adtVariableName()}).add(instanceUtils.matchImpl(constructor -> deriveUtils.lambdaImpl(constructor, CodeBlock.builder().add("$T.fromString($S).append(() -> ", new Object[]{streamClass, constructor.name() + "("}).add(constructor.arguments().stream().map(da -> instanceUtils.instanceFor(da).toBuilder().add(".show($L)", new Object[]{da.fieldName()}).build()).reduce((cb1, cb2) -> cb1.toBuilder().add(".append($T.fromString($S)).append(() -> ", new Object[]{streamClass, ", "}).add(cb2).add(")", new Object[0]).build()).orElse(CodeBlock.of((String)"$T.nil()", (Object[])new Object[]{streamClass}))).add(").append($T.fromString($S))", new Object[]{streamClass, ")"}).build()))).add(")", new Object[0]).build(), new CodeBlock[0]))), DerivatorSelections.selection((ClassName)hashClass, adt -> deriveUtils.generateInstance(adt, hashClass, Collections.emptyList(), instanceUtils -> instanceUtils.generateInstanceFactory(CodeBlock.builder().add("$1T.hash($2L -> $2L.", new Object[]{hashClass, instanceUtils.adtVariableName()}).add(instanceUtils.matchImpl(constructor -> {
            int nbConstructors = adt.dataConstruction().constructors().size();
            int constructorIndex = IntStream.range(0, nbConstructors).filter(i -> ((DataConstructor)adt.dataConstruction().constructors().get(i)).name().equals(constructor.name())).findFirst().getAsInt();
            return deriveUtils.lambdaImpl(constructor, CodeBlock.builder().add("$L", new Object[]{IntStream.range(0, constructor.arguments().size() - 1).mapToObj(__ -> "(").collect(Collectors.joining())}).add(PRIMES.get(constructorIndex).toString(), new Object[0]).add(constructor.arguments().stream().map(da -> CodeBlock.builder().add(" + ", new Object[0]).add(instanceUtils.instanceFor(da)).add(".hash($L)", new Object[]{da.fieldName()}).build()).reduce((cb1, cb2) -> cb1.toBuilder().add(") * " + PRIMES.get(constructorIndex), new Object[0]).add(cb2).build()).orElse(CodeBlock.of((String)"", (Object[])new Object[0]))).build());
        })).add(")", new Object[0]).build(), new CodeBlock[0]))), DerivatorSelections.selection((ClassName)equalClass, adt -> deriveUtils.generateInstance(adt, equalClass, Collections.emptyList(), instanceUtils -> instanceUtils.generateInstanceFactory(CodeBlock.builder().add("$1T.equalDef($2L -> $2L.", new Object[]{equalClass, instanceUtils.adtVariableName() + 1}).add(instanceUtils.matchImpl(constructor -> {
            String adt2 = instanceUtils.adtVariableName() + 2;
            return deriveUtils.lambdaImpl(constructor, "1", CodeBlock.builder().add("$1L -> $1L.", new Object[]{adt2}).add(instanceUtils.matchImpl(constructor2 -> deriveUtils.lambdaImpl(constructor2, "2", constructor.name().equals(constructor2.name()) ? constructor.arguments().stream().map(da -> CodeBlock.builder().add(instanceUtils.instanceFor(da)).add(".eq($L, $L)", new Object[]{da.fieldName() + "1", da.fieldName() + "2"}).build()).reduce((cb1, cb2) -> cb1.toBuilder().add(" && ", new Object[0]).add(cb2).build()).orElse(CodeBlock.of((String)"true", (Object[])new Object[0])) : CodeBlock.of((String)"false", (Object[])new Object[0])))).build());
        })).add(")", new Object[0]).build(), new CodeBlock[0]))), DerivatorSelections.selection((ClassName)ordClass, adt -> deriveUtils.generateInstance(adt, ordClass, Collections.emptyList(), instanceUtils -> instanceUtils.generateInstanceFactory(CodeBlock.builder().add("$1T.ordDef($2L -> $2L.", new Object[]{ordClass, instanceUtils.adtVariableName() + 1}).add(instanceUtils.matchImpl(constructor -> {
            String adt2 = instanceUtils.adtVariableName() + 2;
            return deriveUtils.lambdaImpl(constructor, "1", CodeBlock.builder().add("$1L -> $1L.", new Object[]{adt2}).add(instanceUtils.matchImpl(constructor2 -> deriveUtils.lambdaImpl(constructor2, "2", constructor.name().equals(constructor2.name()) ? CodeBlock.builder().add("{\n", new Object[0]).indent().addStatement("$1T o = $1T.EQ", new Object[]{ordering}).add(constructor.arguments().stream().map(da -> CodeBlock.builder().add("o = ", new Object[0]).add(instanceUtils.instanceFor(da)).add(".compare($L, $L);\n", new Object[]{da.fieldName() + "1", da.fieldName() + "2"}).addStatement("if (o != $T.EQ) return o", new Object[]{ordering}).build()).reduce((cb1, cb2) -> cb1.toBuilder().add(cb2).build()).orElse(CodeBlock.of((String)"", (Object[])new Object[0]))).addStatement("return o", new Object[0]).unindent().add("}", new Object[0]).build() : CodeBlock.of((String)"$T.$L", (Object[])new Object[]{ordering, constructor.index() < constructor2.index() ? "LT" : "GT"})))).build());
        })).add(")", new Object[0]).build(), new CodeBlock[0]))));
    }
}

